/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/*{generator option: parentheses = true}*/
/*{generator option: writeString = output.write}*/

/* *
* EntityAbstractGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1732 $
*
* Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim. 20 déc. 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.shouldBeAbstract;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isPrimitiveType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isDateType;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;


/**
 * Generateur d'entites abstraites. Il s'agit de l'implatation par defaut d'une
 * entite. Les classes generees sont surchargees par un XXXImpl lorsque l'entite
 * n'est pas abstraite. La surcharge peut etre ecrite par l'utilisateur.
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link EntityAbstractTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityAbstractGenerator" 
 */
@Deprecated
public class EntityAbstractGenerator extends ObjectModelGenerator {

    /** Logger for this class */
    private static final Log log = LogFactory.getLog(EntityAbstractGenerator.class);

    // TODO THIMEL : Je pense qu'il faudrait que l'EntityInterfaceGenerator 
    // hérite de ce générateur, avec generateBody qui renvoie false, et que dans
    // ce générateur, on ne génère pas les corps de méthode, etc ... quand 
    // generateBoody() renvoie false 
    protected boolean generateBody() {
    	return true;
    }

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "Abstract.java";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
        String clazzName = clazz.getName();
        String clazzFQN = TopiaGeneratorUtil.getSimpleName(clazz.getQualifiedName());
/*{package <%=clazz.getPackageName()%>;
}*/
        List<String> imports = TopiaGeneratorUtil.getImports(clazz,
                org.apache.commons.lang.builder.ToStringBuilder.class.getName(),
                org.nuiton.topia.TopiaException.class.getName(),
                org.nuiton.topia.framework.TopiaContextImplementor.class.getName(),
                org.nuiton.topia.persistence.TopiaEntity.class.getName(),
                TopiaEntityAbstract.class.getName(),
                org.nuiton.topia.persistence.EntityVisitor.class.getName(),
                java.util.List.class.getName(),
                java.util.ArrayList.class.getName(),
                java.io.Serializable.class.getName()
        );
        if (log.isDebugEnabled()) {
            log.debug("imports for class <" + clazzFQN + ">");
        }
        for (String anImport : imports) {
            if (log.isDebugEnabled()) {
                log.debug("import " + anImport);
            }
/*{import <%=anImport%>;
}*/
        }
/*{
/**
 * Implantation POJO pour l'entité {@link <%=StringUtils.capitalize(clazzFQN)%>}.
}*/
        {
            String dbName = clazz.getTagValue(TopiaGeneratorUtil.TAG_DB_NAME);
            if (dbName != null) {
/*{ *
 * <p>Nom de l'entité en BD : <%=dbName%>.</p>               
}*/
            }
        }
/*{ *)
}*/
        String extendClass = "";
        for (Iterator<ObjectModelClass> i = clazz.getSuperclasses().iterator(); i.hasNext();) {
            ObjectModelClass parent = i.next();
            extendClass += parent.getQualifiedName();
            //Si une des classes parentes définies des méthodes abstraites, son
            // impl ne sera pas créé
            boolean abstractParent = false;
            if (parent instanceof ObjectModelClass) {
                abstractParent = shouldBeAbstract(parent);
            }
            if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                if (abstractParent) {
                    extendClass += "Abstract";
                } else {
                    extendClass += "Impl";
                }
            }
            if (i.hasNext()) {
                extendClass += ", ";
            }
        }
        if (extendClass.length() == 0) {
            extendClass += TopiaEntityAbstract.class.getSimpleName();
        }

/*{public abstract class <%=clazzName%>Abstract extends <%=extendClass%> implements <%=clazzName%> {

}*/

        String svUID = TopiaGeneratorUtil.findTagValue("serialVersionUID", clazz, model);
        if (svUID != null) {
/*{    public static final long serialVersionUID = <%=svUID%>;

}*/
        }
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }
            if (TopiaGeneratorUtil.hasDocumentation(attr) || attr.hasTagValue(TopiaGeneratorUtil.TAG_DB_NAME)) {
/*{    /**
}*/
                if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                	String attrDocumentation = attr.getDocumentation();
/*{     * <%=attrDocumentation%>
}*/
                }
                if (attr.hasTagValue(TopiaGeneratorUtil.TAG_DB_NAME)) {
                	String dbName = attr.getTagValue(TopiaGeneratorUtil.TAG_DB_NAME);
/*{     * Nom de l'attribut en BD : <%=dbName%>.
}*/
                }
/*{    *)
}*/
            }
            if (attr.hasTagValue(TopiaGeneratorUtil.TAG_ANNOTATION)) {
            	String annotation = attr.getTagValue(TopiaGeneratorUtil.TAG_ANNOTATION);
/*{    <%=annotation%>
}*/
            }

            String attrVisibility = attr.getVisibility();

            // In case attribute is NMultiplicity
            String collectionType = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr));

            if (!attr.hasAssociationClass()) {
                String attrName = attr.getName();
                String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{    <%=attrVisibility%> <%=attrType%> <%=attrName%>;

}*/
                } else {
/*{    <%=attrVisibility%> <%=collectionType%><<%=attrType%>> <%=attrName%>;

}*/
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                	//TODO THIMEL : Je pense que les GeneratorUtil.toLowerCaseFirstLetter sont inutiles ici, ou alors il faudrait le faire partout
/*{    <%=attrVisibility%> <%=assocClassFQN%> <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;

}*/
                } else {
/*{    <%=attrVisibility%> <%=collectionType%><<%=assocClassFQN%>> <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;

}*/
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrVisibility = attr.getVisibility();
                    String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                    String attrName = attr.getName();
/*{    <%=attrVisibility%> <%=attrType%> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>;

}*/
                }
            }
        }

/*{    /**
     * Constructeur de <%=clazzName%>Abstract par défaut.
     *)
    public <%=clazzName%>Abstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(<%=clazzName%>.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(<%=clazzName%>.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     *)
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
}*/

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }

            if (!attr.hasAssociationClass()) {
            	String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
            	String attrName = attr.getName();
                if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{        visitor.visit(this, "<%=attrName%>", <%=attrType%>.class, <%=attrName%>);
}*/
                } else {
                    String collectionType = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr));
/*{        visitor.visit(this, "<%=attrName%>", <%=collectionType%>.class, <%=attrType%>.class, <%=attrName%>);
}*/
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                assocAttrName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
                if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{        visitor.visit(this, "<%=assocAttrName%>", <%=assocClassFQN%>.class, <%=assocAttrName%>);
}*/
                } else {
                    String collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
/*{        visitor.visit(this, "<%=assocAttrName%>", <%=collectionType%>.class, <%=assocClassFQN%>.class, <%=assocAttrName%>);
}*/
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                	String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                	String attrName = attr.getName();
                        attrName = GeneratorUtil.toLowerCaseFirstLetter(attrName);
/*{        visitor.visit(this, "<%=attrName%>", <%=attrType%>.class, <%=attrName%>);
}*/
                }
            }
        }
/*{        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
}*/
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.referenceClassifier() && attr.getClassifier().hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                if (attr.isAggregate()) {
                	String attrName = attr.getName();
                        String getterName  = "get" + StringUtils.capitalize(attrName);
                    if (GeneratorUtil.isNMultiplicity(attr)) {
/*{        tmp.addAll(<%=getterName%>());
}*/
                    } else {
/*{        tmp.add(<%=getterName%>());
}*/
                    }
                }
            }
        }
/*{
        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
}*/
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.referenceClassifier() && attr.getClassifier().hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                if (attr.isComposite()) {
                    String attrName = attr.getName();
                    String getterName  = "get" + StringUtils.capitalize(attrName);
                    if (GeneratorUtil.isNMultiplicity(attr)) {
/*{        if (<%=getterName%>() != null) {
              tmp.addAll(<%=getterName%>());
           }
}*/
                    } else {
/*{        tmp.add(<%=getterName%>());
}*/
                    }
                } else if (attr.hasAssociationClass()) {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
                    String ref = "this." + GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                    if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{
        if (<%=ref%> != null) {
            tmp.add(<%=ref%>);
        }
}*/
                    } else {
                    	ObjectModelAttribute reverse = attr.getReverseAttribute();
                    	String reverseAttrName = reverse.getName();
                        // On utilise pas l'attribut car il est potentiellement
                        // pas a jour, car  pour les asso avec cardinalité
                        // personne ne fait de add. Ce qui est normal, mais
                        // pour pouvoir faire tout de meme des delete en cascade
                        // sur les asso, le champs est dans le mapping
                        // hibernate et donc il le faut aussi dans la classe
                        // sinon hibernate rale lorsqu'il charge l'objet
//                        if (<%=ref%> != null) {
//                            tmp.addAll(<%=ref%>);
//                        }
/*{
        {
            org.nuiton.topia.persistence.TopiaDAO<<%=assocClassFQN%>> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(<%=assocClassFQN%>.class);
            List<<%=assocClassFQN%>> findAllByProperties = dao.findAllByProperties("<%=reverseAttrName%>", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
}*/
                    }
                }
            }
        }
/*{
        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

}*/

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            String attrName = attr.getName();
            String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());

            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model))) {
                continue;
            }
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
/*{    /* (non-Javadoc)
     * @see <%=clazzFQN%>#set<%=StringUtils.capitalize(attrName)%>(<%=attrType%>)
     *)
    @Override
    public void set<%=StringUtils.capitalize(attrName)%>(<%=attrType%> value) {
        <%=attrType%> _oldValue = this.<%=attrName%>;
        fireOnPreWrite("<%=attrName%>", _oldValue, value);
        this.<%=attrName%> = value;
        fireOnPostWrite("<%=attrName%>", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#get<%=StringUtils.capitalize(attrName)%>()
     *)
    @Override
    public <%=attrType%> get<%=StringUtils.capitalize(attrName)%>() {
        fireOnPreRead("<%=attrName%>", <%=attrName%>);
        <%=attrType%> result = this.<%=attrName%>;
        fireOnPostRead("<%=attrName%>", <%=attrName%>);
        return result;
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
/*{    /* (non-Javadoc)
     * @see <%=clazzFQN%>#set<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%>)
     *)
    @Override
    public void set<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%> association) {
        <%=assocClassFQN%> _oldValue = this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
        fireOnPreWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", _oldValue, association);
        this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = association;
        fireOnPostWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", _oldValue, association);
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#get<%=StringUtils.capitalize(assocAttrName)%>()
     *)
    @Override
    public <%=assocClassFQN%> get<%=StringUtils.capitalize(assocAttrName)%>() {
        return <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
    }

}*/
                }
            } else { //NMultiplicity
                String collectionInterface = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr));
                String collectionObject = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityObjectType(attr));
                if (!attr.hasAssociationClass()) { //Méthodes remplacées par des accesseurs sur les classes d'assoc
/*{    /* (non-Javadoc)
     * @see <%=clazzFQN%>#add<%=StringUtils.capitalize(attrName)%>(<%=attrType%>)
     *)
    @Override
    public void add<%=StringUtils.capitalize(attrName)%>(<%=attrType%> <%=attrName%>) {
        fireOnPreWrite("<%=attrName%>", null, <%=attrName%>);
        if (this.<%=attrName%> == null) {
            this.<%=attrName%> = new <%=collectionObject%><<%=attrType%>>();
        }
}*/
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
                    	String reverseAttrType = TopiaGeneratorUtil.getSimpleName(reverse.getType());
                        if (!GeneratorUtil.isNMultiplicity(reverse)) {
/*{        <%=attrName%>.set<%=StringUtils.capitalize(reverseAttrName)%>(this);
}*/
                        } else {
/*{        if (<%=attrName%>.get<%=StringUtils.capitalize(reverseAttrName)%>() == null) {
            <%=attrName%>.set<%=StringUtils.capitalize(reverseAttrName)%>(new <%=collectionObject%><<%=reverseAttrType%>>());
        }
        <%=attrName%>.get<%=StringUtils.capitalize(reverseAttrName)%>().add(this);
}*/
                        }
                    }
/*{        this.<%=attrName%>.add(<%=attrName%>);
        fireOnPostWrite("<%=attrName%>", this.<%=attrName%>.size(), null, <%=attrName%>);
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#addAll<%=StringUtils.capitalize(attrName)%>(<%=collectionInterface%><<%=attrType%>>)
     *)
    @Override
    public void addAll<%=StringUtils.capitalize(attrName)%>(<%=collectionInterface%><<%=attrType%>> values) {
        if (values == null) {
            return;
        }
        for (<%=attrType%> item : values) {
            add<%=StringUtils.capitalize(attrName)%>(item);
        }
    }
}*/
                    if (!isPrimitiveType(attr) && !isDateType(attr)) {
/*{
    /* (non-Javadoc)
     * @see <%=clazzFQN%>#get<%=StringUtils.capitalize(attrName)%>ByTopiaId(String)
     *)
    @Override
    public <%=attrType%> get<%=StringUtils.capitalize(attrName)%>ByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(<%=attrName%>, topiaId);
    }
 }*/
                    }
/*{
    /* (non-Javadoc)
     * @see <%=clazzFQN%>#set<%=StringUtils.capitalize(attrName)%>(<%=collectionInterface%><<%=attrType%>>)
     *)
    @Override
    public void set<%=StringUtils.capitalize(attrName)%>(<%=collectionInterface%><<%=attrType%>> values) {
        <%=collectionInterface%><<%=attrType%>> _oldValue = <%=attrName%>;
        fireOnPreWrite("<%=attrName%>", _oldValue, values);
        <%=attrName%> = values;
        fireOnPostWrite("<%=attrName%>", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#remove<%=StringUtils.capitalize(attrName)%>(<%=attrType%>)
     *)
    @Override
    public void remove<%=StringUtils.capitalize(attrName)%>(<%=attrType%> value) {
        fireOnPreWrite("<%=attrName%>", value, null);
        if ((this.<%=attrName%> == null) || (!this.<%=attrName%>.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
}*/
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
                        if (!GeneratorUtil.isNMultiplicity(reverse)) {
/*{        value.set<%=StringUtils.capitalize(reverseAttrName)%>(null);
}*/
                        } else {
/*{        value.get<%=StringUtils.capitalize(reverseAttrName)%>().remove(this);
}*/
                        }
                    }
/*{        fireOnPostWrite("<%=attrName%>", this.<%=attrName%>.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#clear<%=StringUtils.capitalize(attrName)%>()
     *)
    @Override
    public void clear<%=StringUtils.capitalize(attrName)%>() {
        if (this.<%=attrName%> == null) {
            return;
        }
}*/
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
/*{        for (<%=attrType%> item : this.<%=attrName%>) {
}*/
                        if (!GeneratorUtil.isNMultiplicity(reverse)) {
/*{            item.set<%=StringUtils.capitalize(reverseAttrName)%>(null);
}*/
                        } else {
/*{            item.get<%=StringUtils.capitalize(reverseAttrName)%>().remove(this);
}*/
                        }
/*{        }
}*/
                    }
/*{        <%=collectionInterface%><<%=attrType%>> _oldValue = new <%=collectionObject%><<%=attrType%>>(this.<%=attrName%>);
        fireOnPreWrite("<%=attrName%>", _oldValue, this.<%=attrName%>);
        this.<%=attrName%>.clear();
        fireOnPostWrite("<%=attrName%>", _oldValue, this.<%=attrName%>);
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
/*{    /* (non-Javadoc)
     * @see <%=clazzFQN%>#add<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%>)
     *)
    @Override
    public void add<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%> value) {
        fireOnPreWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", null, value);
        if (this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> == null) {
            this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = new <%=collectionObject%><<%=assocClassFQN%>>();
        }
}*/
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
/*{        value.set<%=StringUtils.capitalize(reverseAttrName)%>(this);
}*/
                    }
/*{        this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>.add(value);
        fireOnPostWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>.size(), null, value);
    }
}*/
                    if (!isPrimitiveType(attr) && !isDateType(attr)) {
/*{
    /* (non-Javadoc)
     * @see <%=clazzFQN%>#get<%=StringUtils.capitalize(attrName)%>ByTopiaId(String)
     *)
    @Override
    public <%=assocClassFQN%> get<%=StringUtils.capitalize(assocAttrName)%>ByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(<%=assocAttrName%>, topiaId);
    }
}*/
                    }
/*{
    /* (non-Javadoc)
     * @see <%=clazzFQN%>#addAll<%=StringUtils.capitalize(assocAttrName)%>(<%=collectionInterface%><<%=assocClassFQN%>>()
     *)
    @Override
    public void addAll<%=StringUtils.capitalize(assocAttrName)%>(<%=collectionInterface%><<%=assocClassFQN%>> values) {
        if (values == null) {
            return;
        }
        for (<%=assocClassFQN%> item : values) {
            add<%=StringUtils.capitalize(assocAttrName)%>(item);
        }
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#set<%=StringUtils.capitalize(assocAttrName)%>(<%=collectionInterface%><<%=assocClassFQN%>>()
     *)
    @Override
    public void set<%=StringUtils.capitalize(assocAttrName)%>(<%=collectionInterface%><<%=assocClassFQN%>> values) {
//        clear<%=StringUtils.capitalize(assocAttrName)%>();
//        addAll<%=StringUtils.capitalize(assocAttrName)%>(values);
// FIXME
        <%=collectionInterface%><<%=assocClassFQN%>> _oldValue = <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
        fireOnPreWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", _oldValue, values);
        <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = values;
        fireOnPostWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#remove<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%>)
     *)
    @Override
    public void remove<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%> value) {
        fireOnPreWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", value, null);
        if ((this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> == null) || (!this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
}*/
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
/*{        value.set<%=StringUtils.capitalize(reverseAttrName)%>(null);
}*/
                    }
/*{        fireOnPostWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#clear<%=StringUtils.capitalize(assocAttrName)%>()
     *)
    @Override
    public void clear<%=StringUtils.capitalize(assocAttrName)%>() {
        if (this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> == null) {
            return;
        }
}*/
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
/*{        for (<%=assocClassFQN%> item : this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>) {
            item.set<%=StringUtils.capitalize(reverseAttrName)%>(null);
        }
}*/
                    }
/*{        <%=collectionInterface%><<%=assocClassFQN%>> _oldValue = new <%=collectionObject%><<%=assocClassFQN%>>(this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>);
        fireOnPreWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", _oldValue, null);
        this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>.clear();
        fireOnPostWrite("<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>", _oldValue, null);
    }

}*/
                }
                if (!attr.hasAssociationClass()) {
/*{    /* (non-Javadoc)
     * @see <%=clazzFQN%>#get<%=StringUtils.capitalize(attrName)%>()
     *)
    @Override
    public <%=collectionInterface%><<%=attrType%>> get<%=StringUtils.capitalize(attrName)%>() {
        return <%=attrName%>;
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#size<%=StringUtils.capitalize(attrName)%>()
     *)
    @Override
    public int size<%=StringUtils.capitalize(attrName)%>() {
        if (<%=attrName%> == null) {
            return 0;
        }
        return <%=attrName%>.size();
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#is<%=StringUtils.capitalize(attrName)%>Empty()
     *)
    @Override
    public boolean is<%=StringUtils.capitalize(attrName)%>Empty() {
        int size = size<%=StringUtils.capitalize(attrName)%>();
        return size == 0;
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
/*{    /* (non-Javadoc)
     * @see <%=clazzFQN%>#get<%=StringUtils.capitalize(assocAttrName)%>()
     *)
    @Override
    public <%=collectionInterface%><<%=assocClassFQN%>> get<%=StringUtils.capitalize(assocAttrName)%>() {
        return <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#get<%=StringUtils.capitalize(assocAttrName)%>(<%=attrType%>)
     *)
    @Override
    public <%=assocClassFQN%> get<%=StringUtils.capitalize(assocAttrName)%>(<%=attrType%> value) {
        if (value == null || <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> == null) {
            return null;
        }
        for (<%=assocClassFQN%> item : <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>) {
            if (value.equals(item.get<%=StringUtils.capitalize(attrName)%>())) {
                return item;
            }
        }
        return null;
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#size<%=StringUtils.capitalize(assocAttrName)%>()
     *)
    @Override
    public int size<%=StringUtils.capitalize(assocAttrName)%>() {
        if (<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> == null) {
            return 0;
        }
        return <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>.size();
    }

    /* (non-Javadoc)
     * @see <%=clazzFQN%>#is<%=StringUtils.capitalize(assocAttrName)%>Empty()
     *)
    @Override
    public boolean is<%=StringUtils.capitalize(assocAttrName)%>Empty() {
        int size = size<%=StringUtils.capitalize(assocAttrName)%>();
        return size == 0;
    }

}*/
                }
            }
        }

        //Méthodes d'accès aux attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                    String attrName = attr.getName();
                    generateAssociationAccessors(output, attrName, attrType);
//                   //Ne sert plus à rien normalement avec la navigabilité
//                   ObjectModelAttribute reverse = attr.getReverseAttribute();
//                   if (reverse == null) {
//                       attrType = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
//                       attrName = attr.getDeclaringElement().getName();
//                       generateAssociationAccessors(output, attrName, attrType);
//                   }
                }
            }
        }
        boolean doGenerateToString = TopiaGeneratorUtil.generateToString(clazz, model);
        if (doGenerateToString) {
/*{    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     *)
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
}*/
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isEntity = (attrEntity != null && attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY));
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((isEntity && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass()) || (!isEntity)) {
            	String attrName = attr.getName();
/*{            append("<%=attrName%>", this.<%=attrName%>).
}*/
            }
        }
/*{         toString();
        return result;
    }
}*/
        }
        String i18nPrefix = TopiaGeneratorUtil.getI18nPrefix(clazz, model);
        if (i18nPrefix != null) {
            // generate i18n prefix
            generateI18n(output, i18nPrefix, clazz);
        }
/*{        
} //<%=clazzName%>Abstract
}*/
    }

    private void generateAssociationAccessors(Writer output, String name, String type) throws IOException {
/*{    /**
     * @param value La valeur de l'attribut <%=name%> à positionner.
     *)
    @Override
    public void set<%=StringUtils.capitalize(name)%>(<%=type%> value) {
        <%=type%> _oldValue = this.<%=GeneratorUtil.toLowerCaseFirstLetter(name)%>;
        fireOnPreWrite("<%=name%>", _oldValue, value);
        this.<%=GeneratorUtil.toLowerCaseFirstLetter(name)%> = value;
        fireOnPostWrite("<%=name%>", _oldValue, value);
    }

    /**
     * @return La valeur de l'attribut <%=name%>.
     *)
    @Override
    public <%=type%> get<%=StringUtils.capitalize(name)%>() {
        return <%=GeneratorUtil.toLowerCaseFirstLetter(name)%>;
    }

}*/
    }

    private void generateI18n(Writer output, String i18nPrefix, ObjectModelClass clazz) throws IOException {
/*{
    static {
}*/
        StringBuilder buffer = new StringBuilder();
        addI18n(buffer, i18nPrefix, java.beans.Introspector.decapitalize(clazz.getName()));
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            addI18n(buffer, i18nPrefix, java.beans.Introspector.decapitalize(attr.getName()));
        }
/*{<%=buffer.toString()%>}
}*/
    }

    private void addI18n(StringBuilder buffer, String i18nPrefix, String suffix) {
        buffer.append("        org.nuiton.i18n.I18n.n_(\"").append(i18nPrefix).append(suffix).append("\");\n");
    }

} //EntityAbstractGenerator
