/*
 * *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelType;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;


/*{generator option: parentheses = false}*/

/*{generator option: writeString = +}*/

/**
 * User: chemit
 * Date: 13 nov. 2009
 * Time: 09:05:17
 *
 * @since 2.3.0
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOHelperTransformer"
 */
public class DAOHelperTransformer extends ObjectModelTransformerToJava {

    private static final Log log = LogFactory.getLog(DAOHelperTransformer.class);

    @Override
    public void transformFromModel(ObjectModel model) {
        ObjectModelClass resultClass;
        String packageName = getOutputProperties().getProperty(Template.PROP_DEFAULT_PACKAGE);
        String modelName = model.getName();
        String daoHelperClazzName = modelName + "DAOHelper";
        String modelVersion = model.getVersion();

        resultClass = createClass(daoHelperClazzName, packageName);

        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        boolean generateOperator = TopiaGeneratorUtil.shouldgenerateOperatorForDAOHelper(null, model);

        addImport(resultClass, TopiaContextImplementor.class);
        addImport(resultClass, TopiaDAO.class);
        addImport(resultClass, TopiaEntity.class);
        addImport(resultClass, TopiaContext.class);
        addImport(resultClass, Array.class);
        addImport(resultClass, Arrays.class);

        if (generateOperator) {
            addImport(resultClass,EntityOperator.class);
            addImport(resultClass, EntityOperatorStore.class);
        }

        String entityEnumName = modelName+"EntityEnum";

        // add non public constructor
        ObjectModelOperation constructor = addConstructor(resultClass, ObjectModelModifier.PROTECTED);
        setOperationBody(constructor," ");

        ObjectModelOperation op;
        ObjectModelAttributeImpl attr;


        // getModelVersion method
        op = addOperation(resultClass, "getModelVersion", "String", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    /*{
        return "<%=modelVersion%>";
    }*/
            );

        // getModelName method
        op = addOperation(resultClass, "getModelName", "String", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    /*{
        return "<%=modelName%>";
    }*/
            );


        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            String daoClazzName = clazzName + "DAO";

            // specialized getXXXDao method
            op = addOperation(resultClass, "get" + daoClazzName, clazz.getPackageName() + '.' + daoClazzName, ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
            addParameter(op, TopiaContext.class, "context");
            addImport(resultClass, clazz);
            addException(op, TopiaException.class);
            setOperationBody(op, ""
    /*{
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        <%=daoClazzName%> result = (<%=daoClazzName%>) ci.getDAO(<%=clazzName%>.class);
        return result;
    }*/
            );

        }

        // generic getDao method
        op = addOperation(resultClass, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, TopiaContext.class, "context");
        addParameter(op, "Class<T>", "klass");
        addException(op, TopiaException.class);
        setOperationBody(op, ""
    /*{
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }*/
            );

        op = addOperation(resultClass, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, TopiaContext.class, "context");
        addParameter(op, "T", "entity");
        addException(op, TopiaException.class);
        setOperationBody(op, ""
    /*{
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }*/
            );

        // getContractClass method
        op = addOperation(resultClass, "getContractClass", "<T extends TopiaEntity> Class<T>", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
    /*{
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        return (Class<T>) constant.getContract();
    }*/
            );

        // getImplementationClass method
        op = addOperation(resultClass, "getImplementationClass", "<T extends TopiaEntity> Class<T>", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
    /*{
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }*/
            );

        // getContractClasses method
        op = addOperation(resultClass, "getContractClasses", "Class<? extends TopiaEntity>[]", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    /*{
        <%=entityEnumName%>[] values = <%=entityEnumName%>.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }*/
            );

        // getImplementationClasses method
        op = addOperation(resultClass, "getImplementationClasses", "Class<? extends TopiaEntity>[]", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    /*{
        <%=entityEnumName%>[] values = <%=entityEnumName%>.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }*/
            );

        // getImplementationClassesAsString method
        op = addOperation(resultClass, "getImplementationClassesAsString", "String", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    /*{
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }*/
            );

        // getContracts method
        op = addOperation(resultClass, "getContracts", entityEnumName+"[]", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
    /*{
        return <%=entityEnumName%>.values();
    }*/
            );

        if (generateOperator) {
            // getOperator method
            op = addOperation(resultClass, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
            addParameter(op,"Class<T>","klass");
            setOperationBody(op, ""
    /*{
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);
    }*/
            );
        }

        // add enum

        ObjectModelEnumerationImpl entityEnum = (ObjectModelEnumerationImpl) addInnerClassifier(resultClass, ObjectModelType.OBJECT_MODEL_ENUMERATION, entityEnumName);
        addImport(resultClass,TopiaEntityEnum.class);
        addInterface(entityEnum, TopiaEntityEnum.class);

        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            addLiteral(entityEnum, clazzName + '(' + clazzName + ".class)");
        }
        attr = (ObjectModelAttributeImpl) addAttribute(entityEnum, "contract", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the contract of the entity");

        attr = (ObjectModelAttributeImpl) addAttribute(entityEnum, "implementationFQN", "String");
        attr.setDocumentation("the fully qualified name of the implementation of the entity");

        attr = (ObjectModelAttributeImpl) addAttribute(entityEnum, "implementation", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the implementation class of the entity (will be lazy computed at runtime)");

        // constructor
        op = addConstructor(entityEnum, ObjectModelModifier.PACKAGE);
        addParameter(op,"Class<? extends TopiaEntity >","contract");
        setOperationBody(op, ""
    /*{
        this.contract = contract;
        this.implementationFQN = contract.getName()+"Impl";
    }*/
        );

        // getContract method
        op = addOperation(entityEnum, "getContract","Class<? extends TopiaEntity>",ObjectModelModifier.PUBLIC);
        setOperationBody(op, ""
    /*{
        return contract;
    }*/
        );

        // getImplementationFQN method
        op = addOperation(entityEnum, "getImplementationFQN","String",ObjectModelModifier.PUBLIC);
        setOperationBody(op, ""
    /*{
        return implementationFQN;
    }*/
        );

        // setImplementationFQN method
        op = addOperation(entityEnum, "setImplementationFQN","void",ObjectModelModifier.PUBLIC);
        addParameter(op,"String","implementationFQN");
        if (generateOperator) {
               setOperationBody(op, ""
    /*{
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        // on reinitialise le magasin d'operators
       EntityOperatorStore.clear();
    }*/
            );
        } else {
            setOperationBody(op, ""
    /*{
        this.implementationFQN = implementationFQN;
        this.implementation = null;
    }*/
            );
        }

        // accept method
        op = addOperation(entityEnum, "accept","boolean",ObjectModelModifier.PUBLIC);
        addParameter(op,"Class<? extends TopiaEntity>","klass");
        setOperationBody(op, ""
     /*{
         return <%=daoHelperClazzName%>.getContractClass(klass) == contract;
     }*/
        );

        // getImplementation method
        op = addOperation(entityEnum, "getImplementation","Class<? extends TopiaEntity>",ObjectModelModifier.PUBLIC);
        setOperationBody(op, ""
     /*{
         if (implementation == null) {
            try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
         }
         return implementation;
     }*/
        );

        // valueOf method
        op = addOperation(entityEnum, "valueOf", entityEnumName, ObjectModelModifier.PUBLIC,ObjectModelModifier.STATIC);
        addParameter(op,"TopiaEntity","entity");
        setOperationBody(op, ""
     /*{
         return valueOf(entity.getClass());
     }*/
        );

        // valueOf method
        op = addOperation(entityEnum, "valueOf", entityEnumName, ObjectModelModifier.PUBLIC,ObjectModelModifier.STATIC);
        addParameter(op,"Class<?>","klass");
        setOperationBody(op, ""
     /*{
         if (klass.isInterface()) {
            return <%=entityEnumName%>.valueOf(klass.getSimpleName());
         }
         for (<%=entityEnumName%> entityEnum : <%=entityEnumName%>.values()) {
             if (entityEnum.getContract().isAssignableFrom(klass)) {
                 //todo check it works for inheritance
                 return entityEnum;
             }
         }
         throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(<%=entityEnumName%>.values()));
     }*/
        );
    }
}
