/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/*{generator option: parentheses = true}*/
/*{generator option: writeString = output.write}*/

/* *
* EntityGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1732 $
*
* Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim. 20 déc. 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.util.StringUtil;

/**
 * Genere des DAOs abstrait par defaut, l'utilisateur peut ensuite en herite
 * pour implanter d'autre methode find, ou bien laisser l'implantation par
 * defaut de l'autre generateur qui genere une classe DAO qui herite de celle-ci
 * mais completement vide.

 * @author poussin
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link DAOAbstractTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOAbstractGenerator"
 */
@Deprecated
public class DAOAbstractGenerator extends ObjectModelGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DAOAbstract.java";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
/*{package <%=clazz.getPackageName()%>;

import java.util.List;

}*/
        Collection<ObjectModelOperation> DAOoperations = getDAOOperations(clazz);
        if (isCollectionNeeded(DAOoperations)) {
/*{
import java.util.Collection;
}*/
        }
        if (isSetNeeded(DAOoperations)) {
/*{
import java.util.Set;
}*/            
        }
/*{
import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
}*/
        boolean enableSecurity = (
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_CREATE) ||
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_LOAD) ||
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_UPDATE) ||
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_DELETE)
        		);
        
        if (enableSecurity) {
/*{
import java.util.ArrayList;
import java.security.Permission;
import org.nuiton.topia.taas.entities.TaasAuthorizationImpl;
import org.nuiton.topia.taas.jaas.TaasPermission;
import org.nuiton.topia.persistence.TopiaDAO;
import static org.nuiton.topia.taas.TaasUtil.CREATE;
import static org.nuiton.topia.taas.TaasUtil.DELETE;
import static org.nuiton.topia.taas.TaasUtil.LOAD;
import static org.nuiton.topia.taas.TaasUtil.UPDATE;
}*/
        }
        String clazzName = clazz.getName();
/*{
/**
 * Implantation DAO pour l'entité <%=GeneratorUtil.toUpperCaseFirstLetter(clazz.getName())%>.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 *)
public abstract class <%=clazzName%>DAOAbstract<E extends <%=clazzName%>> extends }*/
        String extendClass = "";
        for (Iterator<ObjectModelClass> i=clazz.getSuperclasses().iterator(); i.hasNext();) {
            ObjectModelClassifier parent = i.next();
            extendClass += parent.getQualifiedName();
            if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                extendClass += "DAOImpl<E>";
            }
            if (i.hasNext()) {
                extendClass += ", ";
            }
        }
        if (extendClass.length() == 0) {
            extendClass += "org.nuiton.topia.persistence.TopiaDAOImpl<E>";
        }
        
        /*{<%=extendClass%> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)<%=clazzName%>.class;
    }
}*/

        generateDAOOperations(output, DAOoperations);
/*{
    public void delete(E entity) throws TopiaException {
}*/
        String modelName = StringUtils.capitalize(model.getName());
        String providerFQN = getProperty("defaultPackage") + "." + modelName + "DAOHelper.getImplementationClass";
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
        	String attrType = attr.getType();
        	String reverseAttrName = attr.getReverseAttributeName();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.hasAssociationClass() && reverse != null && reverse.isNavigable() 
                    && GeneratorUtil.isNMultiplicity(attr) && GeneratorUtil.isNMultiplicity(reverse)) {
                // On doit absolument supprimer pour les relations many-to-many
                // le this de la collection de l'autre cote
                
            	String attrDBName = TopiaGeneratorUtil.getDBName(attr);
            	String attrClassifierDBName = TopiaGeneratorUtil.getDBName(attr.getClassifier());
            	String attrJoinTableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
            	String attrReverseDBName = TopiaGeneratorUtil.getReverseDBName(attr);
/*{
        {
            List<<%=attrType%>> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from <%=attrClassifierDBName%> main, <%=attrJoinTableName%> secondary " +
                    "where main.topiaid=secondary.<%=attrDBName%>" +
                    " and secondary.<%=attrReverseDBName%>='" + entity.getTopiaId() + "'")
                    .addEntity("main", <%=providerFQN%>(<%=attrType%>.class)).list();
            for (<%=attrType%> item : list) {
                item.remove<%=TopiaGeneratorUtil.capitalize(reverseAttrName)%>(entity);
            }
        }
}*/
            } else  if (!attr.hasAssociationClass() && reverse != null
                    && reverse.isNavigable() && !GeneratorUtil.isNMultiplicity(reverse)) {
                // On doit mettre a null les attributs qui ont cet objet sur les 
                // autres entites en one-to-*
                // TODO peut-etre qu'hibernate est capable de faire ca tout seul ?
            	// THIMEL: J'ai remplacé reverse.getName() par reverseAttrName sans certitude
                /*{
                {
                List<<%=attrType%>> list = getContext()
                            .getDAO(<%=attrType%>.class)
                            .findAllByProperties("<%=reverseAttrName%>", entity);
                    for (<%=attrType%> item : list) {
                        item.set<%=GeneratorUtil.capitalize(reverseAttrName)%>(null);
}*/
            	if(attr.isAggregate()){
/*{
            			item.delete();
}*/
            	}
/*{
                    }
                }
        }*/

            }
        }
/*{        
        super.delete(entity);
    }    
     
}*/
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) {
                continue;
            }
            String attrName = attr.getName();

/*{    /**
     * Recherche sur l'attribut <%=attrName%>
     *)
}*/
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                generateNoNMultiplicity(output, attr, false);
            } else {
                generateNMultiplicity(output, attr);
            }
        }

        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr != null) {
                    if (!GeneratorUtil.isNMultiplicity(attr)) {
                        generateNoNMultiplicity(output, attr, true);
                    } else {
                        generateNMultiplicity(output, attr);
                    }
                }
            }
        }
        
        if(enableSecurity) {
/*{
    /**
     * Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas
     * @param topiaId topiaId d'une entite
     * @param actions actions souhaitées
     * @return la liste des permissions
     *)
    public List<Permission> getRequestPermission(String topiaId, int actions) throws TopiaException {
        List<Permission> resultPermissions = new ArrayList<Permission>();
        if ((actions & CREATE) == CREATE) {
}*/
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_CREATE);
/*{
        }
        if ((actions & LOAD) == LOAD) {
}*/
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_LOAD);
/*{
        }
        if ((actions & UPDATE) == UPDATE) {
}*/
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_UPDATE);
/*{
        }
        if ((actions & DELETE) == DELETE) {
}*/
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_DELETE);
/*{
        }
        return resultPermissions;
    }

}*/
            // THIMEL : Le code suivant doit pouvoir être déplacé dans DAODelegator ?
/*{
    /**
     * Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas
     * @param topiaId topiaId d'une entite
     * @param actions actions souhaitées
     * @param query requete pour avoir le prochain topiaId
     * @param daoClass delegation du getRequestPermission
     * @return la liste des permissions
     *)
    protected List<Permission> getRequestPermission(String topiaId, int actions, String query, Class daoClass) throws TopiaException {
        TopiaContextImplementor context = getContext();
        List<String> result = context.find(query, "id", topiaId);

        List<Permission> resultPermissions = new ArrayList<Permission>();
        for (String topiaIdPermission : result) {
            TopiaDAO dao = context.getDAO(daoClass);
            List<Permission> permissions = dao.getRequestPermission(topiaIdPermission, actions);
            if(permissions != null) {
                resultPermissions.addAll(permissions);
            } else {
                TaasPermission permission = new TaasPermission(topiaIdPermission, actions);
                resultPermissions.add(permission);
            }
        }
        return resultPermissions;
    }
}*/
        }
/*{
} // <%=clazz.getName()%>DAOAbstract
}*/
    }

    /**
     * Generation of DAO operations signatures from class.
     * These operations are abstract and identified by <<dao>> stereotype in the model.
     * The developper must defined these methods in the DAOImpl associated to this DAOAbstract.
     * @param output
     * @param operations operations to generate
     */
    private void generateDAOOperations(Writer output, Collection<ObjectModelOperation> operations) throws IOException {
        for (ObjectModelOperation op : operations) {
                String opName = op.getName();
                
/*{    /**
}*/
                if (TopiaGeneratorUtil.hasDocumentation(op)) {
                    String opDocumentation = op.getDocumentation();
/*{     * <%=opName%> : <%=opDocumentation%>
}*/
                }
                Collection<ObjectModelParameter> params = op.getParameters();
                for (ObjectModelParameter param : params) {
                    String paramName = param.getName();
                    String paramDocumentation = param.getDocumentation();
/*{     * @param <%=paramName%> <%=paramDocumentation%>
 }*/
                }
                String opVisibility = op.getVisibility();
                String opType = op.getReturnType();
                //ObjectModelClass clazz = (ObjectModelClass)op.getDeclaringElement();
                //opType = opType.replace(clazz.getQualifiedName(),clazz.getName());
                //opType = opType.replace(clazz.getName(), "E"); // Generic usage for inheritance
/*{     *)
    <%=opVisibility%> abstract <%=opType%> <%=opName%>(}*/
                String comma = "";
                for (ObjectModelParameter param : params) {
                    String paramName = param.getName();
                    String paramType = param.getType();                    
/*{<%=comma%><%=paramType%> <%=paramName%>}*/
                    comma = ", ";
                }
/*{)}*/
                Set<String> exceptions = op.getExceptions();
                exceptions.add("TopiaException");
                comma = " throws ";
                for (String exception : exceptions) {
/*{<%=comma%><%=exception%>}*/
                    comma = ", ";
                }
/*{;

}*/
        }
    }

    private boolean isCollectionNeeded(Collection<ObjectModelOperation> operations) {
        return isImportNeeded(operations, "Collection");
    }

    private boolean isSetNeeded(Collection<ObjectModelOperation> operations) {
        return isImportNeeded(operations, "Set");
    }

    private boolean isImportNeeded(Collection<ObjectModelOperation> operations, String importName) {
        for (ObjectModelOperation op : operations) {
            if (op.getReturnType().contains(importName)){
                return true;
            }
            for (ObjectModelParameter param : op.getParameters()) {
                if (param.getType().contains(importName)){
                    return true;
                }
            }
        }
        return false;
    }

    public static Collection<ObjectModelOperation> getDAOOperations(ObjectModelClass clazz) {
        Collection<ObjectModelOperation> results = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (op.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)) {
                results.add(op);
            }
        }
        return results;
    }

    private void generateSecurity(Writer output, ObjectModelClass clazz, String securityTagName) throws IOException {
    	if (clazz.hasTagValue(securityTagName)) {
    		String security = clazz.getTagValue(securityTagName);
            Pattern propertiesPattern = Pattern
                .compile("((?:[_a-zA-Z0-9]+\\.)+(?:_?[A-Z][_a-zA-Z0-9]*\\.)+)attribute\\.(?:([_a-z0-9][_a-zA-Z0-9]*))#(?:(create|load|update|delete))");
            String[] valuesSecurity = security.split(":");
            
            for (String valueSecurity : valuesSecurity) {
                Matcher matcher = propertiesPattern.matcher(valueSecurity);
                matcher.find();
                // className is fully qualified name of class
                String className = matcher.group(1);
                className = StringUtil.substring(className, 0, -1); // remove ended
                // .
                // target is class, attribute or operation
                String attributeName = matcher.group(2);
                String actions = matcher.group(3).toUpperCase();
                
                String query = "";
                String daoClass = "";
                if(className.equals(clazz.getQualifiedName())) {
                    query = "select " + attributeName + ".topiaId from " + clazz.getQualifiedName() + " where topiaId = :id";
                    daoClass = clazz.getAttribute(attributeName).getClassifier().getQualifiedName();
                } else {
                    query = "select at.topiaId from " + className + " at inner join at." + attributeName + " cl where cl.topiaId = :id";
                    daoClass = className;
                }
/*{            resultPermissions.addAll(getRequestPermission(topiaId,
                                                            <%=actions%>,
                                                            "<%=query%>",
                                                            <%=daoClass%>.class));
}*/
            }
        } else {
/*{            return null;
}*/
        }
    }

    protected void generateNoNMultiplicity(Writer output, ObjectModelAttribute attr, boolean isAssoc) throws IOException {
    	String attrName = attr.getName();
    	String attrType = attr.getType();
        String propertyName = attrName;
        if (!isAssoc && attr.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName()) + "." + propertyName;
        }
/*{
    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * <%=attrName%> le paramètre
     * @param v la valeur que doit avoir <%=attrName%>
     * @return un element ou null
     *)
    public E findBy<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> v) throws TopiaException {
        E result = findByProperty("<%=propertyName%>", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * <%=attrName%> le paramètre
     * @param v la valeur que doit avoir <%=attrName%>
     * @return une liste
     *)
    public List<E> findAllBy<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> v) throws TopiaException {
        List<E> result = findAllByProperty("<%=propertyName%>", v);
        return result;
    }
}*/
        if (attr.hasAssociationClass()) {
        	String assocClassName = attr.getAssociationClass().getName();
        	String assocClassFQN = attr.getAssociationClass().getQualifiedName();
/*{
    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> le paramètre
     * @param value la valeur que doit avoir <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>
     * @return un element ou null
     *)
    public E findBy<%=TopiaGeneratorUtil.capitalize(assocClassName)%>(<%=assocClassFQN%> value) throws TopiaException {
        E result = findByProperty("<%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>", value);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> le paramètre
     * @param value la valeur que doit avoir <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>
     * @return une liste
     *)
    public List<E> findAllBy<%=TopiaGeneratorUtil.capitalize(assocClassName)%>(<%=assocClassFQN%> value) throws TopiaException {
        List<E> result = findAllByProperty("<%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>", value);
        return result;
    }
}*/
        }
    }        

    protected void generateNMultiplicity(Writer output, ObjectModelAttribute attr) throws IOException {
    	String attrName = attr.getName();
    	String attrType = attr.getType();
/*{    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * <%=attrName%> contient le paramètre
     * @param v la valeur que doit contenir <%=attrName%>
     * @return un element ou null
     *)
    public E findContains<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> ... v) throws TopiaException {
        E result = findContainsProperties("<%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attrName)%>", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * <%=attrName%> contient le paramètre
     * @param v la valeur que doit contenir <%=attrName%>
     * @return une liste
     *)
    public List<E> findAllContains<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("<%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attrName)%>", Arrays.asList(v));
        return results;
    }
}*/        
    }
 
} //DAOAbstractGenerator
