/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/* *
 * EntityState.java
 *
 * Created: 22 nov. 06 12:10:57
 *
 * @author poussin
 * @version $Revision: 1715 $
 *
 * Last update: $Date: 2009-12-15 01:26:16 +0100 (mar. 15 déc. 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.framework;

/**
 * Used to know the state of entity during transaction
 * 
 * @author poussin
 */
public class EntityState {

    final static int NULL = 0;
    final static int LOAD = 1;
    final static int READ = 2;
    final static int CREATE = 4;
    final static int UPDATE = 8;
    final static int DELETE = 16;

    protected int state = NULL;

    public void addLoad() {
        state |= LOAD;
    }

    public void addRead() {
        state |= READ;
    }

    public void addCreate() {
        state |= CREATE;
    }

    public void addUpdate() {
        state |= UPDATE;
    }

    public void addDelete() {
        state |= DELETE;
    }

    public boolean isLoad() {
        return (state & LOAD) == LOAD;
    }

    public boolean isRead() {
        return (state & READ) == READ;
    }

    public boolean isCreate() {
        return (state & CREATE) == CREATE;
    }

    public boolean isUpdate() {
        return (state & UPDATE) == UPDATE;
    }

    public boolean isDelete() {
        return (state & DELETE) == DELETE;
    }
}
