
package org.nuiton.topia.generator;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

/**
 * InterfaceTransformer
 *
 * Created: 7 nov. 2009
 *
 * @author fdesbois
 * @version $Revision$
 *
 * Mise a jour: $Date$
 * par : $Author$
 */
public class ObjectModelTransformerToJavaInterface extends ObjectModelTransformerToJava {

    private static final Log log = LogFactory.getLog(ObjectModelTransformerToJavaInterface.class);

    @Override
    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!interfacez.getStereotypes().isEmpty()) {
            // can only generate an interface with there is no other stereotypes
            return;
        }

        ObjectModelInterface resultInterface = createInterface(interfacez.getName(), interfacez.getPackageName());

        // extend interface
        Iterator<ObjectModelInterface> it = interfacez.getInterfaces().iterator();
        if (it.hasNext()) {
            ObjectModelInterface extend = it.next();
            addInterface(resultInterface, extend.getQualifiedName());
        }

        // constant attributes
        for (ObjectModelAttribute attr : interfacez.getAttributes()) {
            if (!attr.isStatic() && StringUtils.isNotEmpty(attr.getDefaultValue())) { // only static attribut with value
                addConstant(resultInterface, attr.getName(), attr.getType(), attr.getDefaultValue(), ObjectModelModifier.PUBLIC);
            }
        }

        // interface operations
        for (ObjectModelOperation op : interfacez.getOperations()) {
            ObjectModelOperation resultOp = addOperation(resultInterface, op.getName(), op.getReturnType());
            for (ObjectModelParameter param : op.getParameters()) {
                addParameter(resultOp, param.getType(), param.getName());
            }
            for (String exception : op.getExceptions()) {
                addException(resultOp, exception);
            }
        }
    }
}
