/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
* EntityGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1558 $
*
* Mise a jour: $Date: 2009-06-11 06:53:44 +0200 (jeu., 11 juin 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.Generator;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;

public class InterfaceGenerator extends ObjectModelGenerator { //InterfaceGenerator

    /** Logger for this class */
    private static final Log log = LogFactory.getLog(InterfaceGenerator.class);

    public InterfaceGenerator() {
        super();
    }

    public InterfaceGenerator(Generator parent) {
        super(parent);
    }

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        if (!interfacez.getStereotypes().isEmpty()) {
            // can only generate an interface with there is no other stereotypes
            return;
        }

        // log
        if (log.isDebugEnabled()) {
            log.debug("Generating interface for : " + interfacez.getName());
        }

        String interfacezName = interfacez.getName();

        generateInterfaceHeader(output, interfacez);

        generateInterfaceOperations(output, interfacez);

output.write("} //"+interfacezName+"\n");
output.write("");
    }

    private void generateInterfaceHeader(Writer output, ObjectModelInterface interfacez) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
output.write("package "+interfacez.getPackageName()+";\n");
output.write("\n");
output.write("");
        if (TopiaGeneratorUtil.hasDocumentation(interfacez)) {
        	String documentation = interfacez.getDocumentation();
output.write("\n");
output.write("/**\n");
output.write(" * "+documentation+"\n");
output.write(" */\n");
output.write("");
        }
        String interfacezName = interfacez.getName();
output.write("public interface "+interfacezName+" ");
        String extendClass = "";
        if (!interfacez.getInterfaces().isEmpty()) {
            for (ObjectModelClassifier parent : interfacez.getInterfaces()) {
                extendClass += parent.getQualifiedName();
                extendClass += ", ";
            }
            if (log.isTraceEnabled()) {
                log.trace("Interface : " + extendClass);
            }

output.write(" extends "+extendClass+" {\n");
output.write("\n");
output.write("");
        }
output.write(" {\n");
output.write("");
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
output.write("    /**\n");
output.write("");
            if (TopiaGeneratorUtil.hasDocumentation(op)) {
            	String documentation = op.getDocumentation();
output.write("     * "+documentation+"\n");
output.write("");
            }
            Collection<ObjectModelParameter> params = op.getParameters();
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace("Param" + param);
                }
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
output.write("     * @param "+paramName+" "+paramDocumentation+"\n");
output.write(" ");
            }
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            String opName = op.getName();
output.write("     */\n");
output.write("    "+opVisibility+" "+opType+" "+opName+"(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace("Param" + param + " comma" + comma);
                }
                String paramName = param.getName();
                String paramType = param.getType();
output.write(""+comma+""+paramType+" "+paramName+"");
                comma = ", ";
            }
output.write(")");
            Set<String> exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                if (log.isTraceEnabled()) {
                    log.trace("exception" + exception + " vir" + comma);
                }
output.write(""+comma+""+exception+"");
                comma = ", ";
            }
output.write(";\n");
output.write("\n");
output.write("");
        }
    }

} //InterfaceGenerator
