/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.topia.event;

import java.util.EventListener;

/**
 * Listener for TopiaContext actions.
 * 
 * Listener are notified for action such as :
 *  - createSchema
 *  - updateSchema
 *  - ...
 *
 * @author chatellier
 * @version $Revision: 1558 $
 *
 * Last update : $Date: 2009-06-11 06:53:44 +0200 (jeu., 11 juin 2009) $
 * By : $Author: tchemit $
 */
public interface TopiaContextListener extends EventListener {

    /**
     * Called before createSchema call
     * @param event evet
     */
    public void preCreateSchema(TopiaContextEvent event);

    /**
     * Called after createSchema call
     * @param event event
     */
    public void postCreateSchema(TopiaContextEvent event);

    /**
     * Called before updateSchema call
     * @param event event
     */
    public void preUpdateSchema(TopiaContextEvent event);

    /**
     * Called after updateSchema call
     * @param event event
     */
    public void postUpdateSchema(TopiaContextEvent event);

    /**
     * Called after updateSchema call
     * @param event event
     */
    public void preRestoreSchema(TopiaContextEvent event);

    /**
     * Called after updateSchema call
     * @param event event
     */
    public void postRestoreSchema(TopiaContextEvent event);
}
