/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.Resource;

public abstract class ContextUtil {
    private boolean init;
    private static Log log = LogFactory.getLog(ContextUtil.class);
    private TopiaContext globalContext;
    private TopiaContext currTransaction;

    protected ContextUtil(Class current) {
        log = LogFactory.getLog((Class)current);
        this.init();
    }

    protected ContextUtil() {
        this.init();
    }

    public void init() {
        if (!this.init) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Initialize of TopiaContext...");
            }
            try {
                Properties conf = this.loadProperties();
                this.globalContext = TopiaContextFactory.getContext(conf);
                this.init = true;
                if (log.isInfoEnabled()) {
                    log.info((Object)"Context Ready !");
                }
                this.initDB();
            }
            catch (Exception ex) {
                log.error((Object)"Initialize error !!", (Throwable)ex);
            }
        }
    }

    protected void initDB() throws TopiaException {
    }

    protected abstract Properties loadProperties() throws IOException, URISyntaxException;

    protected Properties loadFileProperties(String filename) throws URISyntaxException, IOException {
        Properties props = new Properties();
        URL url = Resource.getURL((String)filename);
        if (log.isDebugEnabled()) {
            log.debug((Object)url);
        }
        props.load(url.openStream());
        return props;
    }

    public boolean isInit() {
        return this.init;
    }

    public TopiaContext getContext() {
        if (!this.init) {
            this.init();
        }
        return this.globalContext;
    }

    public void disconnect() {
        try {
            if (this.init) {
                this.globalContext.closeContext();
                if (log.isInfoEnabled()) {
                    log.info((Object)"Context closed");
                }
                this.init = false;
            }
        }
        catch (TopiaException ex) {
            log.error((Object)"Disconnect error !!", (Throwable)ex);
        }
    }

    public TopiaContext transaction() throws TopiaException {
        if (!this.init) {
            this.init();
        }
        if (this.currTransaction == null || this.currTransaction.isClosed()) {
            this.currTransaction = this.globalContext.beginTransaction();
        }
        return this.currTransaction;
    }

    public void commit() throws TopiaException {
        this.transaction().commitTransaction();
    }

    public void rollback() throws TopiaException {
        this.transaction().rollbackTransaction();
    }

    public void close() throws TopiaException {
        if (this.init && this.currTransaction != null) {
            this.currTransaction.closeContext();
        }
    }
}

