/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest.beangen;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import org.nuiton.topiatest.beangen.GeneratedSiege;
import org.nuiton.topiatest.beangen.Siege;
import org.nuiton.topiatest.beangen.Voiture;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public abstract class GeneratedSiegeHelper {
    protected static final Function<Siege, Integer> NO_SERIE_FUNCTION = GeneratedSiegeHelper.newNoSerieFunction();
    protected static final Function<Siege, Voiture> VOITURE_FUNCTION = GeneratedSiegeHelper.newVoitureFunction();

    public static <BeanType extends Siege> Class<BeanType> typeOfSiege() {
        return Siege.class;
    }

    public static Siege newSiege() {
        return new Siege();
    }

    public static <BeanType extends Siege> BeanType newSiege(BeanType source) {
        Class<BeanType> sourceType = GeneratedSiegeHelper.typeOfSiege();
        Binder binder = BinderFactory.newBinder(sourceType);
        BeanType result = GeneratedSiegeHelper.newSiege(source, binder);
        return result;
    }

    public static <BeanType extends Siege> BeanType newSiege(BeanType source, Binder<BeanType, BeanType> binder) {
        Siege result = GeneratedSiegeHelper.newSiege();
        binder.copy(source, (Object)result, new String[0]);
        return (BeanType)result;
    }

    public static <BeanType extends Siege> void copySiege(BeanType source, BeanType target) {
        Class<BeanType> sourceType = GeneratedSiegeHelper.typeOfSiege();
        Binder binder = BinderFactory.newBinder(sourceType);
        binder.copy(source, target, new String[0]);
    }

    public static <BeanType extends Siege> void copySiege(BeanType source, BeanType target, Binder<BeanType, BeanType> binder) {
        binder.copy(source, target, new String[0]);
    }

    public static <BeanType extends Siege> Predicate<BeanType> newNoSeriePredicate(int noSerie) {
        final int $tmp = noSerie;
        return new Predicate<BeanType>(){

            public boolean apply(BeanType input) {
                return Objects.equal((Object)$tmp, (Object)((GeneratedSiege)input).getNoSerie());
            }
        };
    }

    public static <BeanType extends Siege> List<BeanType> filterByNoSerie(Collection<BeanType> $source, int noSerie) {
        return Lists.newArrayList((Iterable)Iterables.filter($source, GeneratedSiegeHelper.newNoSeriePredicate(noSerie)));
    }

    public static <BeanType extends Siege> Predicate<BeanType> newVoiturePredicate(Voiture voiture) {
        final Voiture $tmp = voiture;
        return new Predicate<BeanType>(){

            public boolean apply(BeanType input) {
                return Objects.equal((Object)$tmp, (Object)((GeneratedSiege)input).getVoiture());
            }
        };
    }

    public static <BeanType extends Siege> List<BeanType> filterByVoiture(Collection<BeanType> $source, Voiture voiture) {
        return Lists.newArrayList((Iterable)Iterables.filter($source, GeneratedSiegeHelper.newVoiturePredicate(voiture)));
    }

    public static <BeanType extends Siege> Function<BeanType, Integer> getNoSerieFunction() {
        return NO_SERIE_FUNCTION;
    }

    public static <BeanType extends Siege> Function<BeanType, Integer> newNoSerieFunction() {
        return new Function<BeanType, Integer>(){

            public Integer apply(BeanType input) {
                return ((GeneratedSiege)input).getNoSerie();
            }
        };
    }

    public static <BeanType extends Siege> ImmutableMap<Integer, BeanType> uniqueIndexByNoSerie(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, NO_SERIE_FUNCTION);
    }

    public static <BeanType extends Siege> Function<BeanType, Voiture> getVoitureFunction() {
        return VOITURE_FUNCTION;
    }

    public static <BeanType extends Siege> Function<BeanType, Voiture> newVoitureFunction() {
        return new Function<BeanType, Voiture>(){

            public Voiture apply(BeanType input) {
                return ((GeneratedSiege)input).getVoiture();
            }
        };
    }

    public static <BeanType extends Siege> ImmutableMap<Voiture, BeanType> uniqueIndexByVoiture(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, VOITURE_FUNCTION);
    }
}

