package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class CompanyAbstract extends TopiaEntityAbstract implements Company {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : siret
     */
    protected int siret;

    /**
     * Nom de l'attribut en BD : employe
     */
    protected Collection<Employe> employe;

    /**
     * Nom de l'attribut en BD : store
     */
    protected Collection<Bill> storeBill;

    /**
     * Nom de l'attribut en BD : department
     */
    protected Collection<Department> department;

    private static final long serialVersionUID = 4121691295267055154L;

    static {
    
        I18n.n("topia.test.common.company");
        I18n.n("topia.test.common.name");
        I18n.n("topia.test.common.siret");
        I18n.n("topia.test.common.employe");
        I18n.n("topia.test.common.store");
        I18n.n("topia.test.common.department");
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_SIRET, int.class, siret);
        visitor.visit(this, PROPERTY_EMPLOYE, Collection.class, Employe.class, employe);
        visitor.visit(this, PROPERTY_STORE_BILL, Collection.class, Bill.class, storeBill);
        visitor.visit(this, PROPERTY_DEPARTMENT, Collection.class, Department.class, department);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);

        String result = this.name;

        fireOnPostRead(PROPERTY_NAME, name);

        return result;
    }

    @Override
    public void setSiret(int siret) {
        int oldValue = this.siret;
        fireOnPreWrite(PROPERTY_SIRET, oldValue, siret);
        this.siret = siret;
        fireOnPostWrite(PROPERTY_SIRET, oldValue, siret);
    }

    @Override
    public int getSiret() {
        fireOnPreRead(PROPERTY_SIRET, siret);

        int result = this.siret;

        fireOnPostRead(PROPERTY_SIRET, siret);

        return result;
    }

    @Override
    public void addEmploye(Employe employe) {
        fireOnPreWrite(PROPERTY_EMPLOYE, null, employe);
        if (this.employe == null) {
            this.employe = new ArrayList<Employe>();
        }

        this.employe.add(employe);
        fireOnPostWrite(PROPERTY_EMPLOYE, this.employe.size(), null, employe);
    }

    @Override
    public void addAllEmploye(Collection<Employe> employe) {
        if (employe == null) {
            return;
        }
        for (Employe item : employe) {
            addEmploye(item);
        }
    }

    @Override
    public void setEmploye(Collection<Employe> employe) {
        // Copy elements to keep data for fire with new reference
        Collection<Employe> oldValue = this.employe != null ? new ArrayList<Employe>(this.employe) : null;
        fireOnPreWrite(PROPERTY_EMPLOYE, oldValue, employe);
        this.employe = employe;
        fireOnPostWrite(PROPERTY_EMPLOYE, oldValue, employe);
    }

    @Override
    public void removeEmploye(Employe employe) {
        fireOnPreWrite(PROPERTY_EMPLOYE, employe, null);
        if (this.employe == null || !this.employe.remove(employe)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_EMPLOYE, this.employe.size() + 1, employe, null);
    }

    @Override
    public void clearEmploye() {
        if (this.employe == null) {
            return;
        }
        Collection<Employe> oldValue = new ArrayList<Employe>(this.employe);
        fireOnPreWrite(PROPERTY_EMPLOYE, oldValue, this.employe);
        this.employe.clear();
        fireOnPostWrite(PROPERTY_EMPLOYE, oldValue, this.employe);
    }

    @Override
    public Collection<Employe> getEmploye() {
        return employe;
    }

    @Override
    public Employe getEmployeByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(employe, topiaId);
    }

    @Override
    public int sizeEmploye() {
        if (employe == null) {
            return 0;
        }
        return employe.size();
    }

    @Override
    public boolean isEmployeEmpty() {
        int size = sizeEmploye();
        return size == 0;
    }

    @Override
    public void addStoreBill(Bill storeBill) {
        fireOnPreWrite(PROPERTY_STORE_BILL, null, storeBill);
        if (this.storeBill == null) {
            this.storeBill = new ArrayList<Bill>();
        }

        this.storeBill.add(storeBill);
        fireOnPostWrite(PROPERTY_STORE_BILL, this.storeBill.size(), null, storeBill);
    }

    @Override
    public void addAllStoreBill(Collection<Bill> storeBill) {
        if (storeBill == null) {
            return;
        }
        for (Bill item : storeBill) {
            addStoreBill(item);
        }
    }

    @Override
    public void setStoreBill(Collection<Bill> storeBill) {
        // Copy elements to keep data for fire with new reference
        Collection<Bill> oldValue = this.storeBill != null ? new ArrayList<Bill>(this.storeBill) : null;
        fireOnPreWrite(PROPERTY_STORE_BILL, oldValue, storeBill);
        this.storeBill = storeBill;
        fireOnPostWrite(PROPERTY_STORE_BILL, oldValue, storeBill);
    }

    @Override
    public void removeStoreBill(Bill storeBill) {
        fireOnPreWrite(PROPERTY_STORE_BILL, storeBill, null);
        if (this.storeBill == null || !this.storeBill.remove(storeBill)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_STORE_BILL, this.storeBill.size() + 1, storeBill, null);
    }

    @Override
    public void clearStoreBill() {
        if (this.storeBill == null) {
            return;
        }
        Collection<Bill> oldValue = new ArrayList<Bill>(this.storeBill);
        fireOnPreWrite(PROPERTY_STORE_BILL, oldValue, this.storeBill);
        this.storeBill.clear();
        fireOnPostWrite(PROPERTY_STORE_BILL, oldValue, this.storeBill);
    }

    @Override
    public Collection<Bill> getStoreBill() {
        return storeBill;
    }

    @Override
    public Bill getStoreBillByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(storeBill, topiaId);
    }

    @Override
    public Bill getStoreBill(Store store) {
        if (store == null || this.storeBill == null) {
            return null;
        }
        for (Bill item : this.storeBill) {
            if (store.equals(item.getStore())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizeStoreBill() {
        if (storeBill == null) {
            return 0;
        }
        return storeBill.size();
    }

    @Override
    public boolean isStoreBillEmpty() {
        int size = sizeStoreBill();
        return size == 0;
    }

    @Override
    public void addDepartment(Department department) {
        fireOnPreWrite(PROPERTY_DEPARTMENT, null, department);
        if (this.department == null) {
            this.department = new ArrayList<Department>();
        }

        department.setCompany(this);

        this.department.add(department);
        fireOnPostWrite(PROPERTY_DEPARTMENT, this.department.size(), null, department);
    }

    @Override
    public void addAllDepartment(Collection<Department> department) {
        if (department == null) {
            return;
        }
        for (Department item : department) {
            addDepartment(item);
        }
    }

    @Override
    public void setDepartment(Collection<Department> department) {
        // Copy elements to keep data for fire with new reference
        Collection<Department> oldValue = this.department != null ? new ArrayList<Department>(this.department) : null;
        fireOnPreWrite(PROPERTY_DEPARTMENT, oldValue, department);
        this.department = department;
        fireOnPostWrite(PROPERTY_DEPARTMENT, oldValue, department);
    }

    @Override
    public void removeDepartment(Department department) {
        fireOnPreWrite(PROPERTY_DEPARTMENT, department, null);
        if (this.department == null || !this.department.remove(department)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        department.setCompany(null);

        fireOnPostWrite(PROPERTY_DEPARTMENT, this.department.size() + 1, department, null);
    }

    @Override
    public void clearDepartment() {
        if (this.department == null) {
            return;
        }
        for (Department item : this.department) {
            item.setCompany(null);
        }
        Collection<Department> oldValue = new ArrayList<Department>(this.department);
        fireOnPreWrite(PROPERTY_DEPARTMENT, oldValue, this.department);
        this.department.clear();
        fireOnPostWrite(PROPERTY_DEPARTMENT, oldValue, this.department);
    }

    @Override
    public Collection<Department> getDepartment() {
        return department;
    }

    @Override
    public Department getDepartmentByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(department, topiaId);
    }

    @Override
    public int sizeDepartment() {
        if (department == null) {
            return 0;
        }
        return department.size();
    }

    @Override
    public boolean isDepartmentEmpty() {
        int size = sizeDepartment();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<Bill> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Bill.class);
            List<Bill> findAllByProperties = dao.findAllByProperties("company", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getDepartment() != null) {
              tmp.addAll(getDepartment());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_SIRET, this.siret).
            append(PROPERTY_EMPLOYE, this.employe).
         toString();
        return result;
    }

} //CompanyAbstract
