package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Thu Aug 13 08:24:31 CEST 2015")
public abstract class QueriedEntityAbstract extends TopiaEntityAbstract implements QueriedEntity {

    /**
     * Nom de l'attribut en BD : testAdd
     */
    protected String testAdd;

    private static final long serialVersionUID = 7089563437560574821L;

    static {
    
        I18n.n("topia.test.common.queriedEntity");
        I18n.n("topia.test.common.testAdd");
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_TEST_ADD, String.class, testAdd);
    }

    @Override
    public void setTestAdd(String testAdd) {
        String oldValue = this.testAdd;
        fireOnPreWrite(PROPERTY_TEST_ADD, oldValue, testAdd);
        this.testAdd = testAdd;
        fireOnPostWrite(PROPERTY_TEST_ADD, oldValue, testAdd);
    }

    @Override
    public String getTestAdd() {
        fireOnPreRead(PROPERTY_TEST_ADD, testAdd);

        String result = this.testAdd;

        fireOnPostRead(PROPERTY_TEST_ADD, testAdd);

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_TEST_ADD, this.testAdd).
         toString();
        return result;
    }

} //QueriedEntityAbstract
