/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.AbstractJnlpMojo;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;

public class Generator
extends AbstractGenerator {
    private AbstractJnlpMojo config;

    public Generator(MavenProject mavenProject, AbstractJnlpMojo task, String defaultTemplateResourceName, File resourceLoaderPath, File outputFile, String inputFileTemplatePath, String mainClass, String webstartJarURL) {
        super(mavenProject, resourceLoaderPath, defaultTemplateResourceName, outputFile, inputFileTemplatePath, mainClass, webstartJarURL);
        this.config = task;
    }

    protected String getDependenciesText() {
        return Generator.getDependenciesText(this.config);
    }

    protected String getExtensionsText() {
        return Generator.getExtensionsText(this.config);
    }

    static String getDependenciesText(AbstractJnlpMojo config) {
        String dependenciesText = "";
        List artifacts = config.getPackagedJnlpArtifacts();
        if (artifacts.size() != 0) {
            StringBuffer buffer = new StringBuffer(100 * artifacts.size());
            buffer.append("\n");
            String jarLibPath = null;
            if (config.getLibPath() != null) {
                jarLibPath = config.getLibPath();
                jarLibPath = jarLibPath != null && jarLibPath.trim().length() != 0 ? jarLibPath.trim() : null;
            }
            for (int i = 0; i < artifacts.size(); ++i) {
                Artifact artifact = (Artifact)artifacts.get(i);
                buffer.append("<jar href=\"");
                if (jarLibPath != null) {
                    buffer.append(jarLibPath).append("/");
                }
                buffer.append(artifact.getFile().getName()).append("\"");
                if (config.isOutputJarVersions()) {
                    buffer.append(" version=\"").append(artifact.getVersion()).append("\"");
                }
                if (config.isArtifactWithMainClass(artifact)) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>\n");
            }
            dependenciesText = buffer.toString();
        }
        return dependenciesText;
    }

    static String getExtensionsText(AbstractJnlpMojo config) {
        String text = "";
        Map extensions = config.getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            StringBuffer buffer = new StringBuffer(100 * extensions.size());
            buffer.append("\n");
            Iterator it = extensions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                System.out.println("----------------- Entry = " + entry);
                buffer.append("<extension name=\"");
                buffer.append(entry.getKey());
                buffer.append("\" href=\"");
                buffer.append(entry.getValue());
                buffer.append("\"/>\n");
            }
            text = buffer.toString();
        }
        return text;
    }
}

