/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngineException;

public abstract class REngine {
    protected static REngine lastEngine = null;

    public static REngine engineForClass(String string) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            throw new ClassNotFoundException("can't find engine class " + string);
        }
        Method method = clazz.getMethod("createEngine", null);
        Object object = method.invoke(null, (Object[])null);
        lastEngine = (REngine)object;
        return lastEngine;
    }

    public static REngine getLastEngine() {
        return lastEngine;
    }

    public abstract REXP parse(String var1, boolean var2) throws REngineException;

    public abstract REXP eval(REXP var1, REXP var2, boolean var3) throws REngineException;

    public abstract void assign(String var1, REXP var2, REXP var3) throws REngineException;

    public abstract REXP get(String var1, REXP var2, boolean var3) throws REngineException;

    public abstract REXP resolveReference(REXP var1) throws REngineException;

    public abstract REXP getParentEnvironment(REXP var1, boolean var2) throws REngineException;

    public abstract REXP newEnvironment(REXP var1, boolean var2) throws REngineException;

    public REXP parseAndEval(String string, REXP rEXP, boolean bl) throws REngineException {
        REXP rEXP2 = this.parse(string, false);
        return this.eval(rEXP2, rEXP, bl);
    }

    public REXP parseAndEval(String string) throws REngineException {
        return this.parseAndEval(string, null, true);
    }

    public boolean supportsReferences() {
        return false;
    }

    public boolean supportsEnvironemnts() {
        return false;
    }

    public boolean supportsREPL() {
        return false;
    }

    public void assign(String string, double[] dArray) throws REngineException {
        this.assign(string, new REXPDouble(dArray), null);
    }

    public void assign(String string, int[] nArray) throws REngineException {
        this.assign(string, new REXPInteger(nArray), null);
    }

    public void assign(String string, String[] stringArray) throws REngineException {
        this.assign(string, new REXPString(stringArray), null);
    }

    public void assign(String string, byte[] byArray) throws REngineException {
        this.assign(string, new REXPRaw(byArray), null);
    }

    public String toString() {
        return super.toString() + (lastEngine == this ? "{last}" : "");
    }
}

