/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.BiFunction;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.spgeed.SpgeedMapper;
import org.nuiton.spgeed.SpgeedUtils;
import org.nuiton.spgeed.SqlSession;
import org.nuiton.spgeed.annotations.Script;
import org.nuiton.spgeed.annotations.Select;
import org.nuiton.spgeed.annotations.Update;
import org.nuiton.spgeed.query.Query;

public class ClassCreator {
    private static Log log = LogFactory.getLog(ClassCreator.class);

    public <E> E generate(Class<E> c, SqlSession session, Object ... constructorArgs) throws Exception {
        InvocationHandler handler = this.createInvocationHandler(session);
        InvocationHandlerAdapter invocationHandlerAdapter = InvocationHandlerAdapter.of((InvocationHandler)handler);
        ByteBuddy byteBuddy = new ByteBuddy();
        Class loaded = byteBuddy.subclass(c).method((ElementMatcher)ElementMatchers.named((String)"getSession")).intercept((Implementation)FixedValue.value((Object)session)).method((ElementMatcher)ElementMatchers.isAnnotatedWith(Update.class)).intercept((Implementation)invocationHandlerAdapter).method((ElementMatcher)ElementMatchers.isAnnotatedWith(Select.class)).intercept((Implementation)invocationHandlerAdapter).method((ElementMatcher)ElementMatchers.isAnnotatedWith(Script.class)).intercept((Implementation)invocationHandlerAdapter).make().load(Thread.currentThread().getContextClassLoader()).getLoaded();
        Object result = ConstructorUtils.invokeConstructor((Class)loaded, (Object[])constructorArgs);
        return (E)result;
    }

    protected <E> InvocationHandler createInvocationHandler(SqlSession session) {
        BiFunction<String, Long, Void> runTimeLogger = (annotationLimit, startTime) -> {
            String limit;
            if (!log.isWarnEnabled()) {
                return null;
            }
            String string = limit = "".equals(annotationLimit) ? session.getDefaultTimeOutLimit() : annotationLimit;
            if ("".equals(annotationLimit)) {
                return null;
            }
            Long limitMillis = SpgeedUtils.parsePeriod(limit);
            Long queryTime = System.currentTimeMillis() - startTime;
            if (queryTime >= limitMillis) {
                log.warn((Object)String.format("Execution time exceed %s: %s", limit, SpgeedUtils.getTimer(queryTime)));
            }
            return null;
        };
        InvocationHandler handler = (proxy, method, args) -> {
            Class<? extends SpgeedMapper> mapper;
            String sql;
            Long StartTime = System.currentTimeMillis();
            HashMap<String, Object> parameterValues = new HashMap<String, Object>();
            Parameter[] parameters = method.getParameters();
            int index = 0;
            for (Parameter parameter : parameters) {
                String name = parameter.getName();
                parameterValues.put(name, args[index++]);
            }
            Class<?> returnClass = method.getReturnType();
            Type returnType = method.getGenericReturnType();
            if (method.isAnnotationPresent(Update.class)) {
                Update annotation = method.getDeclaredAnnotation(Update.class);
                sql = annotation.sql();
                mapper = annotation.mapper();
                String[] roles = annotation.roles();
                String limitRuntime = annotation.timeout();
                if (mapper == SpgeedMapper.class) {
                    mapper = session.getDefaultMapper();
                }
                Query query = new Query(session, sql, mapper, type -> method.getDeclaredAnnotation(type), roles, parameterValues, returnClass, returnType);
                Object result = query.executeUpdate();
                runTimeLogger.apply(limitRuntime, StartTime);
                return result;
            }
            if (method.isAnnotationPresent(Select.class)) {
                Select annotation = method.getDeclaredAnnotation(Select.class);
                sql = annotation.sql();
                mapper = annotation.mapper();
                String[] roles = annotation.roles();
                String limitRuntime = annotation.timeout();
                if (mapper == SpgeedMapper.class) {
                    mapper = session.getDefaultMapper();
                }
                Query query = new Query(session, sql, mapper, type -> method.getDeclaredAnnotation(type), roles, parameterValues, returnClass, returnType);
                Object result = query.executeQuery();
                runTimeLogger.apply(limitRuntime, StartTime);
                return result;
            }
            if (method.isAnnotationPresent(Script.class)) {
                Script annotation = method.getDeclaredAnnotation(Script.class);
                String file = annotation.file();
                String limitRuntime = annotation.timeout();
                ClassLoader classLoader = SqlSession.class.getClassLoader();
                InputStream resource = classLoader.getResourceAsStream(file);
                String content = IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
                Query query = new Query(session, content, parameterValues, Boolean.class, new String[0]);
                boolean result = query.execute();
                runTimeLogger.apply(limitRuntime, StartTime);
                return result;
            }
            throw new UnsupportedOperationException("Method not supported " + method.getName());
        };
        return handler;
    }
}

