/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.nuiton.spgeed.ClassCreator;
import org.nuiton.spgeed.PipeFunction;
import org.nuiton.spgeed.PipeFunctions;
import org.postgresql.ds.PGSimpleDataSource;

public class SqlSession
implements AutoCloseable {
    protected Map<String, PipeFunction> pipeFunctions;
    protected DataSource dataSource;
    protected Connection connection;
    protected ClassCreator classCreator = new ClassCreator();

    public SqlSession() {
        this.pipeFunctions = new HashMap<String, PipeFunction>();
        PipeFunctions functions = new PipeFunctions();
        this.addFunction(functions.getExposedFunction());
    }

    public SqlSession(String url, String username, String password) {
        this();
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setUrl(url);
        dataSource.setUser(username);
        dataSource.setPassword(password);
        this.dataSource = dataSource;
    }

    public SqlSession(DataSource dataSource) {
        this();
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addFunction(String name, PipeFunction function) {
        this.pipeFunctions.put(name, function);
    }

    public void addFunction(Map<String, PipeFunction> functions) {
        this.pipeFunctions.putAll(functions);
    }

    public Map<String, PipeFunction> getPipeFunctions() {
        return this.pipeFunctions;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.dataSource.getConnection();
            this.connection.setAutoCommit(false);
        }
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.rollback();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.close();
        }
    }

    public <E> E getDao(Class<E> klass) {
        try {
            E result = this.classCreator.generate(klass, this);
            return result;
        }
        catch (Exception eee) {
            throw new RuntimeException("Can't generate proxy class for " + klass, eee);
        }
    }
}

