/*
 * #%L
 * ScmWebEditor
 * %%
 * Copyright (C) 2009 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;

public class ResetAction extends ScmWebEditorBaseAction {

    private static final long serialVersionUID = -1154924826535371319L;

    private static final Log log = LogFactory.getLog(ResetAction.class);

    protected String lastRevision;

    protected String numRevision;

    protected String address;

    protected String username;

    protected String pw;

    protected String error;


    public String getLastRevision() {
        return lastRevision;
    }

    public String getNumRevision() {
        return numRevision;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getError() {
        return error;
    }

    public String execute() {

        SvnConnection svnConn = new SvnConnection(address);

        //Si le repo n'est pas protege en ecriture on recupere sont UUID
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID == null) {
            repositoryUUID = address;
        }

        if (username == null && pw == null) {
            if (getScmSession().getUsername(repositoryUUID) != null && getScmSession().getPassword(repositoryUUID) != null) {
                //On recupère les identifiants en session
                username = getScmSession().getUsername(repositoryUUID);
                pw = getScmSession().getPassword(repositoryUUID);
            } else {
                username = null;
                pw = null;
            }
        }

        try {

            lastRevision = getHeadRevision(address, username, pw);

            numRevision = getHeadNumberRevision(address, username, pw);


        } catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error("AUTH FAIL");
            }
            error = AUTH_ERROR;
            return AUTH_ERROR;
        } catch (SVNException e1) {
            if (log.isErrorEnabled()) {
                log.error("Can't reach the svn repository");
            }
            error = ERROR_PATH;
            numRevision = null;
            return ERROR_PATH;
        } catch (StringIndexOutOfBoundsException e) {
            if (log.isErrorEnabled()) {
                log.error("Can't reach the svn repository");
            }
            error = ERROR_PATH;
            return ERROR_PATH;
        } catch (IllegalArgumentException e) {
            if (log.isErrorEnabled()) {
                log.error("Problem with file path", e);
            }
            error = ERROR_PATH;
            return ERROR_PATH;
        }

        return SUCCESS;
    }


}
