/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.git;

import java.io.File;
import java.io.IOException;
import javax.naming.AuthenticationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.nuiton.scmwebeditor.api.RepositoryNotFoundException;
import org.nuiton.scmwebeditor.api.ScmFileManager;
import org.nuiton.scmwebeditor.api.dto.CreateDirectoryDto;
import org.nuiton.scmwebeditor.api.dto.MoveFileDto;
import org.nuiton.scmwebeditor.api.dto.RemoveDirectoryDto;
import org.nuiton.scmwebeditor.api.dto.RemoveFileDto;
import org.nuiton.scmwebeditor.api.dto.UploadFileDto;
import org.nuiton.scmwebeditor.api.dto.result.CreateDirectoryResultDto;
import org.nuiton.scmwebeditor.api.dto.result.MoveFileResultDto;
import org.nuiton.scmwebeditor.api.dto.result.RemoveDirectoryResultDto;
import org.nuiton.scmwebeditor.api.dto.result.RemoveFileResultDto;
import org.nuiton.scmwebeditor.api.dto.result.UploadFileResultDto;
import org.nuiton.scmwebeditor.git.GitConnection;

public class GitFileManager
implements ScmFileManager {
    private static final Log log = LogFactory.getLog(GitFileManager.class);
    protected final String PLACEHOLDER_MESSAGE_EN = "This file has been automatically added by SCMWebEditor when you created its directory.\nGit repositories require at least one file per directory, so this file was created according to this rule.\nYou can remove this file once you have added other files in this directory.";
    protected final String PLACEHOLDER_MESSAGE_FR = "Ce fichier a \u00e9t\u00e9 ajout\u00e9 automatiquement par SCMWebEditor lorsque vous avez cr\u00e9\u00e9 son r\u00e9pertoire.\nLes d\u00e9p\u00f4ts Git imposent qu'il y ait au moins un fichier par r\u00e9pertoire, ce fichier a donc \u00e9t\u00e9 cr\u00e9\u00e9 selon cette r\u00e8gle.\nVous pouvez supprimer ce fichier une fois que vous avez ajout\u00e9 d'autres fichiers \u00e0 ce r\u00e9pertoire.";
    GitConnection connection;

    public GitFileManager(GitConnection connection) throws IOException {
        this.connection = connection;
    }

    public UploadFileResultDto uploadFile(UploadFileDto dto) {
        String path;
        String pathOnRepo;
        UploadFileResultDto resultDto = new UploadFileResultDto();
        try {
            this.updateRepository(dto.getUsername(), dto.getPassword());
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (AuthenticationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        resultDto.setFileRoot(this.connection.getAddressGit());
        resultDto.setScmRoot(this.connection.getAddressGit());
        if (dto.getUpload() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileName : " + dto.getUploadFileName()));
            log.debug((Object)("ContentType : " + dto.getUploadContentType()));
        }
        if ((pathOnRepo = dto.getScmPath()).length() > this.connection.getAddressGit().length()) {
            pathOnRepo = pathOnRepo.substring(this.connection.getAddressGit().length() + 1);
            path = pathOnRepo + File.separator + dto.getUploadFileName();
        } else {
            path = dto.getUploadFileName();
        }
        File file = new File(this.connection.getLocalDirectory().getAbsolutePath() + File.separator + path);
        try {
            FileUtils.copyFile((File)dto.getUpload(), (File)file);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't copy the file to the local directory", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(dto.getUsername(), dto.getPassword());
        try {
            Git git;
            block31: {
                git = Git.open((File)this.connection.getLocalDirectory());
                AddCommand add = git.add();
                add.addFilepattern(path);
                try {
                    add.call();
                }
                catch (GitAPIException e) {
                    if (!log.isErrorEnabled()) break block31;
                    log.error((Object)"Can not add new files", (Throwable)e);
                }
            }
            try {
                this.connection.doCommit(git, dto.getUsername(), "unknown", "From scmwebeditor -- add the file : " + dto.getUploadFileName());
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not commit", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Preparing push");
            }
            PushCommand push = git.push();
            push.setRemote(this.connection.getAddressGit());
            push.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                push.call();
            }
            catch (GitAPIException e) {
                boolean fileDeleted = file.delete();
                if (!fileDeleted && log.isDebugEnabled()) {
                    log.debug((Object)("Could not delete file " + file.getAbsolutePath()));
                }
                this.connection.handlePushException(e);
                if (e.getMessage().endsWith("not authorized")) {
                    resultDto.setError("auth error");
                } else {
                    resultDto.setError("error");
                }
                return resultDto;
            }
        }
        catch (IOException e) {
            boolean fileDeleted;
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not open git local repository : " + this.connection.getLocalDirectory().getAbsolutePath()), (Throwable)e);
            }
            if (!(fileDeleted = file.delete()) && log.isDebugEnabled()) {
                log.debug((Object)("Could not delete file " + file.getAbsolutePath()));
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public RemoveFileResultDto removeFile(RemoveFileDto dto) {
        String pathOnRepo;
        RemoveFileResultDto resultDto = new RemoveFileResultDto();
        try {
            this.updateRepository(dto.getUsername(), dto.getPassword());
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (AuthenticationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        resultDto.setFileRoot(this.connection.getAddressGit());
        resultDto.setScmRoot(this.connection.getAddressGit());
        if (dto.getScmPath() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getScmPath().equals("") || dto.getScmPath().equals(this.connection.getAddressGit())) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileName : " + dto.getScmPath()));
        }
        if ((pathOnRepo = dto.getScmPath()).length() > this.connection.getAddressGit().length()) {
            pathOnRepo = pathOnRepo.replace(this.connection.getAddressGit() + "/", "");
        }
        File file = new File(this.connection.getLocalDirectory().getAbsolutePath() + File.separator + pathOnRepo);
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(dto.getUsername(), dto.getPassword());
        try {
            Git git = Git.open((File)this.connection.getLocalDirectory());
            RmCommand rm = git.rm();
            rm.addFilepattern(pathOnRepo);
            try {
                rm.call();
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not remove Git file " + pathOnRepo), (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            file.delete();
            try {
                this.connection.doCommit(git, dto.getUsername(), "unknown", "From scmwebeditor -- remove the file : " + pathOnRepo);
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not commit", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Preparing push");
            }
            PushCommand push = git.push();
            push.setRemote(this.connection.getAddressGit());
            push.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                push.call();
            }
            catch (GitAPIException e) {
                this.connection.handlePushException(e);
                try {
                    this.connection.cloneRepository((CredentialsProvider)credentials);
                }
                catch (AuthenticationException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can not clone repository at address " + this.connection.getAddressGit()));
                    }
                    resultDto.setError("auth error");
                }
                catch (RepositoryNotFoundException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can not clone repository at address " + this.connection.getAddressGit()));
                    }
                    resultDto.setError("error");
                }
                if (e.getMessage().endsWith("not authorized")) {
                    resultDto.setError("auth error");
                } else {
                    resultDto.setError("error");
                }
                return resultDto;
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not open git local repository : " + this.connection.getLocalDirectory().getAbsolutePath()), (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public CreateDirectoryResultDto createDirectory(CreateDirectoryDto dto) {
        File emptyFile;
        File file;
        String pathOnRepo;
        CreateDirectoryResultDto resultDto;
        block26: {
            resultDto = new CreateDirectoryResultDto();
            try {
                this.updateRepository(dto.getUsername(), dto.getPassword());
            }
            catch (RepositoryNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            catch (AuthenticationException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
                }
                resultDto.setError("auth error");
                return resultDto;
            }
            resultDto.setFileRoot(this.connection.getAddressGit());
            resultDto.setScmRoot(this.connection.getAddressGit());
            if (dto.getDirectoryName() == null) {
                resultDto.setError("redirect");
                return resultDto;
            }
            if (dto.getDirectoryName().equals("")) {
                resultDto.setError("redirect");
                return resultDto;
            }
            pathOnRepo = dto.getParentDirectory();
            pathOnRepo = pathOnRepo.length() > this.connection.getAddressGit().length() ? pathOnRepo.substring(this.connection.getAddressGit().length() + 1) : "";
            file = new File(this.connection.getLocalDirectory().getAbsolutePath() + File.separator + pathOnRepo + File.separator + dto.getDirectoryName());
            file.mkdir();
            emptyFile = new File(file.getAbsolutePath() + File.separator + "placeholder");
            try {
                emptyFile.createNewFile();
                FileUtils.writeStringToFile((File)emptyFile, (String)"This file has been automatically added by SCMWebEditor when you created its directory.\nGit repositories require at least one file per directory, so this file was created according to this rule.\nYou can remove this file once you have added other files in this directory.\n\nCe fichier a \u00e9t\u00e9 ajout\u00e9 automatiquement par SCMWebEditor lorsque vous avez cr\u00e9\u00e9 son r\u00e9pertoire.\nLes d\u00e9p\u00f4ts Git imposent qu'il y ait au moins un fichier par r\u00e9pertoire, ce fichier a donc \u00e9t\u00e9 cr\u00e9\u00e9 selon cette r\u00e8gle.\nVous pouvez supprimer ce fichier une fois que vous avez ajout\u00e9 d'autres fichiers \u00e0 ce r\u00e9pertoire.");
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block26;
                log.error((Object)("Can not create file '" + emptyFile.getAbsolutePath() + "'"));
            }
        }
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(dto.getUsername(), dto.getPassword());
        try {
            Git git;
            block27: {
                git = Git.open((File)this.connection.getLocalDirectory());
                AddCommand add = git.add();
                String toAdd = pathOnRepo.equals("") ? dto.getDirectoryName() + "/placeholder" : pathOnRepo + "/" + dto.getDirectoryName() + "/placeholder";
                add.addFilepattern(toAdd);
                try {
                    add.call();
                }
                catch (GitAPIException e) {
                    if (!log.isErrorEnabled()) break block27;
                    log.error((Object)"Can not add new files", (Throwable)e);
                }
            }
            try {
                this.connection.doCommit(git, dto.getUsername(), "unknown", "From scmwebeditor -- create the directory : " + dto.getDirectoryName());
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not commit", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Preparing push");
            }
            PushCommand push = git.push();
            push.setRemote(this.connection.getAddressGit());
            push.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                push.call();
            }
            catch (GitAPIException e) {
                emptyFile.delete();
                file.delete();
                this.connection.handlePushException(e);
                if (e.getMessage().endsWith("not authorized")) {
                    resultDto.setError("auth error");
                } else {
                    resultDto.setError("error");
                }
                return resultDto;
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not open git local repository : " + this.connection.getLocalDirectory().getAbsolutePath()), (Throwable)e);
            }
            emptyFile.delete();
            file.delete();
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public RemoveDirectoryResultDto removeDirectory(RemoveDirectoryDto dto) {
        RemoveDirectoryResultDto resultDto = new RemoveDirectoryResultDto();
        try {
            this.updateRepository(dto.getUsername(), dto.getPassword());
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (AuthenticationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        resultDto.setFileRoot(this.connection.getAddressGit());
        resultDto.setScmRoot(this.connection.getAddressGit());
        if (dto.getDirectoryToRemove() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getDirectoryToRemove().equals("") || dto.getDirectoryToRemove().equals(this.connection.getAddressGit())) {
            resultDto.setError("redirect");
            return resultDto;
        }
        String pathOnRepo = dto.getDirectoryToRemove();
        if (pathOnRepo.length() > this.connection.getAddressGit().length()) {
            pathOnRepo = pathOnRepo.replace(this.connection.getAddressGit() + "/", "");
        }
        File directory = new File(this.connection.getLocalDirectory().getAbsolutePath() + File.separator + pathOnRepo);
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(dto.getUsername(), dto.getPassword());
        try {
            Git git = Git.open((File)this.connection.getLocalDirectory());
            RmCommand rm = git.rm();
            rm.addFilepattern(pathOnRepo);
            try {
                rm.call();
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not execute Git remove " + pathOnRepo), (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            directory.delete();
            try {
                this.connection.doCommit(git, dto.getUsername(), "unknown", "From scmwebeditor -- remove the directory : " + pathOnRepo);
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not commit", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Preparing push");
            }
            PushCommand push = git.push();
            push.setRemote(this.connection.getAddressGit());
            push.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                push.call();
            }
            catch (GitAPIException e) {
                this.connection.handlePushException(e);
                try {
                    this.connection.cloneRepository((CredentialsProvider)credentials);
                }
                catch (AuthenticationException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can not clone repository at address " + this.connection.getAddressGit()));
                    }
                    resultDto.setError("auth error");
                }
                catch (RepositoryNotFoundException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can not clone repository at address " + this.connection.getAddressGit()));
                    }
                    resultDto.setError("error");
                }
                if (e.getMessage().endsWith("not authorized")) {
                    resultDto.setError("auth error");
                } else {
                    resultDto.setError("error");
                }
                return resultDto;
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not open git local repository : " + this.connection.getLocalDirectory().getAbsolutePath()), (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public MoveFileResultDto moveFile(MoveFileDto dto) {
        String pathOnRepoDirectory;
        MoveFileResultDto resultDto = new MoveFileResultDto();
        try {
            this.updateRepository(dto.getUsername(), dto.getPassword());
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        catch (AuthenticationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        resultDto.setFileRoot(this.connection.getAddressGit());
        resultDto.setScmRoot(this.connection.getAddressGit());
        if (dto.getFileToMove() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getFileToMove().equals("") || dto.getFileToMove().equals(resultDto.getFileRoot())) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getDestinationDirectory() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getDestinationDirectory().equals("")) {
            resultDto.setError("redirect");
            return resultDto;
        }
        String pathOnRepoFile = dto.getFileToMove();
        if (pathOnRepoFile.length() > this.connection.getAddressGit().length()) {
            pathOnRepoFile = pathOnRepoFile.replace(this.connection.getAddressGit() + "/", "");
        }
        if ((pathOnRepoDirectory = dto.getDestinationDirectory()).length() > this.connection.getAddressGit().length()) {
            pathOnRepoDirectory = pathOnRepoDirectory.replace(this.connection.getAddressGit() + "/", "");
        }
        String sourceFileName = pathOnRepoFile.substring(pathOnRepoFile.lastIndexOf(47) + 1);
        File sourceFile = new File(this.connection.getLocalDirectory().getAbsolutePath() + File.separator + pathOnRepoFile);
        File destFile = new File(this.connection.getLocalDirectory().getAbsolutePath() + File.separator + pathOnRepoDirectory + File.separator + sourceFileName);
        try {
            FileUtils.moveFile((File)sourceFile, (File)destFile);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not move file " + sourceFile.getAbsolutePath() + " to " + destFile.getAbsolutePath()), (Throwable)e);
            }
            return resultDto;
        }
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(dto.getUsername(), dto.getPassword());
        try {
            Git git = Git.open((File)this.connection.getLocalDirectory());
            AddCommand add = git.add();
            add.addFilepattern(pathOnRepoDirectory + "/" + sourceFileName);
            try {
                add.call();
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not execute Git add " + pathOnRepoDirectory + "/" + sourceFileName), (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            try {
                this.connection.doCommit(git, dto.getUsername(), "unknown", "From scmwebeditor -- move the file : " + pathOnRepoFile + " to : " + pathOnRepoDirectory);
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not commit", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Preparing push");
            }
            PushCommand push = git.push();
            push.setRemote(this.connection.getAddressGit());
            push.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                push.call();
            }
            catch (GitAPIException e) {
                this.connection.handlePushException(e);
                try {
                    this.connection.cloneRepository((CredentialsProvider)credentials);
                }
                catch (AuthenticationException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can not clone repository at address " + this.connection.getAddressGit()));
                    }
                    resultDto.setError("auth error");
                }
                catch (RepositoryNotFoundException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can not clone repository at address " + this.connection.getAddressGit()));
                    }
                    resultDto.setError("error");
                }
                if (e.getMessage().endsWith("not authorized")) {
                    resultDto.setError("auth error");
                } else {
                    resultDto.setError("error");
                }
                return resultDto;
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not open git local repository : " + this.connection.getLocalDirectory().getAbsolutePath()), (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public void updateRepository(String username, String password) throws RepositoryNotFoundException, IOException, AuthenticationException {
        String hashedAddress = this.connection.getAddressGit();
        String hashResult = this.connection.hash(this.connection.getAddressGit(), "SHA-512");
        if (hashResult != null) {
            hashedAddress = hashResult;
        }
        this.connection.setLocalDirectory(new File(this.connection.getPathToLocalRepos() + File.separator + hashedAddress));
        UsernamePasswordCredentialsProvider credentials = null;
        if (username != null && password != null) {
            credentials = new UsernamePasswordCredentialsProvider(username, password);
        }
        if (!this.connection.getLocalDirectory().exists()) {
            this.connection.cloneRepository((CredentialsProvider)credentials);
        } else {
            Git git = Git.open((File)this.connection.getLocalDirectory());
            PullCommand pull = git.pull();
            pull.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                pull.call();
            }
            catch (InvalidRemoteException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't pull the remote repository", (Throwable)e);
                }
                this.connection.cloneRepository((CredentialsProvider)credentials);
            }
            catch (JGitInternalException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't pull the remote repository", (Throwable)e);
                }
                this.connection.cloneRepository((CredentialsProvider)credentials);
            }
            catch (TransportException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can't pull the remote repository: " + this.connection.getAddressGit()), (Throwable)e);
                }
                if (e.getMessage().endsWith("500 Internal Server Error")) {
                    throw new AuthenticationException("Can not pull the Git repository: auth failed");
                }
                this.connection.cloneRepository((CredentialsProvider)credentials);
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't pull the remote repository", (Throwable)e);
                }
                this.connection.cloneRepository((CredentialsProvider)credentials);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pulled repository " + this.connection.getAddressGit()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connection to local repository");
        }
        File gitFile = new File(this.connection.getLocalDirectory().getAbsolutePath() + File.separator + ".git");
        FileRepositoryBuilder gitRepoBuilder = new FileRepositoryBuilder();
        gitRepoBuilder.setGitDir(gitFile);
        this.connection.setGitRepo(gitRepoBuilder.build());
        if (!this.connection.getGitRepo().getObjectDatabase().exists() && log.isErrorEnabled()) {
            log.error((Object)("The repository at address " + this.connection.getAddressGit() + " doesn't exist"));
            throw new RepositoryNotFoundException("The repository at address " + this.connection.getAddressGit() + " doesn't exist");
        }
    }
}

