/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class VATIdentificationNumberFieldValidator
extends NuitonFieldValidatorSupport {
    protected static String VAT_INTRA_REGEXP = "^(RO\\d{2,10}|GB\\d{5}|(ATU|DK|FI|HU|LU|MT|CZ|SI)\\d{8}|IE[A-Z\\d]{8}|(DE|BG|EE|EL|LT|BE0|PT|CZ)\\d{9}|CY\\d{8}[A-Z]|(ES|GB)[A-Z\\d]{9}|(BE0|PL|SK|CZ)\\d{10}|(FR|IT|LV)\\d{11}|(LT|SE)\\d{12}|(NL|GB)[A-Z\\d]{12})$";
    protected static Pattern p = Pattern.compile(VAT_INTRA_REGEXP);

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                return;
            }
            Matcher m = p.matcher((String)value);
            if (!m.matches()) {
                this.addFieldError(fieldName, object);
            }
        } else {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "VATIdentificationNumber";
    }
}

