/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.converter;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.NuitonConverter;

public class URIConverter
implements NuitonConverter<URI> {
    private static final Log LOGGER = LogFactory.getLog(URIConverter.class);

    @Override
    public <T> T convert(Class<T> aClass, Object value) {
        if (value == null) {
            throw new ConversionException(String.format("No value specified for converter %s", this));
        }
        if (this.isEnabled(aClass)) {
            if (this.isEnabled(value.getClass())) {
                Object result = value;
                return aClass.cast(result);
            }
            if (value instanceof String) {
                URI result = this.valueOf((String)value);
                return aClass.cast(result);
            }
        }
        throw new ConversionException(String.format("no convertor found for type %2$s and objet '%1$s'", aClass.getName(), value));
    }

    protected URI valueOf(String value) {
        try {
            URI result = new URI(value);
            return result;
        }
        catch (URISyntaxException e) {
            throw new ConversionException(String.format("a problem occurs while converting value '%s' with url convertor %s", value, this), e);
        }
    }

    public URIConverter() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("init uri converter " + this);
        }
    }

    protected boolean isEnabled(Class<?> aClass) {
        return URI.class.equals(aClass);
    }

    @Override
    public Class<URI> getType() {
        return URI.class;
    }
}

