/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class WorkdayUtil {
    public static long computeWorday(LocalDate start, LocalDate end, Set<DayOfWeek> weekWorkday, Function<Year, List<LocalDate>> publicHoliday) {
        HashSet publicHolidays = new HashSet();
        int lastYear = end.getYear();
        for (int year = start.getYear(); year <= lastYear; ++year) {
            publicHolidays.addAll(publicHoliday.apply(Year.of(year)));
        }
        long publicHolidayNumber = publicHolidays.stream().filter(d -> weekWorkday.contains(d.getDayOfWeek())).filter(d -> start.compareTo((ChronoLocalDate)d) * d.compareTo(end) >= 0).count();
        long days = ChronoUnit.DAYS.between(start, end);
        long week = days / (long)DayOfWeek.values().length;
        long result = week * (long)weekWorkday.size();
        LocalDate lastDays = end.minusDays(days % (long)DayOfWeek.values().length);
        while (lastDays.isBefore(end)) {
            if (weekWorkday.contains(lastDays.getDayOfWeek())) {
                ++result;
            }
            lastDays = lastDays.plusDays(1L);
        }
        return result -= publicHolidayNumber;
    }

    public static LocalDate computeEaster(Year year) {
        int y = year.getValue();
        int n = y % 19;
        int c = y / 100;
        int u = y % 100;
        int s2 = c / 4;
        int t = c % 4;
        int p = (c + 8) / 25;
        int q = (c - p + 1) / 3;
        int e = (19 * n + c - s2 - q + 15) % 30;
        int b = u / 4;
        int d = u % 4;
        int L = (32 + 2 * t + 2 * b - e - d) % 7;
        int h2 = (n + 11 * e + 22 * L) / 451;
        int m3 = (e + L - 7 * h2 + 114) / 31;
        int j = (e + L - 7 * h2 + 114) % 31;
        LocalDate easterMonday = LocalDate.of(y, m3, j + 1);
        return easterMonday;
    }

    public static LocalDate computeEasterMonday(LocalDate easter) {
        LocalDate easterMonday = easter.plusDays(1L);
        return easterMonday;
    }

    public static LocalDate computeAscensionDay(LocalDate easter) {
        LocalDate ascensionDay = easter.plusDays(39L);
        return ascensionDay;
    }

    public static LocalDate computeWhitMonday(LocalDate easter) {
        LocalDate whitMonday = easter.plusDays(50L);
        return whitMonday;
    }

    public static class FrenchPublicHoliday
    implements Function<Year, List<LocalDate>> {
        @Override
        public List<LocalDate> apply(Year year) {
            LocalDate easter = WorkdayUtil.computeEaster(year);
            LinkedList<LocalDate> result = new LinkedList<LocalDate>();
            result.add(WorkdayUtil.computeEasterMonday(easter));
            result.add(WorkdayUtil.computeAscensionDay(easter));
            result.add(WorkdayUtil.computeWhitMonday(easter));
            result.add(LocalDate.of(year.getValue(), 1, 1));
            result.add(LocalDate.of(year.getValue(), 5, 1));
            result.add(LocalDate.of(year.getValue(), 5, 8));
            result.add(LocalDate.of(year.getValue(), 7, 14));
            result.add(LocalDate.of(year.getValue(), 8, 15));
            result.add(LocalDate.of(year.getValue(), 11, 1));
            result.add(LocalDate.of(year.getValue(), 11, 11));
            result.add(LocalDate.of(year.getValue(), 12, 25));
            return result;
        }
    }
}

