/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.bundle.I18nBundleEntry;

public class I18nLanguage {
    private static final Log log = LogFactory.getLog(I18nLanguage.class);
    protected Properties resource;
    protected final Locale locale;
    protected String recordFilePath;
    protected boolean missingKeyReturnNull;

    public I18nLanguage(Locale l) {
        this(l, null);
    }

    public I18nLanguage(Locale l, boolean missingKeyReturnNull) {
        this(l, null, missingKeyReturnNull);
    }

    public I18nLanguage(Locale locale, String recordFilePath) {
        this(locale, recordFilePath, false);
    }

    public I18nLanguage(Locale locale, String recordFilePath, boolean missingKeyReturnNull) {
        this.locale = locale;
        this.recordFilePath = recordFilePath;
        this.missingKeyReturnNull = missingKeyReturnNull;
    }

    @Deprecated
    public void load(I18nBundleEntry[] bundleEntries) {
        this.load(bundleEntries, I18nUtil.DEFAULT_CHARSET);
    }

    public void load(I18nBundleEntry[] bundleEntries, Charset encoding) {
        this.resource = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getProperty(String key) {
                String result = super.getProperty(key);
                if (result == null) {
                    return null;
                }
                int pos = result.indexOf("${", 0);
                while (pos != -1) {
                    int posEnd = result.indexOf("}", pos + 1);
                    if (posEnd == -1) continue;
                    String value = this.getProperty(result.substring(pos + 2, posEnd));
                    if (value != null) {
                        result = result.substring(0, pos) + value + result.substring(posEnd + 1);
                        pos = result.indexOf("${", pos + value.length());
                        continue;
                    }
                    pos = result.indexOf("${", posEnd + 1);
                }
                return result;
            }
        };
        try {
            if (log.isInfoEnabled()) {
                log.info("Encoding " + encoding + " will be used to load files");
            }
            for (I18nBundleEntry e : bundleEntries) {
                e.load(this.resource, encoding);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String translate(String sentence) {
        if (this.resource == null) {
            this.recordNotFound(sentence);
            return sentence;
        }
        try {
            String result = this.resource.getProperty(sentence);
            if (result == null || "".equals(result)) {
                this.recordNotFound(sentence);
                result = this.missingKeyReturnNull ? null : sentence;
            }
            return result;
        }
        catch (MissingResourceException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Resource " + sentence + " unavailable", eee);
            }
            return sentence;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error("Unexpected error while translating : ", eee);
            }
            return sentence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordNotFound(String key) {
        block13: {
            if (this.recordFilePath != null && key != null && !"".equals(key)) {
                File f = new File(this.recordFilePath);
                Properties recordProps = new Properties();
                try {
                    if (f.exists()) {
                        try (FileInputStream fis = new FileInputStream(f);){
                            recordProps.load(fis);
                        }
                    }
                    recordProps.put(key, "");
                    try (FileOutputStream fos = new FileOutputStream(f);){
                        recordProps.store(fos, "Adding the key : " + key);
                    }
                }
                catch (FileNotFoundException e) {
                    if (log.isErrorEnabled()) {
                        log.error(e);
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block13;
                    log.error(e);
                }
            }
        }
    }

    public String untranslate(String sentence) {
        if (this.resource == null) {
            return sentence;
        }
        try {
            Enumeration<?> e = this.resource.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String translation = this.resource.getProperty(key);
                if (!sentence.equals(translation)) continue;
                return key;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return sentence;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int size() {
        return this.resource == null ? 0 : this.resource.size();
    }

    public void close() {
        if (this.resource != null) {
            if (log.isInfoEnabled()) {
                log.info("closing " + this);
            }
            this.resource.clear();
            this.resource = null;
        }
    }

    public boolean hasRecord(String sentence) {
        boolean result = false;
        if (sentence != null) {
            result = this.resource.containsKey(sentence);
            String value = this.resource.getProperty(sentence);
            result &= !"".equals(value);
        }
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof I18nLanguage && this.locale.equals(((I18nLanguage)o).locale);
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public String toString() {
        return "I18nLanguage <locale: " + this.locale + ", nbStences:" + this.size() + '>';
    }
}

