/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.VersionUtil;

@Deprecated
public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Version VZERO = new Version();
    protected final String classifier;
    protected final Integer classifierNumber;
    protected final int[] numbers;
    protected final boolean snapshot;
    protected boolean classifierNumberAttached;
    protected transient String version;

    public Version() {
        this(0);
    }

    public Version(int ... numbers) {
        this(null, null, false, numbers);
    }

    public Version(String classifier, Integer classiferNumber, int ... numbers) {
        this(classifier, classiferNumber, false, numbers);
    }

    public Version(String classifier, Integer classiferNumber, boolean snapshot, int ... numbers) {
        int[] nArray;
        if (numbers.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = numbers;
        }
        this.numbers = nArray;
        this.classifier = classifier == null ? null : classifier.trim().toLowerCase();
        this.classifierNumber = classiferNumber;
        this.snapshot = snapshot;
    }

    public Version(String version) throws IllegalArgumentException {
        Matcher matcher;
        if (version == null || version.trim().isEmpty()) {
            version = "0";
        }
        if (!(matcher = VersionUtil.VERSION_PATTERN.matcher(version)).matches()) {
            matcher = VersionUtil.VERSION_PATTERN2.matcher(version);
            this.classifierNumberAttached = true;
        }
        if (!matcher.matches()) {
            throw new IllegalArgumentException(I18n.t("nuitonutil.error.version.pattern", version));
        }
        String[] strNumbers = matcher.group(1).split("\\.");
        String strClassifier = matcher.group(2);
        String strClassifierNumber = matcher.group(3);
        String strSnapshot = matcher.group(4);
        Integer intClassifierNumber = null;
        if (strClassifier != null) {
            intClassifierNumber = Integer.valueOf(strClassifierNumber);
        }
        this.snapshot = strSnapshot != null;
        this.numbers = new int[strNumbers.length];
        int j = strNumbers.length;
        for (int i = 0; i < j; ++i) {
            String number = strNumbers[i].trim();
            this.numbers[i] = Integer.valueOf(number);
        }
        this.classifier = strClassifier;
        this.classifierNumber = intClassifierNumber;
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean hasClassifier() {
        return this.classifier != null && !this.classifier.isEmpty();
    }

    public Integer getClassifierNumber() {
        return this.classifierNumber;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public int getNbComponents() {
        return this.numbers.length;
    }

    public boolean isClassifierNumberAttached() {
        return this.classifierNumberAttached;
    }

    public int getNumber(int level) {
        if (level < 0 || level >= this.numbers.length) {
            throw new IllegalArgumentException("not a valid level " + level + " for the VersionNumber " + this);
        }
        return this.numbers[level];
    }

    public String getVersion() {
        if (this.version == null) {
            StringBuilder sb = new StringBuilder();
            for (int number : this.numbers) {
                sb.append('.').append(number);
            }
            if (this.hasClassifier()) {
                sb.append('-');
                sb.append(this.classifier);
                if (!this.classifierNumberAttached) {
                    sb.append('-');
                }
                sb.append(this.classifierNumber);
            }
            if (this.isSnapshot()) {
                sb.append("-SNAPSHOT");
            }
            this.version = sb.substring(1);
        }
        return this.version;
    }

    public String getValidName() {
        String validName = this.getVersion();
        validName = validName.replaceAll("\\.|-", "_");
        return validName;
    }

    public void setClassifierNumberAttached(boolean classifierNumberAttached) {
        if (this.version != null) {
            this.version = null;
        }
        this.classifierNumberAttached = classifierNumberAttached;
    }

    public String toString() {
        String t = this.getVersion();
        return t;
    }

    @Override
    public int compareTo(Version o) {
        int result = VersionUtil.DEFAULT_VERSION_COMPARATOR.compare(this, o);
        return result;
    }

    public boolean before(Version o) {
        int result = this.compareTo(o);
        return result < 0;
    }

    public boolean after(Version o) {
        int result = this.compareTo(o);
        return result > 0;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Version && Arrays.equals(this.numbers, ((Version)obj).numbers) && ObjectUtils.equals(this.classifier, ((Version)obj).classifier) && ObjectUtils.equals(this.classifierNumber, ((Version)obj).classifierNumber) && ObjectUtils.equals(this.snapshot, ((Version)obj).snapshot);
    }

    public int hashCode() {
        return this.getVersion().hashCode();
    }
}

