/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.nuiton.profiling.StatisticMethod;

public class Trace {
    protected boolean distinctThreadCall = false;
    protected boolean multithread = true;
    protected Map<Method, StatisticMethod> commonStatistics;
    protected StatAndStack monoStatAndStack;
    protected ConcurrentLinkedDeque<StatAndStack> allStatAndStack = new ConcurrentLinkedDeque();
    protected static final ThreadLocal<StatAndStack> callStacks = new ThreadLocal();

    public Trace() {
    }

    public Trace(boolean multithread, boolean distinctThreadCall) {
        this.multithread = multithread;
        this.distinctThreadCall = distinctThreadCall;
    }

    public StatAndStack getMonoStatAndStack() {
        if (this.monoStatAndStack == null) {
            this.monoStatAndStack = new StatAndStack(Thread.currentThread().getName(), new ConcurrentHashMap<Method, StatisticMethod>(), new ArrayDeque<Call>());
            this.allStatAndStack.add(this.monoStatAndStack);
        }
        return this.monoStatAndStack;
    }

    protected Map<Method, StatisticMethod> getCommonStatistics() {
        if (this.commonStatistics == null) {
            this.commonStatistics = new ConcurrentHashMap<Method, StatisticMethod>();
        }
        return this.commonStatistics;
    }

    public StatAndStack getStack() {
        StatAndStack result;
        if (!this.multithread) {
            result = this.getMonoStatAndStack();
        } else {
            result = callStacks.get();
            if (result == null) {
                Map<Method, StatisticMethod> stats;
                String threadName;
                ArrayDeque<Call> stack = new ArrayDeque<Call>();
                if (this.distinctThreadCall) {
                    threadName = Thread.currentThread().getName();
                    stats = new ConcurrentHashMap<Method, StatisticMethod>();
                } else {
                    threadName = "ALL";
                    stats = this.getCommonStatistics();
                }
                result = new StatAndStack(threadName, stats, stack);
                callStacks.set(result);
                this.allStatAndStack.add(result);
            }
        }
        return result;
    }

    public void enter(Method method) {
        long current = System.nanoTime();
        Call stackItem = new Call(method, 0L, current, current);
        this.getStack().stack.push(stackItem);
    }

    public void exit(Method method) {
        long current = System.nanoTime();
        StatAndStack ss = this.getStack();
        ArrayDeque<Call> callStack = ss.stack;
        if (!callStack.isEmpty()) {
            Call stackItem = callStack.pop();
            long timeSpent = current - stackItem.timeStart;
            long timeSpentNestMethod = current - stackItem.timeStartNestMethod;
            Method caller = null;
            if (!callStack.isEmpty()) {
                Call parent = callStack.peek();
                parent.add(timeSpentNestMethod);
                caller = parent.method;
            }
            StatisticMethod stat = ss.getStatistics(method);
            stat.add(caller, timeSpent, timeSpentNestMethod, stackItem.callNestMethod);
        }
    }

    public String getStatisticsCSV() {
        StringBuilder result = new StringBuilder();
        result.append("thread;").append("method;").append("call;").append("min;").append("mean;").append("max;").append("total;").append("deviation;").append("slope;").append("call_nest;").append("total_with_nest;").append("callers;").append("\n");
        for (StatAndStack ss : this.allStatAndStack) {
            for (StatisticMethod stat : ss.statistics.values()) {
                stat.exportCSV(result);
                result.append("\n");
            }
        }
        return result.toString();
    }

    public String getStatisticsJson() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        String separator = "";
        for (StatAndStack ss : this.allStatAndStack) {
            for (StatisticMethod stat : ss.statistics.values()) {
                result.append(separator);
                separator = ",";
                stat.exportJSON(result);
                result.append("\n");
            }
        }
        result.append("}");
        return result.toString();
    }

    public void clearStatistics() {
        for (StatAndStack ss : this.allStatAndStack) {
            ss.statistics.clear();
        }
    }

    public String getStatisticsText() {
        StringBuilder result = new StringBuilder();
        result.append("--- Statistics ---\n");
        for (StatAndStack ss : this.allStatAndStack) {
            for (StatisticMethod stat : ss.statistics.values()) {
                stat.exportText(result);
                result.append("\n");
            }
        }
        result.append("--------------------\n");
        return result.toString();
    }

    public void printStatisticsAndClear() {
        this.printStatisticsAndClear(System.out);
    }

    public void printStatisticsAndClear(PrintStream printer) {
        String stat = this.getStatisticsText();
        if (stat != null && !"".equals(stat)) {
            this.clearStatistics();
            printer.println(stat);
        }
    }

    protected static class Call {
        Method method;
        long callNestMethod;
        long timeStart;
        long timeStartNestMethod;

        public Call(Method method, long callNestMethod, long timeStart, long timeStartNestMethod) {
            this.method = method;
            this.callNestMethod = callNestMethod;
            this.timeStart = timeStart;
            this.timeStartNestMethod = timeStartNestMethod;
        }

        public void set(Method method, long callNestMethod, long timeStart, long timeStartNestMethod) {
            this.method = method;
            this.callNestMethod = callNestMethod;
            this.timeStart = timeStart;
            this.timeStartNestMethod = timeStartNestMethod;
        }

        public void add(long time) {
            ++this.callNestMethod;
            this.timeStart += time;
        }
    }

    protected static class StatAndStack {
        protected String threadName;
        protected Map<Method, StatisticMethod> statistics;
        protected ArrayDeque<Call> stack;

        public StatAndStack(String threadName, Map<Method, StatisticMethod> statistics, ArrayDeque<Call> stack) {
            this.threadName = threadName;
            this.statistics = statistics;
            this.stack = stack;
        }

        public StatisticMethod getStatistics(Method method) {
            StatisticMethod result = this.statistics.get(method);
            if (result == null) {
                result = new StatisticMethod(this.threadName, method);
                this.statistics.put(method, result);
            }
            return result;
        }

        public Map<Method, StatisticMethod> getStatistics() {
            return this.statistics;
        }
    }
}

