/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.csv;

import com.csvreader.CsvReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ImportableColumn;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class Import<E>
implements Iterable<E>,
Closeable {
    private static final Log log = LogFactory.getLog(Import.class);
    protected ImportModel<E> model;
    protected CsvReader reader;
    protected boolean validate;

    public static <E> Import<E> newImport(ImportModel<E> model, InputStream inputStream) {
        return new Import<E>(model, inputStream);
    }

    public static <E> Import<E> newImport(ImportModel<E> model, Reader reader) {
        return new Import<E>(model, reader);
    }

    public static <E> Import<E> newImport(ImportModel<E> model, InputStream inputStream, boolean safetySwitch) {
        return new Import<E>(model, inputStream, safetySwitch);
    }

    public static <E> Import<E> newImport(ImportModel<E> model, Reader reader, boolean safetySwitch) {
        return new Import<E>(model, reader, safetySwitch);
    }

    @Override
    public Iterator<E> iterator() {
        this.prepareAndValidate();
        return new Iterator<E>(){
            boolean hasNext;
            List<ImportableColumn<E, Object>> columns;
            int lineNumber;
            {
                this.hasNext = Import.this.readRow();
                this.columns = Import.this.getNonIgnoredHeaders();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() throws NoSuchElementException, ImportRuntimeException {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                ++this.lineNumber;
                Object element = Import.this.model.newEmptyInstance();
                for (ImportableColumn field : this.columns) {
                    String value = Import.this.readValue(field, this.lineNumber);
                    Object parsedValue = Import.this.parseValue(field, this.lineNumber, value);
                    Import.this.setValue(field, this.lineNumber, element, parsedValue);
                }
                this.hasNext = Import.this.readRow();
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        this.reader.close();
    }

    public void prepareAndValidate() {
        if (this.validate) {
            return;
        }
        this.validate = true;
        Object[] headers = this.getHeaders();
        if (log.isTraceEnabled()) {
            log.trace((Object)("headers of the CSV file are : " + Arrays.toString(headers)));
        }
        this.model.pushCsvHeaderNames(Arrays.asList(headers));
        this.checkUniqueModelColumnNames();
        this.checkHeaderNamesAreAllKnown((String[])headers);
        this.checkAllMandatoryHeadersArePresent((String[])headers);
    }

    protected <T> String readValue(ImportableColumn<E, T> field, int lineNumber) {
        try {
            String value = this.reader.get(field.getHeaderName());
            return value;
        }
        catch (Exception e) {
            this.reader.close();
            throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadField", (Object[])new Object[]{field.getHeaderName(), lineNumber}), e);
        }
    }

    protected <T> T parseValue(ImportableColumn<E, T> field, int lineNumber, String value) {
        try {
            T parsedValue = field.parseValue(value);
            return parsedValue;
        }
        catch (Exception e) {
            String message = I18n._((String)"csv.import.error.unableToParseValue", (Object[])new Object[]{value, field.getHeaderName(), lineNumber}) + "\n" + e.getMessage();
            throw new ImportRuntimeException(message, e);
        }
    }

    protected <T> void setValue(ImportableColumn<E, T> field, int lineNumber, E element, T parsedValue) {
        try {
            field.setValue(element, parsedValue);
        }
        catch (Exception e) {
            String message = I18n._((String)"csv.import.error.unableToSetValue", (Object[])new Object[]{parsedValue, element.toString(), lineNumber, field.getHeaderName()});
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new ImportRuntimeException(message, e);
        }
    }

    protected void checkHeaderNamesAreAllKnown(String[] headers) {
        ArrayList csvHeaders = new ArrayList();
        Collections.addAll(csvHeaders, headers);
        for (ImportableColumn<E, Object> field : this.model.getColumnsForImport()) {
            csvHeaders.remove(field.getHeaderName());
        }
        if (!csvHeaders.isEmpty()) {
            LinkedList<String> validHeaderNames = new LinkedList<String>();
            for (ImportableColumn<E, Object> importableColumn : this.model.getColumnsForImport()) {
                validHeaderNames.add(importableColumn.getHeaderName());
            }
            String validationMessage = I18n._((String)"csv.import.error.unrecognizedHeaders", (Object[])new Object[]{StringUtil.join(csvHeaders, (String)", ", (boolean)true), StringUtil.join(validHeaderNames, (String)", ", (boolean)true)});
            throw new ImportRuntimeException(validationMessage);
        }
    }

    protected void checkUniqueModelColumnNames() {
        HashSet<String> headerNames = new HashSet<String>();
        HashSet<String> doubleHeaderNames = new HashSet<String>();
        for (ImportableColumn<E, Object> importableColumn : this.model.getColumnsForImport()) {
            String headerName = importableColumn.getHeaderName();
            boolean alreadyUsed = !headerNames.add(headerName);
            if (!alreadyUsed) continue;
            doubleHeaderNames.add(headerName);
        }
        if (!doubleHeaderNames.isEmpty()) {
            String message = I18n._((String)"csv.import.error.duplicatedHeaders", (Object[])new Object[]{StringUtil.join(doubleHeaderNames, (String)", ", (boolean)true)});
            throw new ImportRuntimeException(message);
        }
    }

    protected void checkAllMandatoryHeadersArePresent(String[] headers) {
        ArrayList csvHeaders = new ArrayList();
        Collections.addAll(csvHeaders, headers);
        ArrayList<String> mandatoryHeadersNames = new ArrayList<String>();
        for (ImportableColumn<E, ?> field : this.getAllMandatoryHeaders()) {
            mandatoryHeadersNames.add(field.getHeaderName());
        }
        mandatoryHeadersNames.removeAll(csvHeaders);
        if (!mandatoryHeadersNames.isEmpty()) {
            String validationMessage = I18n._((String)"csv.import.error.missingMandatoryHeaders", (Object[])new Object[]{StringUtil.join(mandatoryHeadersNames, (String)", ", (boolean)true)});
            throw new ImportRuntimeException(validationMessage);
        }
    }

    protected String[] getHeaders() throws ImportRuntimeException {
        try {
            boolean canReadHeaders = this.reader.readHeaders();
            if (!canReadHeaders) {
                throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadHeaders", (Object[])new Object[0]));
            }
        }
        catch (IOException e) {
            throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadHeaders", (Object[])new Object[0]), e);
        }
        try {
            String[] result = this.reader.getHeaders();
            return result;
        }
        catch (IOException e) {
            throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadHeaders", (Object[])new Object[0]), e);
        }
    }

    protected List<ImportableColumn<E, Object>> getNonIgnoredHeaders() {
        ArrayList<ImportableColumn<ImportableColumn<E, Object>, Object>> nonIgnoredHeaders = new ArrayList<ImportableColumn<ImportableColumn<E, Object>, Object>>();
        for (ImportableColumn<E, Object> field : this.model.getColumnsForImport()) {
            if (field.isIgnored()) continue;
            nonIgnoredHeaders.add(field);
        }
        return nonIgnoredHeaders;
    }

    protected List<ImportableColumn<E, ?>> getAllMandatoryHeaders() {
        ArrayList allMandatoryHeaders = new ArrayList();
        for (ImportableColumn<E, Object> field : this.model.getColumnsForImport()) {
            if (!field.isMandatory()) continue;
            allMandatoryHeaders.add(field);
        }
        return allMandatoryHeaders;
    }

    protected Import(ImportModel<E> model, InputStream inputStream) {
        this(model, inputStream, true);
    }

    protected Import(ImportModel<E> model, Reader reader) {
        this(model, reader, true);
    }

    protected Import(ImportModel<E> model, InputStream inputStream, boolean safetySwitch) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        this.model = model;
        this.reader = new CsvReader(inputStream, model.getSeparator(), Charset.forName("UTF-8"));
        this.reader.setTrimWhitespace(true);
        this.reader.setSafetySwitch(safetySwitch);
    }

    protected Import(ImportModel<E> model, Reader reader, boolean safetySwitch) {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        this.model = model;
        this.reader = new CsvReader(reader, model.getSeparator());
        this.reader.setTrimWhitespace(true);
        this.reader.setSafetySwitch(safetySwitch);
    }

    protected boolean readRow() throws ImportRuntimeException {
        try {
            boolean hasNext = this.reader.readRecord();
            return hasNext;
        }
        catch (IOException e) {
            this.reader.close();
            throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadLine", (Object[])new Object[]{1}), e);
        }
    }
}

