/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.AbstractLicenseMojo;
import org.nuiton.license.plugin.model.License;
import org.nuiton.license.plugin.model.LicenseStore;
import org.nuiton.plugin.PluginWithEncoding;

public abstract class AbstractLicenseNameMojo
extends AbstractLicenseMojo
implements PluginWithEncoding {
    private String encoding;
    private String licenseResolver;
    private boolean keepBackup;
    private String licenseName;
    private LicenseStore licenseStore;

    public abstract boolean isSkip();

    public abstract void setSkip(boolean var1);

    protected boolean checkSkip() {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return false;
        }
        return super.checkSkip();
    }

    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        LicenseStore licenseStore = this.createLicenseStore(this.getLicenseResolver());
        this.setLicenseStore(licenseStore);
        this.checkLicense(this.licenseName);
    }

    public License getMainLicense() throws IllegalArgumentException, IllegalStateException, MojoFailureException {
        this.checkLicense(this.licenseName);
        License mainLicense = this.getLicense(this.licenseName);
        return mainLicense;
    }

    public License getLicense(String licenseName) throws IllegalArgumentException, IllegalStateException {
        if (StringUtils.isEmpty((String)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        LicenseStore licenseStore = this.getLicenseStore();
        if (licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License mainLicense = licenseStore.getLicense(licenseName);
        return mainLicense;
    }

    protected void checkLicense(String licenseName) throws IllegalArgumentException, IllegalStateException, MojoFailureException {
        if (StringUtils.isEmpty((String)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        LicenseStore licenseStore = this.getLicenseStore();
        if (licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License mainLicense = licenseStore.getLicense(licenseName);
        if (mainLicense == null) {
            throw new MojoFailureException("License named '" + mainLicense + "' is unknown, use one of " + Arrays.toString(licenseStore.getLicenseNames()));
        }
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isKeepBackup() {
        return this.keepBackup;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String getLicenseResolver() {
        return this.licenseResolver;
    }

    public LicenseStore getLicenseStore() {
        return this.licenseStore;
    }

    public void setKeepBackup(boolean keepBackup) {
        this.keepBackup = keepBackup;
    }

    public void setLicenseResolver(String licenseResolver) {
        this.licenseResolver = licenseResolver;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setLicenseStore(LicenseStore licenseStore) {
        this.licenseStore = licenseStore;
    }
}

