/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import org.nuiton.license.plugin.AbstractLicenseWithDescriptorMojo;
import org.nuiton.license.plugin.model.License;
import org.nuiton.plugin.PluginHelper;

public class UpdateProjectLicenseMojo
extends AbstractLicenseWithDescriptorMojo {
    protected File licenseFile;
    protected File outputDirectory;
    protected boolean generateBundle;
    protected String bundleLicensePath;
    protected boolean force;
    protected boolean skipUpdateProjectLicense;
    protected boolean doGenerate;

    @Override
    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        super.init();
        File licenseFile = this.getLicenseFile();
        if (licenseFile != null) {
            this.setDoGenerate(this.isForce() || !this.isFileNewerThanPomFile(licenseFile));
        }
    }

    protected void doAction() throws Exception {
        License mainLicense = this.getMainLicense();
        File target = this.getLicenseFile();
        if (this.isDoGenerate()) {
            this.getLog().info((CharSequence)("Will create or update license file [" + mainLicense.getName() + "] to " + target));
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("detail of license :\n" + mainLicense));
            }
            if (target.exists() && this.isKeepBackup()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("backup " + target));
                }
                this.backupFile(target);
            }
        }
        String licenseContent = mainLicense.getLicenseContent(this.getEncoding());
        if (this.isDoGenerate()) {
            this.writeFile(target, licenseContent, this.getEncoding());
        }
        if (this.hasClassPath()) {
            File resourceTarget = new File(this.getOutputDirectory(), target.getName());
            this.copyFile(this.getLicenseFile(), resourceTarget);
            if (this.isGenerateBundle()) {
                File bundleTarget = PluginHelper.getFile((File)this.getOutputDirectory(), (String[])new String[]{this.getBundleLicensePath()});
                this.copyFile(target, bundleTarget);
            }
            this.addResourceDir(this.getOutputDirectory(), new String[]{"**/*.txt"});
        }
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public boolean isGenerateBundle() {
        return this.generateBundle;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getBundleLicensePath() {
        return this.bundleLicensePath;
    }

    public boolean isDoGenerate() {
        return this.doGenerate;
    }

    public boolean isForce() {
        return this.force;
    }

    @Override
    public boolean isSkip() {
        return this.skipUpdateProjectLicense;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setGenerateBundle(boolean generateBundle) {
        this.generateBundle = generateBundle;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setBundleLicensePath(String bundleLicensePath) {
        this.bundleLicensePath = bundleLicensePath;
    }

    public void setDoGenerate(boolean doGenerate) {
        this.doGenerate = doGenerate;
    }

    @Override
    public void setSkip(boolean skipUpdateProjectLicense) {
        this.skipUpdateProjectLicense = skipUpdateProjectLicense;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

