/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuiton.license.plugin.AbstractLicenseMojo;
import org.nuiton.license.plugin.header.FileHeader;
import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;
import org.nuiton.license.plugin.model.License;
import org.nuiton.license.plugin.model.LicenseStore;
import org.nuiton.license.plugin.model.descriptor.FileSet;
import org.nuiton.license.plugin.model.descriptor.Header;
import org.nuiton.license.plugin.model.descriptor.LicenseProjectDescriptor;
import org.nuiton.license.plugin.model.descriptor.io.xpp3.LicenseProjectDescriptorXpp3Reader;

public abstract class AbstractLicenseWithDescriptorMojo
extends AbstractLicenseMojo {
    private File descriptor;
    private String licenseResolver;
    private boolean keepBackup;
    private Map<String, FileHeaderTransformer> transformers;
    private LicenseStore licenseStore;
    private LicenseProjectDescriptor licenseProjectDescriptor;

    public abstract boolean isSkip();

    public abstract void setSkip(boolean var1);

    protected boolean checkSkip() {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return false;
        }
        if (!this.getDescriptor().exists()) {
            this.getLog().warn((CharSequence)("skip - could not find descriptor " + this.getDescriptor()));
            return false;
        }
        return super.checkSkip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        LicenseStore licenseStore = this.createLicenseStore(this.getLicenseResolver());
        this.setLicenseStore(licenseStore);
        File descriptorFile = new File(this.getDescriptor().getAbsolutePath());
        if (!descriptorFile.exists()) {
            MavenProject mavenProject = this.getProject().getParent();
            if (mavenProject != null) {
                File basedir = this.getProject().getBasedir();
                String path = descriptorFile.getAbsolutePath().substring(basedir.getAbsolutePath().length() + 1);
                this.setDescriptor(new File(mavenProject.getBasedir() + File.separator + path));
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("try in parent module " + this.getDescriptor()));
                }
            }
            descriptorFile = new File(this.getDescriptor().getAbsolutePath());
        }
        if (!descriptorFile.exists()) {
            return;
        }
        this.getLog().info((CharSequence)("Loading descriptor " + descriptorFile));
        LicenseProjectDescriptor licenseProject = null;
        FileReader reader = new FileReader(descriptorFile);
        try {
            licenseProject = new LicenseProjectDescriptorXpp3Reader().read(reader);
            this.setLicenseProjectDescriptor(licenseProject);
        }
        finally {
            reader.close();
        }
        this.validateLicenseProjectDescriptor(licenseProject, licenseStore, this.getTransformers());
    }

    public File getDescriptor() {
        return this.descriptor;
    }

    public boolean isKeepBackup() {
        return this.keepBackup;
    }

    public Map<String, FileHeaderTransformer> getTransformers() {
        return this.transformers;
    }

    public String getLicenseResolver() {
        return this.licenseResolver;
    }

    public LicenseStore getLicenseStore() {
        return this.licenseStore;
    }

    public LicenseProjectDescriptor getLicenseProjectDescriptor() {
        return this.licenseProjectDescriptor;
    }

    public void setKeepBackup(boolean keepBackup) {
        this.keepBackup = keepBackup;
    }

    public void setDescriptor(File descriptor) {
        this.descriptor = descriptor;
    }

    public void setLicenseResolver(String licenseResolver) {
        this.licenseResolver = licenseResolver;
    }

    public void setTransformers(Map<String, FileHeaderTransformer> transformers) {
        this.transformers = transformers;
    }

    public void setLicenseStore(LicenseStore licenseStore) {
        this.licenseStore = licenseStore;
    }

    public void setLicenseProjectDescriptor(LicenseProjectDescriptor licenseProjectDescriptor) {
        this.licenseProjectDescriptor = licenseProjectDescriptor;
    }

    public License getMainLicense() throws IllegalArgumentException, IllegalStateException {
        LicenseProjectDescriptor licenseProject = this.getLicenseProjectDescriptor();
        if (licenseProject == null) {
            throw new IllegalStateException("No license project initialized!");
        }
        String mainLicenseName = licenseProject.getMainLicense();
        if (StringUtils.isEmpty((String)mainLicenseName)) {
            throw new IllegalArgumentException("main license name can not be null, nor empty");
        }
        License mainLicense = this.getLicense(mainLicenseName);
        return mainLicense;
    }

    public License getLicense(String licenseName) throws IllegalArgumentException, IllegalStateException {
        if (StringUtils.isEmpty((String)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        LicenseStore licenseStore = this.getLicenseStore();
        if (licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License mainLicense = licenseStore.getLicense(licenseName);
        return mainLicense;
    }

    public FileHeaderTransformer getTransformer(String transformerName) throws IllegalArgumentException, IllegalStateException {
        if (StringUtils.isEmpty((String)transformerName)) {
            throw new IllegalArgumentException("transformerName can not be null, nor empty!");
        }
        Map<String, FileHeaderTransformer> transformers = this.getTransformers();
        if (transformers == null) {
            throw new IllegalStateException("No transformers initialized!");
        }
        FileHeaderTransformer transformer = transformers.get(transformerName);
        return transformer;
    }

    protected FileHeader buildDefaultFileHeader(License license, String projectName, String inceptionYear, String copyrightHolder, boolean addSvnKeyWords, String encoding) throws IOException {
        FileHeader result = new FileHeader();
        StringBuilder buffer = new StringBuilder();
        buffer.append(projectName);
        if (addSvnKeyWords) {
            char ls = '\n';
            buffer.append(ls);
            buffer.append(ls).append("$Id$");
            buffer.append(ls).append("$HeadURL$");
        }
        result.setDescription(buffer.toString());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("header description : " + result.getDescription()));
        }
        String licenseContent = license.getHeaderContent(encoding);
        result.setLicense(licenseContent);
        Integer firstYear = Integer.valueOf(inceptionYear);
        result.setCopyrightFirstYear(firstYear);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Integer lastYear = cal.get(1);
        if (firstYear < lastYear) {
            result.setCopyrightLastYear(lastYear);
        }
        result.setCopyrightHolder(copyrightHolder);
        return result;
    }

    protected void validateLicenseProjectDescriptor(LicenseProjectDescriptor licenseProjectDescriptor, LicenseStore licenseStore, Map<String, FileHeaderTransformer> transformers) throws MojoFailureException {
        List<String> licenseNames = Arrays.asList(licenseStore.getLicenseNames());
        String mainLicense = licenseProjectDescriptor.getMainLicense();
        if (licenseStore.getLicense(mainLicense) == null) {
            throw new MojoFailureException("main license '" + mainLicense + "' is unknown, use one of " + licenseNames);
        }
        Header singleHeader = licenseProjectDescriptor.getHeader();
        if (singleHeader != null) {
            licenseProjectDescriptor.addHeader(singleHeader);
            licenseProjectDescriptor.setHeader(null);
        }
        for (Header header : licenseProjectDescriptor.getHeaders()) {
            String headerType = header.getCommentStyle();
            if (this.getTransformer(headerType) == null) {
                throw new MojoFailureException("headerType '" + headerType + "' is unknown, use one of " + transformers.keySet());
            }
            String licenseName = header.getLicenseName();
            if (StringUtils.isEmpty((String)licenseName)) {
                header.setLicenseName(mainLicense);
            } else if (licenseStore.getLicense(licenseName) == null) {
                throw new MojoFailureException("license '" + licenseName + "' is unknown, use one of " + licenseNames);
            }
            FileSet singleFileSet = header.getFileSet();
            if (singleFileSet != null) {
                header.addFileSet(singleFileSet);
                header.setFileSet(null);
            }
            for (FileSet fileSet : header.getFileSets()) {
                String singleExclude;
                String singleInclude = fileSet.getInclude();
                if (singleInclude != null) {
                    fileSet.addInclude(singleInclude);
                    fileSet.setInclude(null);
                }
                if ((singleExclude = fileSet.getExclude()) == null) continue;
                fileSet.addExclude(singleExclude);
                fileSet.setExclude(null);
            }
        }
    }
}

