/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyUtil {
    private static final Log log = LogFactory.getLog(DependencyUtil.class);

    public static void sortArtifacts(DependencyNode rootNode, List<Artifact> artifacts, boolean verbose) {
        if (artifacts.size() < 2) {
            return;
        }
        HashMap<String, ArtifactDependencyEntry> dico = new HashMap<String, ArtifactDependencyEntry>(artifacts.size());
        for (Artifact a : artifacts) {
            ArtifactDependencyEntry entry = new ArtifactDependencyEntry(a);
            dico.put(entry.artifactKey, entry);
        }
        HashSet<String> universe = new HashSet<String>(dico.keySet());
        DependencyUtil.setNodes(rootNode, dico, universe, verbose);
        ArrayList parsed = new ArrayList();
        for (ArtifactDependencyEntry entry : dico.values()) {
            List<String> dependencies = DependencyUtil.getDependencies(rootNode, entry, universe, verbose);
            entry.depIds = dependencies;
        }
        int level = 0;
        while (true) {
            ArtifactDependencyEntry entry;
            if (verbose) {
                log.info((Object)("run into level " + level++));
            }
            ArrayList<String> levelFixed = new ArrayList<String>();
            for (String key : universe) {
                entry = (ArtifactDependencyEntry)dico.get(key);
                if (!entry.depIds.isEmpty()) continue;
                levelFixed.add(key);
                if (!verbose) continue;
                log.info((Object)("fixed artifact " + key));
            }
            if (levelFixed.isEmpty()) {
                throw new IllegalStateException("cycle detecte ! entre les artifacts " + universe);
            }
            universe.removeAll(levelFixed);
            parsed.addAll(levelFixed);
            if (universe.isEmpty()) break;
            for (String key : universe) {
                entry = (ArtifactDependencyEntry)dico.get(key);
                entry.depIds.removeAll(levelFixed);
            }
            levelFixed.clear();
        }
        artifacts.clear();
        for (String key : parsed) {
            artifacts.add(((ArtifactDependencyEntry)dico.get((Object)key)).artifact);
        }
    }

    protected static String getArtifactId(Artifact artifact) {
        return artifact.getArtifactId() + ":" + artifact.getGroupId();
    }

    protected static List<String> getDependencies(DependencyNode rootNode, ArtifactDependencyEntry entry, Set<String> universe, boolean verbose) {
        ArrayList<String> order = new ArrayList<String>();
        HashSet<String> exclude = new HashSet<String>();
        if (verbose) {
            log.info((Object)("start [" + entry.artifactKey + "]"));
        }
        DependencyNode node = entry.node;
        DependencyUtil.getDependencies(rootNode, node, entry.artifactKey, universe, verbose, order, exclude);
        return order;
    }

    private static void getDependencies(DependencyNode rootNode, DependencyNode node, String artifactKey, Set<String> universe, boolean verbose, List<String> order, Set<String> exclude) {
        Iterator itr = node.preorderIterator();
        while (itr.hasNext()) {
            DependencyNode d = (DependencyNode)itr.next();
            Artifact artifact = d.getArtifact();
            String key = DependencyUtil.getArtifactId(artifact);
            if (artifactKey.equals(key) || order.contains(key) || exclude.contains(key)) continue;
            if (d.getState() != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("!!! doit recuperer le noeud complet pour " + d.getArtifact()));
                }
                DependencyNode node1 = DependencyUtil.getNode(rootNode, key, verbose);
                DependencyUtil.getDependencies(rootNode, node1, artifactKey, universe, verbose, order, exclude);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + artifactKey + "] ???????  [" + key + "]"));
            }
            if (universe.contains(key)) {
                if (verbose) {
                    log.info((Object)(" <<  [" + d.getArtifact() + "]"));
                }
                order.add(key);
                continue;
            }
            exclude.add(key);
        }
    }

    protected static void setNodes(DependencyNode rootNode, Map<String, ArtifactDependencyEntry> dico, Set<String> universe, boolean verbose) {
        Iterator itr = rootNode.preorderIterator();
        while (itr.hasNext()) {
            DependencyNode d = (DependencyNode)itr.next();
            Artifact artifact = d.getArtifact();
            String key = DependencyUtil.getArtifactId(artifact);
            if (log.isDebugEnabled()) {
                log.debug((Object)("key : " + key));
            }
            if (!universe.contains(key) || d.getState() != 0) continue;
            ArtifactDependencyEntry entry = dico.get(key);
            entry.node = d;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("detected node : " + d));
        }
    }

    protected static DependencyNode getNode(DependencyNode rootNode, String requiredKey, boolean verbose) {
        Iterator itr = rootNode.preorderIterator();
        while (itr.hasNext()) {
            DependencyNode d = (DependencyNode)itr.next();
            Artifact artifact = d.getArtifact();
            String key = DependencyUtil.getArtifactId(artifact);
            if (log.isDebugEnabled()) {
                log.debug((Object)("key : " + key));
            }
            if (!requiredKey.equals(key) || d.getState() != 0) continue;
            return d;
        }
        return null;
    }

    public static class ArtifactDependencyEntry {
        protected final Artifact artifact;
        protected final String artifactKey;
        protected DependencyNode node;
        protected List<String> depIds;

        public ArtifactDependencyEntry(Artifact artifact) {
            this.artifact = artifact;
            this.artifactKey = DependencyUtil.getArtifactId(artifact);
        }
    }
}

