/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.nuiton.io.mail.MailSender;
import org.nuiton.io.mail.ProjectJavamailMailSender;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendEmailMojo
extends AbstractPlugin
implements PluginWithEncoding {
    protected MavenProject project;
    protected boolean verbose;
    protected File emailContentFile;
    protected String emailTitle;
    protected String smtpHost;
    protected int smtpPort;
    protected String username;
    protected String password;
    protected boolean sslMode;
    protected String fromDeveloperId;
    protected MailSender mailSender;
    protected List<String> toAddresses;
    protected List<Developer> from;
    protected String mailContentType;
    protected String encoding;
    protected boolean skipSendEmail;
    protected boolean dryRun;
    protected boolean runOnce;
    private boolean runOnceDone;

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    protected void init() throws Exception {
        String fromAddress;
        if (this.isGoalSkip()) {
            return;
        }
        this.runOnceDone = false;
        if (this.runOnce && !this.isExecutionRoot()) {
            this.runOnceDone = true;
            return;
        }
        if (!this.emailContentFile.exists()) {
            throw new MojoExecutionException("could not find the template " + this.emailContentFile);
        }
        if (this.mailSender == null) {
            if (this.from == null || this.from.isEmpty()) {
                throw new MojoExecutionException("The <developers> section in your pom should not be empty. Add a <developer> entry or set the mailSender parameter.");
            }
            if (this.fromDeveloperId == null) {
                Developer dev = this.from.get(0);
                this.mailSender = new MailSender(dev.getName(), dev.getEmail());
            } else {
                for (Developer developer : this.from) {
                    if (!this.fromDeveloperId.equals(developer.getId())) continue;
                    this.mailSender = new MailSender(developer.getName(), developer.getEmail());
                    break;
                }
                if (this.mailSender == null) {
                    throw new MojoExecutionException("Missing developer with id '" + this.fromDeveloperId + "' in the <developers> section in your pom.");
                }
            }
        }
        if (StringUtils.isEmpty((String)(fromAddress = this.mailSender.getEmail()))) {
            throw new MojoExecutionException("Invalid mail sender: name and email is mandatory (" + this.mailSender + ").");
        }
    }

    @Override
    protected boolean checkSkip() {
        if (this.isGoalSkip()) {
            this.getLog().info((CharSequence)"skipGoal flag is on, will skip the goal.");
            return false;
        }
        if (this.runOnce && this.runOnceDone) {
            this.getLog().info((CharSequence)"runOnce flag is on and goal was already executed, will skip the goal");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no mail will be send!\n");
        }
        String newsContent = PluginHelper.readAsString(this.emailContentFile, this.encoding);
        MailMessage mailMsg = this.createMessage(newsContent, this.mailSender);
        ProjectJavamailMailSender mailer = this.createMailer();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("fromDeveloperId: " + this.fromDeveloperId));
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)("Mail title   : " + this.emailTitle));
            this.getLog().info((CharSequence)("Mail content :\n" + mailMsg.getContent()));
            return;
        }
        this.getLog().info((CharSequence)("Connecting to Host: " + this.smtpHost + ":" + this.smtpPort));
        try {
            mailer.send(mailMsg);
            this.getLog().info((CharSequence)"Sent...");
        }
        catch (MailSenderException e) {
            throw new MojoExecutionException("Failed to send email for reason " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected boolean isGoalSkip() {
        return this.skipSendEmail;
    }

    protected MailMessage createMessage(String newsContent, MailSender mailSender) throws MailSenderException {
        String fromName = mailSender.getName();
        String fromAddress = mailSender.getEmail();
        this.getLog().info((CharSequence)("Using this sender for email announcement: " + fromAddress + " < " + fromName + " > "));
        MailMessage mailMsg = new MailMessage();
        mailMsg.setSubject(this.emailTitle);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("email announcement :\n" + newsContent));
        }
        mailMsg.setContent(newsContent);
        mailMsg.setContentType(this.mailContentType);
        mailMsg.setFrom(fromAddress, fromName);
        for (String e : this.toAddresses) {
            this.getLog().info((CharSequence)("Sending mail to " + e + "..."));
            mailMsg.addTo(e, "");
        }
        return mailMsg;
    }

    protected ProjectJavamailMailSender createMailer() {
        ProjectJavamailMailSender mailer = new ProjectJavamailMailSender();
        ConsoleLogger logger = new ConsoleLogger(1, "base");
        if (this.isVerbose()) {
            logger.setThreshold(0);
        }
        mailer.enableLogging((Logger)logger);
        mailer.setSmtpHost(this.smtpHost);
        mailer.setSmtpPort(this.smtpPort);
        mailer.setSslMode(this.sslMode);
        if (this.username != null) {
            mailer.setUsername(this.username);
        }
        if (this.password != null) {
            mailer.setPassword(this.password);
        }
        mailer.initialize();
        return mailer;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setFrom(List<Developer> from) {
        this.from = from;
    }

    public void setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
    }

    @Override
    protected boolean isExecutionRoot() {
        return this.project.isExecutionRoot();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

