/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUpdater;

@Deprecated
public class MirroredFileUpdater
implements FileUpdater {
    private static final Log log = LogFactory.getLog(MirroredFileUpdater.class);
    protected File sourceDirectory;
    protected int prefixSourceDirecotory;
    protected File destinationDirectory;
    protected String fileInPattern = "";
    protected String fileOutPattern = "";

    public MirroredFileUpdater(String fileInPattern, String fileOutPattern, File sourceDirectory, File destinationDirectory) {
        this.fileInPattern = fileInPattern;
        this.fileOutPattern = fileOutPattern;
        this.sourceDirectory = sourceDirectory;
        this.destinationDirectory = destinationDirectory;
        if (sourceDirectory != null) {
            this.prefixSourceDirecotory = sourceDirectory.getAbsolutePath().length();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public String getFileInPattern() {
        return this.fileInPattern;
    }

    public String getFileOutPattern() {
        return this.fileOutPattern;
    }

    public File getMirrorFile(File f) {
        String filename = f.getName();
        String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
        file = file.substring(0, file.length() - filename.length());
        String destFilename = this.applyTransformationFilename(filename);
        String mirrorRelativePath = file + destFilename;
        return new File(this.destinationDirectory + File.separator + mirrorRelativePath);
    }

    @Override
    public boolean isFileUpToDate(File f) {
        File mirror = this.getMirrorFile(f);
        return mirror.exists() && f.lastModified() < mirror.lastModified();
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
        this.prefixSourceDirecotory = sourceDirectory.getAbsolutePath().length();
    }

    public void setFileInPattern(String fileInPattern) {
        this.fileInPattern = fileInPattern;
    }

    public void setFileOutPattern(String fileOutPattern) {
        this.fileOutPattern = fileOutPattern;
    }

    public String applyTransformationFilename(String filename) {
        return filename.replaceAll(this.fileInPattern, this.fileOutPattern);
    }

    public String toString() {
        return super.toString() + "<srcdir:" + this.sourceDirectory + ", destdir:" + this.destinationDirectory + ">";
    }
}

