/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.nuiton.AbstractPlugin;
import org.nuiton.license.License;
import org.nuiton.license.LicenseFactory;

public class LicensePlugin
extends AbstractPlugin {
    protected MavenProject project;
    protected File licenseFile;
    protected String licenseName;
    protected File outputDirectory;
    protected String licenseFilename;
    protected String encoding;
    protected boolean keepBackup;
    protected boolean force;
    protected boolean verbose;
    protected boolean copyToMETA_INF;
    protected String[] extraResolver;
    protected License license;
    boolean doGenerate;

    public LicensePlugin() {
        super("all files are up-to-date.");
    }

    protected boolean hasClassPath() {
        return !"pom".equals(this.project.getPackaging()) && !"site".equals(this.project.getPackaging());
    }

    @Override
    protected boolean ensurePackaging() {
        return false;
    }

    @Override
    protected boolean init() throws Exception {
        this.doGenerate = true;
        if (!this.force) {
            this.doGenerate = !this.isFileNewerThanPomFile(this.licenseFile);
        }
        LicenseFactory factory = LicenseFactory.newInstance(this.extraResolver);
        this.license = factory.revolv(this.licenseName);
        if (this.licenseFilename == null || this.licenseFilename.isEmpty()) {
            this.licenseFilename = this.licenseName;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        this.getLog().info((CharSequence)("using licence [" + this.licenseName + "]"));
        if (this.doGenerate) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("detail : " + this.license));
            }
            if (this.licenseFile.exists() && this.keepBackup) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("backup " + this.licenseFile));
                }
                File backup = new File(this.licenseFile.getAbsolutePath() + "~");
                this.licenseFile.renameTo(backup);
            }
        }
        String licenseContent = this.license.getLicenseContent(this.encoding);
        if (this.doGenerate) {
            this.copyFile(licenseContent, this.licenseFile, this.encoding);
        }
        if (this.hasClassPath()) {
            File target = new File(this.outputDirectory, this.licenseFile.getName());
            this.copyFile(this.licenseFile, target);
            if (this.copyToMETA_INF) {
                this.copyFile(this.licenseFile, new File(this.outputDirectory, "META-INF" + File.separator + this.project.getArtifactId() + "-" + this.licenseFile.getName()));
            }
            this.addResourceDir(this.outputDirectory.getAbsolutePath());
        }
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public License getLicense() {
        return this.license;
    }

    public String[] getExtraResolver() {
        return this.extraResolver;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isKeepBackup() {
        return this.keepBackup;
    }

    public boolean isForce() {
        return this.force;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setExtraResolver(String[] extraResolver) {
        this.extraResolver = extraResolver;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setKeepBackup(boolean keepBackup) {
        this.keepBackup = keepBackup;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }
}

