/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class CheckProjectFilesPlugin
extends AbstractMojo {
    protected MavenProject project;
    protected boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkChangelogFile();
        this.checkReadmeFile();
        this.checkLicenseFile();
    }

    protected void checkChangelogFile() throws MojoExecutionException {
        if (this.project.isExecutionRoot()) {
            File f = new File(this.project.getBasedir(), "changelog.txt");
            if (!f.exists()) {
                throw new MojoExecutionException("the module " + this.project.getName() + " requires the file " + f.getAbsolutePath());
            }
            if (this.verbose) {
                this.getLog().info((CharSequence)("changelog file dectected : " + f.getAbsolutePath()));
            }
        } else {
            this.getLog().info((CharSequence)("changelog.txt is not required for module " + this.project.getName() + " (not a root module)"));
        }
    }

    protected void checkReadmeFile() throws MojoExecutionException {
        File f = new File(this.project.getBasedir(), "README.txt");
        if (!f.exists()) {
            throw new MojoExecutionException("the module " + this.project.getName() + " requires the file " + f.getAbsolutePath());
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("readme file dectected : " + f.getAbsolutePath()));
        }
    }

    protected void checkLicenseFile() throws MojoExecutionException {
        File f = new File(this.project.getBasedir(), "LICENSE.txt");
        if (!f.exists()) {
            throw new MojoExecutionException("the module " + this.project.getName() + " requires the file " + f.getAbsolutePath());
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("license file dectected : " + f.getAbsolutePath()));
        }
    }
}

