/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusTestCase;
import org.junit.Before;
import org.nuiton.AbstractPlugin;
import org.nuiton.util.PluginConfig;

public abstract class BasePluginTestCase {
    protected static File basedir;
    protected static File testDir;
    protected static Iterator<PluginConfig> configItr;
    protected static MyAbstractMojoTestCase delegate;
    protected String goalName;
    protected File pomFile;
    protected AbstractPlugin mojo;

    protected static File getBaseDir() {
        if (basedir == null) {
            String path = PlexusTestCase.getBasedir();
            basedir = new File(path);
        }
        return basedir;
    }

    protected static File getTestDir() {
        return testDir;
    }

    protected static void initConfigs(Class<? extends BasePluginTestCase> klass, String ... testNames) throws Exception {
        ArrayList<PluginConfig> configs = new ArrayList<PluginConfig>();
        String rep = klass.getName();
        rep = rep.replaceAll("\\.", File.separator);
        File f = new File(BasePluginTestCase.getBaseDir(), "target" + File.separator + "test-classes");
        testDir = new File(f, rep);
        System.out.println("test dir : " + testDir);
        for (String testName : testNames) {
            Method m = klass.getMethod(testName, new Class[0]);
            if (m == null) {
                throw new IllegalAccessException("could not find method " + testName + " on class " + klass.getName());
            }
            PluginConfig annotation = m.getAnnotation(PluginConfig.class);
            if (annotation == null) {
                throw new IllegalAccessException("could not find annotation " + PluginConfig.class.getName() + " on method " + testName);
            }
            configs.add(annotation);
        }
        delegate = new MyAbstractMojoTestCase();
        delegate.setUp();
        configItr = configs.iterator();
    }

    @Before
    public void setUp() throws Exception {
        this.initPomFile(configItr.next());
    }

    protected void initPomFile(PluginConfig pluginConfig) throws Exception {
        this.goalName = pluginConfig.goalName();
        this.pomFile = new File(BasePluginTestCase.getTestDir(), pluginConfig.pomName());
        this.mojo = (AbstractPlugin)delegate.lookupMojo(this.goalName, this.pomFile);
        MavenProject project = this.mojo.getProject();
        if (project == null) {
            project = new MavenProject();
            this.mojo.setProject(project);
        }
        this.mojo.getProject().setFile(this.pomFile);
    }

    public static class MyAbstractMojoTestCase
    extends AbstractMojoTestCase {
        public Mojo lookupMojo(String goal, File pom) throws Exception {
            return super.lookupMojo(goal, pom);
        }

        public void setUp() throws Exception {
            super.setUp();
        }

        public void tearDown() throws Exception {
            super.tearDown();
        }

        public PlexusContainer getContainer() {
            return super.getContainer();
        }
    }
}

