/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license;

import java.io.File;
import java.util.Map;
import org.junit.Test;
import org.nuiton.license.BaseLicenseTestCase;
import org.nuiton.license.License;
import org.nuiton.license.LicenseResolver;

public class LicenseResolverTest
extends BaseLicenseTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void testResolvIllegalArgumentException1() throws Exception {
        LicenseResolver resolver = new LicenseResolver();
        resolver.resolv(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolvIllegalArgumentException2() throws Exception {
        LicenseResolver resolver = new LicenseResolver();
        resolver.resolv("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolvIllegalArgumentException3() throws Exception {
        LicenseResolver resolver = new LicenseResolver();
        resolver.resolv("   ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolvIllegalArgumentException4() throws Exception {
        LicenseResolver resolver = new LicenseResolver();
        resolver.resolv("dummy");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolvIllegalArgumentException5() throws Exception {
        LicenseResolver resolver = new LicenseResolver();
        resolver.setBaseURL("dummy");
        resolver.resolv("dummy");
    }

    @Test
    public void testResolv() throws Exception {
        LicenseResolver resolver = new LicenseResolver();
        long timestamp = System.currentTimeMillis();
        String licenseName = "dummy_" + timestamp;
        File repo = this.createLicenseRepository(false);
        resolver.setBaseURL(repo.toURI().toURL().toString());
        try {
            resolver.resolv(licenseName);
            LicenseResolverTest.fail();
        }
        catch (IllegalArgumentException e) {
            LicenseResolverTest.assertTrue((boolean)true);
        }
        this.addLicenseToRepository(repo, licenseName);
        Map licenseNames = resolver.getLicenseNames();
        LicenseResolverTest.assertNotNull((Object)licenseNames);
        LicenseResolverTest.assertEquals((long)1L, (long)licenseNames.size());
        LicenseResolverTest.assertTrue((boolean)licenseNames.containsKey(licenseName));
        License license = resolver.resolv(licenseName);
        LicenseResolverTest.assertNotNull((Object)license);
        LicenseResolverTest.assertEquals((Object)licenseName, (Object)license.getName());
        LicenseResolverTest.assertNotNull((Object)license.getLicenseContent("utf-8"));
        LicenseResolverTest.assertNotNull((Object)license.getHeaderContent("utf-8"));
        LicenseResolverTest.assertEquals((Object)("license:" + licenseName), (Object)license.getLicenseContent("utf-8"));
        LicenseResolverTest.assertEquals((Object)("header:" + licenseName), (Object)license.getHeaderContent("utf-8"));
    }
}

