/*
 * #%L
 * NuitonMatrix :: Nuiton-matrix-gui
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2004 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.math.matrix.gui;

import java.awt.*;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.event.*;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.*;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class MatrixPanelEditor extends org.nuiton.math.matrix.gui.MatrixEditor implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DIMENSION_EDIT = "dimensionEdit";
    public static final String PROPERTY_LINEAR_MODEL = "linearModel";
    public static final String PROPERTY_LINEAR_MODEL_SHOW_DEFAULT = "linearModelShowDefault";
    public static final String PROPERTY_TABLE_MODEL = "tableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_EDIT_VISIBLE = "buttonEdit.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UTU8TQRh+W2mhraCAIkZIUIkXzFYxniDIl0RIUUM9EHtx2h3bIdOZdWYWFg/Gn+BP0LsXE2+ejAfPHrwY/4IxHrwa39ltuxSWj0R72Lb7Pu8zzzzzPvP2B2S0gstbJAgc5QvDmtRZW9jcfFDdojWzTHVNMc9IBdEnlYZ0BQpu5702cLVSsu3FVntxSTY9KajY0z1Tgrw2u5zqBqXGwHh3R03rYrlTngk8X7VZO6KSWF//+pl+5b58kwYIPFRXwK1MHNcV76SnBGnmGhjClbZJkRNRRxmKiTrq7bfvljjR+j5p0mfwAnpLkPWIQjIDV06+5ZAj7A88AwOT6wSXCO66DEE3DFyXqu4IH/8Jp0lMwz6w7tR95kTQh0RQHuE9L2TKGsgbUuV0XbqUG5g6luNRBx1TFDgTlKgWx6Ddr2M9cBal5JSIGDmyB1luyJ1l+pT43NjqYIzqd9EKoZkUVuy+4vBkOTRmVTDDCGfPqd38tfCwauge41Q5kXfOAeSRNDdtafRIyPQ+SB9FgQuKEgMX7LYDR+/gqTtr2Ck5t4ZbZK7TkAndxknpQoemWsR4fCxV35jIAFTShV4MKy1eBZe65hQT4MQJiEc0VYGM8vG1gdHKwdBsYCmKy+i+uFjCsPpnZPjrh+/vV9oZyeLa5xOheyKOs+sp6VFlmF36TBQQ3zBeXCfeTAVymnK8H8L8jyUIK7fKKA7Xi2bLtjv3iG4gRab328dPI0++nIL0CuS5JO4KsfhVyJmGQhckdwPvznyo6PROHz7PWm0GspzsSrQSBmZdYshElQkX/Z0L0ISxBBM6Sqq5z7+Hy+/m20akUNjFQ+GxGZnHkGXCJiC8Llo3QeL1UPA09V0ZJz7pDkjZ77zXmsap8FlM2ukA8Y3coBon2CbP4qYD337dCuXbX7dDtssnYDtXo5xHu7MJFXZ23X/k7Ndtvv8gsMfQAI91aDYye4IYvLgwTnQumXPyBJy920yzVkgPkWZp/gKZI43CBgcAAA==";
    private static final Log log = LogFactory.getLog(org.nuiton.math.matrix.gui.MatrixPanelEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton buttonEdit;
    protected java.lang.Boolean dimensionEdit;
    protected javax.swing.JScrollPane editArea;
    protected java.lang.Boolean linearModel;
    protected java.lang.Boolean linearModelShowDefault;
    protected javax.swing.JTable table;
    protected org.nuiton.math.matrix.gui.MatrixTableModel tableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MatrixPanelEditor $MatrixEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private final static int DEFAULT_WIDTH = 150;
    private final static int DEFAULT_HEIGHT = 150;
    protected Collection<MatrixPanelListener> matrixPanelListeners;
    protected MatrixPopupMenu popupMenu;
    protected MatrixND matrix;
    
    
    public  MatrixPanelEditor(MatrixND m, boolean dimensionEdit) {
        this(dimensionEdit, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        jaxx.runtime.JAXXUtil.assignment(matrix = m, "matrix", org.nuiton.math.matrix.gui.MatrixPanelEditor.this);
    }
    
    public  MatrixPanelEditor(boolean dimensionEdit, int width, int height) {
        this.dimensionEdit = dimensionEdit;
        setPreferredSize(new Dimension(width, height));
    $initialize();
    }
    
    public  MatrixPanelEditor(boolean dimensionEdit) {
        this(dimensionEdit, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    
    public void setMatrix(MatrixND m){
        this.matrix = m;
        initObject();
    }
    
    public MatrixND getMatrix() {
        return matrix;
    }
    
    protected MatrixFactory getFactory() {
        return MatrixFactory.getInstance();
    }
    
    public void addMatrixPanelListener(MatrixPanelListener l) {
        matrixPanelListeners.add(l);
    }
    
    public void removeMatrixPanelListener(MatrixPanelListener l) {
        matrixPanelListeners.remove(l);
    }
    
    protected void initObject() {
        if (getMatrix() == null) {
            editArea.setViewportView(null);
        }
        else {
            jaxx.runtime.JAXXUtil.assignment(popupMenu = new MatrixPopupMenu(this), "popupMenu", org.nuiton.math.matrix.gui.MatrixPanelEditor.this);
            table = new JTable() {
                public void processMouseEvent(MouseEvent event) {
                    if (event.isPopupTrigger()) {
                        popupMenu.show(event.getComponent(), event.getX(), event.getY());
                    }
                    super.processMouseEvent(event);
                }
            };
    
            table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK),"copy");
            table.getActionMap().put("copy",popupMenu.getSendToClipBoardSelectionCopyAction());
            table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK),"paste");
            table.getActionMap().put("paste",popupMenu.getSendToClipBoardCurrentPasteAction());
            if (isLinearModel()) {
                setTableModel(new MatrixTableModelLinear(getMatrix(), isLinearModelShowDefault()));
            }
            else {
                setTableModel(new MatrixTableModelND(getMatrix()));
            }
    
            getTableModel().addTableModelListener(new TableModelListener() {
                @Override
                public void tableChanged(TableModelEvent e) {
                    fireEvent();
                }
            });
    
            table.setModel(getTableModel());
            table.setDefaultRenderer(String.class, tableModel.getMatrixCellRenderer());
            table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
            table.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
            editArea.setViewportView(table);
        }
        repaint();
    }
    
    protected void btnAction() {
        String dim;
        dim = JOptionPane.showInputDialog(null, _("nuitonmatrix.create.matrix.message"), _("nuitonmatrix.create.matrix.title"), JOptionPane.DEFAULT_OPTION);
    
        if (dim != null) {
            String[] sdim = dim.split(";");
            int[] idim = new int[sdim.length];
            for (int i = 0; i < idim.length; i++) {
                idim[i] = Integer.parseInt(sdim[i]);
            }
            setMatrix(getFactory().create(idim));
        }
    }
    
    protected void fireEvent() {
        MatrixPanelEvent e = new MatrixPanelEvent(this);
        for (MatrixPanelListener matrixPanelListener : matrixPanelListeners) {
            matrixPanelListener.matrixChanged(e);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MatrixPanelEditor() {
        $initialize();
    }

    public MatrixPanelEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonEdit(java.awt.event.ActionEvent event) {
        btnAction();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getButtonEdit() {
        return buttonEdit;
    }

    public java.lang.Boolean getDimensionEdit() {
        return dimensionEdit;
    }

    public javax.swing.JScrollPane getEditArea() {
        return editArea;
    }

    public java.lang.Boolean getLinearModel() {
        return linearModel;
    }

    public java.lang.Boolean getLinearModelShowDefault() {
        return linearModelShowDefault;
    }

    public javax.swing.JTable getTable() {
        return table;
    }

    public org.nuiton.math.matrix.gui.MatrixTableModel getTableModel() {
        return tableModel;
    }

    public java.lang.Boolean isDimensionEdit() {
        return dimensionEdit !=null && dimensionEdit;
    }

    public java.lang.Boolean isLinearModel() {
        return linearModel !=null && linearModel;
    }

    public java.lang.Boolean isLinearModelShowDefault() {
        return linearModelShowDefault !=null && linearModelShowDefault;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDimensionEdit(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.dimensionEdit;
        this.dimensionEdit = newValue;
        firePropertyChange(PROPERTY_DIMENSION_EDIT, oldValue, newValue);
    }

    public void setLinearModel(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.linearModel;
        this.linearModel = newValue;
        firePropertyChange(PROPERTY_LINEAR_MODEL, oldValue, newValue);
    }

    public void setLinearModelShowDefault(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.linearModelShowDefault;
        this.linearModelShowDefault = newValue;
        firePropertyChange(PROPERTY_LINEAR_MODEL_SHOW_DEFAULT, oldValue, newValue);
    }

    public void setTableModel(org.nuiton.math.matrix.gui.MatrixTableModel newValue) {
        org.nuiton.math.matrix.gui.MatrixTableModel oldValue = this.tableModel;
        this.tableModel = newValue;
        firePropertyChange(PROPERTY_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditArea() {
        if (!allComponentsCreated) {
            return;
        }
        editArea.getViewport().add(table);
    }

    protected void createButtonEdit() {
        $objectMap.put("buttonEdit", buttonEdit = new javax.swing.JButton());
        
        buttonEdit.setName("buttonEdit");
        buttonEdit.setText(_("nuitonmatrix.create.matrix.button"));
        buttonEdit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonEdit"));
    }

    protected void createDimensionEdit() {
        $objectMap.put("dimensionEdit", dimensionEdit = false);
    }

    protected void createEditArea() {
        $objectMap.put("editArea", editArea = new javax.swing.JScrollPane());
        
        editArea.setName("editArea");
    }

    protected void createLinearModel() {
        $objectMap.put("linearModel", linearModel = false);
    }

    protected void createLinearModelShowDefault() {
        $objectMap.put("linearModelShowDefault", linearModelShowDefault = false);
    }

    protected void createTable() {
        $objectMap.put("table", table = new javax.swing.JTable());
        
        table.setName("table");
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $MatrixEditor0
        add(editArea, BorderLayout.CENTER);
        add(buttonEdit, BorderLayout.SOUTH);
        addChildrenToEditArea();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        table.setCellSelectionEnabled(true);
        table.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$MatrixEditor0", this);
        createTableModel();
        createLinearModel();
        createLinearModelShowDefault();
        createDimensionEdit();
        matrixPanelListeners = new HashSet<MatrixPanelListener>();
        popupMenu = null;
        matrix = null;
        createEditArea();
        createTable();
        createButtonEdit();
        // inline creation of $MatrixEditor0
        setName("$MatrixEditor0");
        setLayout(new BorderLayout());
        
        initObject();// registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_EDIT_VISIBLE, true ,"dimensionEdit") {
        
            @Override
            public void processDataBinding() {
                buttonEdit.setVisible(isDimensionEdit());
            }
        });
    }

}