/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: IssueXpp3Reader.java 238 2012-03-20 21:10:19Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.3/jredmine-client/src/main/java/org/nuiton/jredmine/model/io/xpp3/IssueXpp3Reader.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model.io.xpp3;

import org.nuiton.io.xpp3.AbstractXpp3Reader;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.Project;

import java.beans.IntrospectionException;

import static org.nuiton.io.xpp3.Xpp3Helper.addTagTextContentMappers;

/**
 * {@link Issue} reader.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public class IssueXpp3Reader extends AbstractXpp3Reader<Issue> {

    public IssueXpp3Reader() {
        super(Issue.class, "issues", "issue");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(Issue.class, RedmineDataConverter.Integer, true, allMappers,
                                 "assigned-to-id",
                                 "author-id",
                                 "category-id",
                                 "done-ratio",
                                 "lock-version",
                                 "priority-id",
                                 "project-id",
                                 "status-id",
                                 "tracker-id",
                                 "fixed-version-id",
                                 "id",
                                 "parent-id",
                                 "root-id",
                                 "lft",
                                 "rgt");

        addTagTextContentMappers(Issue.class, RedmineDataConverter.Float, true, allMappers,
                                 "estimated-hours");

        addTagTextContentMappers(Issue.class, RedmineDataConverter.Datetime, true, allMappers,
                                 "created-on",
                                 "updated-on");

        addTagTextContentMappers(Issue.class, RedmineDataConverter.Date, true, allMappers,
                                 "due-date",
                                 "start-date");

        addTagTextContentMappers(Issue.class, RedmineDataConverter.Text, true, allMappers,
                                 "description",
                                 "subject");

        addTagTextContentMappers(Issue.class, RedmineDataConverter.Boolean, true, allMappers,
                                 "is-private");
    }
}
