/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: IssueStatusXpp3Reader.java 193 2011-05-20 22:44:58Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2/jredmine-client/src/main/java/org/nuiton/jredmine/model/io/xpp3/IssueStatusXpp3Reader.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model.io.xpp3;

import org.nuiton.io.xpp3.AbstractXpp3Reader;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueStatus;

import java.beans.IntrospectionException;

import static org.nuiton.io.xpp3.Xpp3Helper.addTagTextContentMappers;

/**
 * {@link Issue} reader.
 *
 * @author chemit
 * @since 1.0.0
 */
public class IssueStatusXpp3Reader extends AbstractXpp3Reader<IssueStatus> {

    public IssueStatusXpp3Reader() {
        super(IssueStatus.class, "issue-statuses", "issue-status");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(IssueStatus.class, RedmineDataConverter.Integer, true, allMappers,
                "id",
                "position",
                "default-done-ratio");

        addTagTextContentMappers(IssueStatus.class, RedmineDataConverter.Boolean, true, allMappers,
                "is-closed",
                "is-default");

        addTagTextContentMappers(IssueStatus.class, RedmineDataConverter.Text, true, allMappers,
                "name");
    }
}
