/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: AttachmentXpp3Reader.java 186 2011-05-20 12:32:08Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2/jredmine-client/src/main/java/org/nuiton/jredmine/model/io/xpp3/AttachmentXpp3Reader.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model.io.xpp3;

import java.beans.IntrospectionException;
import org.nuiton.io.xpp3.AbstractXpp3Reader;
import org.nuiton.jredmine.model.Attachment;
import static org.nuiton.io.xpp3.Xpp3Helper.addTagTextContentMappers;

/**
 * {@link Attachment} reader.
 *
 * @author chemit
 * @since 1.0.0
 */
public class AttachmentXpp3Reader extends AbstractXpp3Reader<Attachment> {

    public AttachmentXpp3Reader() {
        super(Attachment.class, "attachments", "attachment");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(Attachment.class, RedmineDataConverter.Integer, true, allMappers,
                "author-id",
                "container-id",
                "filesize",
                "downloads",
                "id");

        addTagTextContentMappers(Attachment.class, RedmineDataConverter.Datetime, true, allMappers,
                "created-on");

        addTagTextContentMappers(Attachment.class, RedmineDataConverter.Text, true, allMappers,
                "container-type",
                "content-type",
                "description",
                "digest",
                "disk-filename",
                "filename");
    }
}
