package org.nuiton.jaxx.runtime.swing;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import static org.nuiton.i18n.I18n.t;

public class ListToListSelector<B> extends ListSelector<B> {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_ADD_TOOL_TIP_TEXT = "add.toolTipText";
    public static final String BINDING_FROM_CELL_RENDERER = "from.cellRenderer";
    public static final String BINDING_FROM_MODEL = "from.model";
    public static final String BINDING_FROM_SELECTION_MODEL = "from.selectionModel";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_TOOL_TIP_TEXT = "remove.toolTipText";
    public static final String BINDING_TO_CELL_RENDERER = "to.cellRenderer";
    public static final String BINDING_TO_MODEL = "to.model";
    public static final String BINDING_TO_SELECTION_MODEL = "to.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2TTU8TQRjHnxZaXi0iBkyMCQkoKrILFy81ioJESREDHIi9OHRHGDLdGWdmYb1w8ODNL+DBqxfDdyCeTLx45TuY8BF8ZnfbpUlbKnUPu5vn5Tf/eV6+/4GcVvBAqF3HD5gRvrNPwtBRgW9YlTqrT7e313f2acUsU11RTBqhIH4yWciWYcir27UBp1xCkhuTXEtyE5K7JKpS+NQ/ByqWYFCbD5zqPUqNgbstkytau5v1yGIoA5Wc1VR1s7N+fVo4zdDlL1mAUKL8frz27D8A0lv3liDLPAPXSvvkgLic+LsoTjF/Fy90xdqWONH6FanS93AEfSXIS6IQZmDuUuWJcBEqlAYK0yWmzSbl2BSh5g3Mt7qFPkRNjo3eEudzpIxoeQO5qvAoN+BejKglr9mMlFB4p0R1s6IE55L41MCELUCYJK7GntfosfED9bRem2ZgtCHYHmP9I/WwHuJhoccaop4FBmU24oaNSDVY22ijP2uE/btuXzfq1ryiVXEQxU8k8QrutCoFzqCTzmA6Dpky5FSAZgNTrcffTvAGRsWzO9V6du0xUeDH4yP17fDstDawwyhu8qKsc7uJ0yOVkFQZZrWNxNMaGMbdNSKLZRjQSUvRO9Neea35qB5VRF1zLMl5QfQe0nJ9pyc/xt/+7oHsCgxyQbwVYuNfwoDZU1gxwb1QPlmMxA0f9uP7qpWJnatQzjeo71GFSqHwyCOGTO4w38NmPw6xVjPta1WXdrx+9vPr59sntXplUOl0J5lpzXJvIM98znwarXiyvU1XekhqGngiXc1my5qx3zGZbMtU9J5pVoV4D637fhjYz2x0Afs31zGkEPeTCX/tP9B6WSXeshaM8Q4YfdQnO5x6XWKGjBB8i8ktGpquUNZ8rw3hZkeEha4JD7smFNsQbnVEWOya8PwCwl841p76XAgAAA==";
    private static final Log log = LogFactory.getLog(ListToListSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected JList from;
    protected JScrollPane fromScrollpane;
    protected JButton remove;
    protected JList to;
    protected JScrollPane toScrollpane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListToListSelector<B> $ListSelector0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_MODEL, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
    
                Set<String> bindings = $bindings.keySet();
                JAXXUtil.applyDataBinding(ListToListSelector.this, bindings);
                JAXXUtil.processDataBinding(
                        ListToListSelector.this, bindings.toArray(new String[bindings.size()]));
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListToListSelector() {
        $initialize();
    }

    public ListToListSelector(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.remove();
    }

    public void doMouseClicked__on__from(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.add(); }
    }

    public void doMouseClicked__on__to(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.remove(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public JList getFrom() {
        return from;
    }

    public JScrollPane getFromScrollpane() {
        return fromScrollpane;
    }

    public JButton getRemove() {
        return remove;
    }

    public JList getTo() {
        return to;
    }

    public JScrollPane getToScrollpane() {
        return toScrollpane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFromScrollpane() {
        fromScrollpane.getViewport().add(from);
    }

    protected void addChildrenToToScrollpane() {
        toScrollpane.getViewport().add(to);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createFrom() {
        $objectMap.put("from", from = new JList());
        
        from.setName("from");
        from.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__from"));
    }

    protected void createFromScrollpane() {
        $objectMap.put("fromScrollpane", fromScrollpane = new JScrollPane());
        
        fromScrollpane.setName("fromScrollpane");
    }

    @Override
    protected void createModel() {
        $objectMap.put("model", model = new ListSelectorModel());
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createTo() {
        $objectMap.put("to", to = new JList());
        
        to.setName("to");
        to.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__to"));
    }

    protected void createToScrollpane() {
        $objectMap.put("toScrollpane", toScrollpane = new JScrollPane());
        
        toScrollpane.setName("toScrollpane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $ListSelector0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$ListSelector0", $ListSelector0);
        createFromScrollpane();
        createFrom();
        createAdd();
        createToScrollpane();
        createTo();
        createRemove();
        // inline creation of $ListSelector0
        setName("$ListSelector0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FROM_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                from.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setSelectionModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    add.setEnabled(getModel().isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_TEXT, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                add.setToolTipText(t(getAddToolTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TO_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                to.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setSelectionModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    remove.setEnabled(getModel().isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_TEXT, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                remove.setToolTipText(t(getRemoveToolTip()));
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $ListSelector0
        add(fromScrollpane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(add, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(toScrollpane, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFromScrollpane();
        addChildrenToToScrollpane();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 2 property setters
        add.setIcon(SwingUtil.createActionIcon("select"));
        remove.setIcon(SwingUtil.createActionIcon("unselect"));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}