package jaxx.runtime.swing;

import jaxx.runtime.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListSelectorUI<B> extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final String PROPERTY_ADD_TO_COMBO_TIP = "addToComboTip";
    public static final String PROPERTY_ADD_TO_LIST_TIP = "addToListTip";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SHOW_HIDOR = "showHidor";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.ListSelectorUI.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz08bRxTHBwdjzI+EhEAhJREhVZRIwQ63SiCgJkKA3CSKXUTqQzveGfCg2Znt7CwsjRT10D+gf0J776VSbjlVPfTcQy9R/oUo6qHXKm92114vXWwry8GGme/77Pe9mfeWX9+hvKvQ7WPs+yXlCc1sWtr74uDgSfOYWvoRdS3FHC0VCn+GcijXQOOks+5qdKdRNeHlKLy8JW1HCiq6oleraMzVZ5y6LUq1RjeTEZbrlmud7VXf8VSb2jGVRv35n/e5n8gPv+QQ8h1wdwVSWewXFWcyXEU5RjS6Bk86wWWOxRHYUEwcgd9Js7bFses+xjb9Dr1EhSoacbACmEZLg6ccMIJ439Fo9LO9p1hQ/lCfK7p7Cs8tVZmra5RD6aX6atdxgsARjYpuS57uMCKVRleNs5JxW6pIySkWsW7UloQdMkrM35fj9QlMSF0aeh3coakYESYcKycDJSTUlCA1i9NdeMieUEXBxYJB+F22tyjnz6LtrggOWyZjjT7pjtirWUpybnaMshgHRAVagXNJBASrRjTf0Q4beFSQjs54MfsLHdlIi2JiPM+lVLyOm/ychbxlstdoJsENSlKRvhEtdbQFbGkmBbTB9YS6DidTwSopvgS11Wg6Iax4WkthBPdiw4ra8iRwtZzcybfCO3ArJZPgeiRwCn2a0EGfleI+ixthqIHyyoNlKFHj/635DLbCppw715QGGOz+Nzv99+u3r7bbnTgHz55JlXYNEugQR0kHToaZR18J29DTjJe/xM5qA2591Aqwu5BirN0pYA6eF/aFCS/tYLcFiHzhze9/zH771yWU20ZjXGKyjY1+FxV1S0EVJCe+s7EZOJo4HYXPKeMNToDjMwmlRJfXCNZ4sckEgRqv+1CEhZQidJw0i3/+O137bbNdiCEwNn+hPC5G/ms0wgRnggZDKZo3qUNo3HGpR2Q8V9ImzZD5HnOiRvw8+FxLy3TKktyzxU7QIvuMnhrlhu+Zr80gAfNbJeDd6Mszy+s9CDcHcDRuM8Fsz66x72lG1ITVNZR6sBYHYBWoMKOCZMQUD6XQyy7kBgNuLTzyRaxhCjc9Tdc/HpyH0R8OyI92Z5af9yDcHYjQq0L9CV0vmYyc4iF0vG6P92/SQfcHAA0zKxypF5h5kLmw/QnQFhpeKfBKrlNfZzbzogehnDmdwQg/ZiJAQWBycQzDMPo/5QLUSuZ0+hPgslHfwYJktQJvHo3VEe11woNQJkPKPnNZdP8zwAonA2E+ACStA5RMDAAA";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected javax.swing.JToolBar actions;
    protected javax.swing.JButton add;
    protected java.lang.String addToComboTip;
    protected java.lang.String addToListTip;
    protected javax.swing.JComboBox combo;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected jaxx.runtime.swing.Table header;
    protected jaxx.runtime.swing.HidorButton hidor;
    protected javax.swing.JList list;
    protected javax.swing.JScrollPane listPane;
    protected java.lang.Boolean modified;
    protected javax.swing.JButton remove;
    protected javax.swing.ListCellRenderer renderer;
    protected java.lang.Boolean showHidor;
    private ListSelectorUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource11 = new DataBindingListener(this, "combo.renderer");
    private PropertyChangeListener $DataSource13 = new DataBindingListener(this, "add.enabled");
    private PropertyChangeListener $DataSource14 = new DataBindingListener(this, "add.toolTipText");
    private PropertyChangeListener $DataSource16 = new DataBindingListener(this, "remove.enabled");
    private PropertyChangeListener $DataSource17 = new DataBindingListener(this, "remove.toolTipText");
    private PropertyChangeListener $DataSource19 = new DataBindingListener(this, "hidor.enabled");
    private PropertyChangeListener $DataSource23 = new DataBindingListener(this, "hidor.visible");
    private PropertyChangeListener $DataSource5 = new DataBindingListener(this, "$JPanel1.minimumSize");
    private PropertyChangeListener $DataSource6 = new DataBindingListener(this, "list.cellRenderer");
    private PropertyChangeListener $DataSource7 = new DataBindingListener(this, "list.enabled");
    private PropertyChangeListener $DataSource9 = new DataBindingListener(this, "combo.enabled");

    /* begin raw body code */    
    
    /**
     * @return the datas from the combo box.
     */
    public java.util.List<B> getComboDatas() {
        java.util.List<B> datas = new java.util.ArrayList<B>();
        ComboBoxModel comboModel = combo.getModel();
        for (int i = 0, j = comboModel.getSize(); i < j; i++) {
            B g = (B) comboModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }
    
    /**
     * @return the data for the list.
     */
    public java.util.List<B> getListDatas() {
        java.util.List<B> datas = new java.util.ArrayList<B>();
        ListModel listModel = list.getModel();
        for (int i = 0, j = listModel.getSize(); i < j; i++) {
            B g = (B) listModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }
    
    /**
     * Initialize the component.
     *
     * @param toCombo datas to set in combo
     * @param toList  datas to set in list
     */
    public void init(java.util.List<B> toCombo, java.util.List<B> toList) {
        setComboDatas(toCombo);
        setListDatas(toList);
        // after init, always unmodified editor
        // TODO should avoid to fire a changed ?
        setModified(false);
    }
    
    /**
     * Transfert the {@code b} data from combo box to list.
     *
     * @param b the data to transfert
     */
    protected void transfertToList(B b) {
        ((DefaultListModel) list.getModel()).addElement(b);
        ((DefaultComboBoxModel) combo.getModel()).removeElement(b);
        setModified(true);
    }
    
    /**
     * Transfert the {@code b} data from list to combo box.
     *
     * @param bs the data to transfert
     */
    protected void transfertToCombo(B[] bs) {
        for (B b : bs) {
            ((DefaultListModel) list.getModel()).removeElement(b);
            ((DefaultComboBoxModel) combo.getModel()).addElement(b);
        }
        setModified(true);
    }
    
    /**
     * @param enabled databinding
     * @return {@code true} if add button should be enabled
     */
    protected boolean updateAddEnabled(boolean enabled) {
        return enabled && combo.getModel().getSize() > 0;
    }
    
    /**
     * @param enabled databinding
     * @return {@code true} if remove button should be enabled
     */
    protected boolean updateRemoveEnabled(boolean enabled) {
        return enabled && list.getModel().getSize() > 0;
    }
    
    /**
     * Set the data in combo box model.
     *
     * @param toCombo datas to set in combo box model
     */
    protected void setComboDatas(java.util.List<B> toCombo) {
        SwingUtil.fillComboBox(combo, toCombo, null);
        //Note : there is a case when combo was selected, then come here with an empty
        // combo model : no propertyChanged is fired, so add button stays enabled...
        processDataBinding("add.enabled");
    }
    
    /**
     * Set the data in the list model.
     *
     * @param toList datas to set in list model
     */
    protected void setListDatas(java.util.List<B> toList) {
        SwingUtil.fillList(list, toList, null);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ListSelectorUI() {
        $initialize();
    }

    public ListSelectorUI(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$JPanel1.minimumSize".equals($binding)) {    
            addPropertyChangeListener("minimumSize", $DataSource5);
        } else if ("list.cellRenderer".equals($binding)) {    
            addPropertyChangeListener("renderer", $DataSource6);
        } else if ("list.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource7);
        } else if ("combo.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource9);
        } else if ("combo.renderer".equals($binding)) {    
            addPropertyChangeListener("renderer", $DataSource11);
        } else if ("add.enabled".equals($binding)) {    
            if (combo != null) {
                combo.addPropertyChangeListener("enabled", $DataSource13);
            }
            if (combo != null) {
                $bindingSources.put("combo", combo);
                combo.addItemListener( Util.getEventListener(ItemListener.class, $JPanel0, "$pr$u0"));
            }
        } else if ("add.toolTipText".equals($binding)) {    
            addPropertyChangeListener("addToListTip", $DataSource14);
        } else if ("remove.enabled".equals($binding)) {    
            if (list != null) {
                list.addPropertyChangeListener("enabled", $DataSource16);
            }
            if (list != null) {
                $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                list.getSelectionModel().addListSelectionListener( Util.getEventListener(ListSelectionListener.class, $JPanel0, "$pr$u1"));
                list.addPropertyChangeListener("selectionModel", Util.getDataBindingUpdateListener(this , "remove.enabled"));
            }
        } else if ("remove.toolTipText".equals($binding)) {    
            addPropertyChangeListener("addToComboTip", $DataSource17);
        } else if ("hidor.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource19);
        } else if ("hidor.visible".equals($binding)) {    
            addPropertyChangeListener("showHidor", $DataSource23);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JPanel1.minimumSize".equals($dest)) {
                $JPanel1.setMinimumSize(getMinimumSize());
            } else if ("list.cellRenderer".equals($dest)) {
                list.setCellRenderer(getRenderer());
            } else if ("list.enabled".equals($dest)) {
                list.setEnabled(isEnabled());
            } else if ("combo.enabled".equals($dest)) {
                combo.setEnabled(isEnabled());
            } else if ("combo.renderer".equals($dest)) {
                combo.setRenderer(getRenderer());
            } else if ("add.enabled".equals($dest)) {
                if (combo != null) {
                    add.setEnabled(updateAddEnabled(combo.isEnabled() && combo.getSelectedIndex() > -1));
                }
            } else if ("add.toolTipText".equals($dest)) {
                add.setToolTipText(_(getAddToListTip()));
            } else if ("remove.enabled".equals($dest)) {
                if (list != null) {
                    remove.setEnabled(updateRemoveEnabled(list.isEnabled() && list.getSelectedIndex() > -1));
                }
            } else if ("remove.toolTipText".equals($dest)) {
                remove.setToolTipText(_(getAddToComboTip()));
            } else if ("hidor.enabled".equals($dest)) {
                hidor.setEnabled(isEnabled());
            } else if ("hidor.visible".equals($dest)) {
                hidor.setVisible(isShowHidor());
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$JPanel1.minimumSize".equals($binding)) {    
            removePropertyChangeListener("minimumSize", $DataSource5);
        } else if ("list.cellRenderer".equals($binding)) {    
            removePropertyChangeListener("renderer", $DataSource6);
        } else if ("list.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource7);
        } else if ("combo.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource9);
        } else if ("combo.renderer".equals($binding)) {    
            removePropertyChangeListener("renderer", $DataSource11);
        } else if ("add.enabled".equals($binding)) {    
            if (combo != null) {
                combo.removePropertyChangeListener("enabled", $DataSource13);
            }
            if (combo != null) {
                javax.swing.JComboBox $target = ((javax.swing.JComboBox) $bindingSources.remove("combo"));
                if ($target != null) {
                    $target.removeItemListener( Util.getEventListener(ItemListener.class, $JPanel0, "$pr$u0"));
                }
            }
        } else if ("add.toolTipText".equals($binding)) {    
            removePropertyChangeListener("addToListTip", $DataSource14);
        } else if ("remove.enabled".equals($binding)) {    
            if (list != null) {
                list.removePropertyChangeListener("enabled", $DataSource16);
            }
            if (list != null) {
                javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("list.getSelectionModel()"));
                if ($target != null) {
                    $target.removeListSelectionListener( Util.getEventListener(ListSelectionListener.class, $JPanel0, "$pr$u1"));
                }
                list.removePropertyChangeListener("selectionModel", Util.getDataBindingUpdateListener(this, "remove.enabled"));
            }
        } else if ("remove.toolTipText".equals($binding)) {    
            removePropertyChangeListener("addToComboTip", $DataSource17);
        } else if ("hidor.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource19);
        } else if ("hidor.visible".equals($binding)) {    
            removePropertyChangeListener("showHidor", $DataSource23);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__add(java.awt.event.ActionEvent event) {
        transfertToList((B) combo.getSelectedItem());
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        transfertToCombo((B[]) list.getSelectedValues());
    }

    public void doMouseClicked__on__list(java.awt.event.MouseEvent event) {
        if (event.getClickCount()==2) { transfertToCombo((B[]) list.getSelectedValues()); };
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JToolBar getActions() {
        return actions;
    }

    public javax.swing.JButton getAdd() {
        return add;
    }

    public java.lang.String getAddToComboTip() {
        return addToComboTip;
    }

    public java.lang.String getAddToListTip() {
        return addToListTip;
    }

    public javax.swing.JComboBox getCombo() {
        return combo;
    }

    public jaxx.runtime.swing.Table getHeader() {
        return header;
    }

    public jaxx.runtime.swing.HidorButton getHidor() {
        return hidor;
    }

    public javax.swing.JList getList() {
        return list;
    }

    public javax.swing.JScrollPane getListPane() {
        return listPane;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.ListCellRenderer getRenderer() {
        return renderer;
    }

    public java.lang.Boolean getShowHidor() {
        return showHidor;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isShowHidor() {
        return showHidor !=null && showHidor;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAddToComboTip(java.lang.String newValue) {
        java.lang.String oldValue = this.addToComboTip;
        this.addToComboTip = newValue;
        firePropertyChange(PROPERTY_ADD_TO_COMBO_TIP, oldValue, newValue);
    }

    public void setAddToListTip(java.lang.String newValue) {
        java.lang.String oldValue = this.addToListTip;
        this.addToListTip = newValue;
        firePropertyChange(PROPERTY_ADD_TO_LIST_TIP, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setRenderer(javax.swing.ListCellRenderer newValue) {
        javax.swing.ListCellRenderer oldValue = this.renderer;
        this.renderer = newValue;
        firePropertyChange(PROPERTY_RENDERER, oldValue, newValue);
    }

    public void setShowHidor(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showHidor;
        this.showHidor = newValue;
        firePropertyChange(PROPERTY_SHOW_HIDOR, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(java.awt.event.ItemEvent event) {
        $DataSource13.propertyChange(null);
    }

    public void $pr$u1(javax.swing.event.ListSelectionEvent event) {
        $DataSource16.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(listPane, BorderLayout.CENTER);
        add(header, BorderLayout.SOUTH);
        addChildrenToListPane();
        // inline complete setup of $JPanel1
        $JPanel1.add(list, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToActions();
        // init data bindings
        listPane.setColumnHeaderView(header);
        applyDataBinding("$JPanel1.minimumSize");
        applyDataBinding("list.cellRenderer");
        applyDataBinding("list.enabled");
        list.setModel(new DefaultListModel());
        applyDataBinding("combo.enabled");
        combo.setModel(new DefaultComboBoxModel());
        applyDataBinding("combo.renderer");
        add.setIcon(jaxx.runtime.Util.createActionIcon("add"));
        applyDataBinding("add.enabled");
        applyDataBinding("add.toolTipText");
        remove.setIcon(jaxx.runtime.Util.createActionIcon("remove"));
        applyDataBinding("remove.enabled");
        applyDataBinding("remove.toolTipText");
        hidor.setCollapseTip(_("listSelector.hideList"));
        applyDataBinding("hidor.enabled");
        hidor.setExpandTip(_("listSelector.showList"));
        hidor.setTarget(list);
        hidor.setTargetVisible(true);
        applyDataBinding("hidor.visible");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createShowHidor();
        createModified();
        createAddToListTip();
        createAddToComboTip();
        createRenderer();
        createListPane();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createList();
        createHeader();
        createCombo();
        createActions();
        createAdd();
        createRemove();
        createHidor();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        hidor.addPropertyChangeListener("targetVisible", new PropertyChangeListener() {
        
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
                if (!showHidor || !isEnabled()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable() {
        
                    @Override
                    public void run() {
                        log.info("invalidate " + getParent().getName());
                        listPane.invalidate();
                    }
                });
            }
        });$completeSetup();
    }

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(add);
        actions.add(remove);
        actions.add(hidor);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add(combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add(actions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToListPane() {
        if (!allComponentsCreated) {
            return;
        }
        listPane.getViewport().add($JPanel1);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new javax.swing.JToolBar());
        actions.setName("actions");
        actions.setFloatable(false);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new javax.swing.JButton());
        add.setName("add");
        add.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createAddToComboTip() {
        $objectMap.put("addToComboTip", addToComboTip = "-");
    }

    protected void createAddToListTip() {
        $objectMap.put("addToListTip", addToListTip = "+");
    }

    protected void createCombo() {
        $objectMap.put("combo", combo = new javax.swing.JComboBox());
        combo.setName("combo");
    }

    protected void createHeader() {
        $objectMap.put("header", header = new jaxx.runtime.swing.Table());
        header.setName("header");
    }

    protected void createHidor() {
        $objectMap.put("hidor", hidor = new jaxx.runtime.swing.HidorButton());
        hidor.removeDataBinding("hidor.name");
        hidor.setName("hidor");
        hidor.removeDataBinding("hidor.collapseTip");
        hidor.removeDataBinding("hidor.enabled");
        hidor.removeDataBinding("hidor.expandTip");
        hidor.removeDataBinding("hidor.target");
        hidor.removeDataBinding("hidor.targetVisible");
        hidor.removeDataBinding("hidor.visible");
    }

    protected void createList() {
        $objectMap.put("list", list = new javax.swing.JList());
        list.setName("list");
        if (list.getFont() != null) {
            list.setFont(list.getFont().deriveFont((float) 11));
        }
        list.addMouseListener(Util.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__list"));
    }

    protected void createListPane() {
        $objectMap.put("listPane", listPane = new javax.swing.JScrollPane());
        listPane.setName("listPane");
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new javax.swing.JButton());
        remove.setName("remove");
        remove.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createRenderer() {
        $objectMap.put("renderer", renderer = null);
    }

    protected void createShowHidor() {
        $objectMap.put("showHidor", showHidor = false);
    }

}