package jaxx.runtime.swing.editor;

import jaxx.runtime.swing.editor.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import javax.swing.table.TableColumn;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.renderer.I18nTableCellRenderer;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnSelector extends javax.swing.JPanel implements PropertyChangeListener,  ActionListener, jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.ColumnSelector.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRj9qLTQ8lOqBAJGVEKMiVv0KAQRkEhTlAgxxF6cdgcYMt0ZZmdh8WD8E/wT9O7FxJsn48GzBy/Gf8EYD16N38yWLoVCG+hht5l535v3vX3fvP8FSV/BtW0Sho4KPM0q1Mk/WF9/UtqmZb1A/bJiUgsF0a8tAYkidLm1dV/DjWLBlOeq5bl5UZHCo96h6qkCZHy9z6m/RanWcKW+ouz7udXa9lQoA3XAWhPViPXtn9+JN+7rdwmAUKK6TmxlrFlV3El7ARLM1TCAJ+2SHCfeJspQzNtEvT1mbZ4T339MKnQHXkFHAVKSKCTTcL31li2HrQ+lhs7x/ArxKJ/UcLNOqb+H5zrUZViLsnlQ8VYpx28glJS2PqWho7K/Rkqcaug38hwj2Yk+VQzqlkIG8hnzmUVejJFzQnBKvBiatFANgwYTVjXkV8ziMvWCGJixwAIpUY5+1aHtooEN1NDZ8VXrwpLHNCOcvaTqjoYJ228ZrWKcKicyyjmGPHToeH4NFc8RdVfDpbpDq+sGmK7hU6VAa+FpGD6C3dzkdM7uGeSIxJiM1JmPAXTiAMYJaStCUgW4rGGoeDyzT3ErSuvQkbQaQrv7bzD7/dPPj4sHEe3Fsy83hB6aMIyOVEJSpZk5ui/KZ6AZzy0TOVWEtF+NBu6ONhB2kBwUh+dFCTDlziPibyFFsuPH5y+DL75dgMQiZLgg7iIx+CVI6y2FLgjuhvL+rFXUvdeJz36jDT3mZF+gldA77RJNxkrMc9HlmRBNGG1gQk1JKf31b3b1w+yBEW0obPhEeGxG8jmkmMeZR+20Vgex4XR2SZ8GrogHrtEItpl3RlZTNmGftxp2WhLKpTZit8PAvBwr2/ybtCzZFlg6qGcG1twy01EbY0TjHYNRpTONaQdboG3XNNRm997ZOXqiBlcI8zR1TyEbbYEsvYEp0qbVcxKlhCQ7wXlZ2lk5GvYTPt3VphxmeeEUFc0Z8CbeEOXAb25wK1xpy9XE4FaI+pTgXOxS9TBK5jnpOqOrKOI5s9saujRe6WtMrp0ebEP1H2M22Gm1CAAA";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected javax.swing.JToggleButton button;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected java.lang.Object myTable;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.JLabel popupLabel;
    protected java.lang.Boolean popupVisible;
    private ColumnSelector $JPanel0 = this;
    private javax.swing.JToolBar $JToolBar2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource6 = new DataBindingListener(this, "button.selected");

    /* begin raw body code */
    public static final String TABLE_PROPERTY = "myTable";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        }
        //log.info(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        if (TABLE_PROPERTY.equals(name)) {
            // table has changed, rebuild the popup
            try {
                
                popup.removeAll();
                JTable t = (JTable) evt.getNewValue();
                if (t != null) {
                    log.info("table has changed ! " + t.getName());
                    for (int i = 0, columnCount = t.getColumnCount(); i < columnCount; i++) {
                        TableColumn column = t.getColumnModel().getColumn(i);
                        TableCellRenderer defaultRenderer = t.getTableHeader().getDefaultRenderer();
                        String columnName = column.getHeaderValue() + "";
                        if (defaultRenderer instanceof I18nTableCellRenderer) {
                            I18nTableCellRenderer renderer = (I18nTableCellRenderer) defaultRenderer;
                            columnName = _(renderer.getKeys()[i]);
                        }
                        JRadioButtonMenuItem b = new JRadioButtonMenuItem(columnName, null, true);
                        popup.add(b);
                        b.addActionListener(this);
                        b.putClientProperty("columnIndex", i);
                        b.putClientProperty("columnName", columnName);
                        b.putClientProperty("column", column);
                    }
                }
            } finally {
                popup.invalidate();
            }
            return;
        }
        if (POPUP_VISIBLE_PROPERTY.equals(name)) {
            Boolean newValue = (Boolean) evt.getNewValue();
            if (newValue == null || !newValue) {
                if (getPopup() != null && getPopup().isVisible()) {
                    getPopup().setVisible(false);
                }
                return;
            }
            if (!getPopup().isVisible()) {
                SwingUtilities.invokeLater(showPopupRunnable);
            }
            return;
        }
        
    }
    
    @Override
    public void actionPerformed(ActionEvent event) {
        JRadioButtonMenuItem source = (JRadioButtonMenuItem) event.getSource();
        boolean selected = source.isSelected();
        TableColumn column = (TableColumn) source.getClientProperty("column");
        Integer columnIndex = (Integer) source.getClientProperty("columnIndex");
        String columnName = (String) source.getClientProperty("columnName");
        log.info(columnName + ", selected : " + selected);
        JTable t = (JTable) myTable;
        if (selected) {
            // reinject the column in table
            t.getColumnModel().addColumn(column);
        } else {
            // remove column from table
            t.getColumnModel().removeColumn(column);
        }
    }protected Runnable showPopupRunnable;
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ColumnSelector() {
        $initialize();
    }

    public ColumnSelector(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("button.selected".equals($binding)) {    
            if (popup != null) {
                $bindingSources.put("popup", popup);
                popup.addComponentListener( Util.getEventListener(ComponentListener.class, $JPanel0, "$pr$u0"));
            }
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("button.selected".equals($dest)) {
                if (popup != null) {
                    button.setSelected(popup.isVisible());
                }
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("button.selected".equals($binding)) {    
            if (popup != null) {
                javax.swing.JPopupMenu $target = ((javax.swing.JPopupMenu) $bindingSources.remove("popup"));
                if ($target != null) {
                    $target.removeComponentListener( Util.getEventListener(ComponentListener.class, $JPanel0, "$pr$u0"));
                }
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doFocusGained__on__$JPanel0(java.awt.event.FocusEvent event) {
        button.requestFocus();
    }

    public void doFocusLost__on__$JPanel0(java.awt.event.FocusEvent event) {
        setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(java.awt.event.ItemEvent event) {
        if (event.getStateChange()  == ItemEvent.SELECTED) { setPopupVisible(true); } else { popupVisible = false; };
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JToggleButton getButton() {
        return button;
    }

    public java.lang.Object getMyTable() {
        return myTable;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public java.lang.Boolean getPopupVisible() {
        return popupVisible;
    }

    public java.lang.Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setMyTable(java.lang.Object newValue) {
        java.lang.Object oldValue = this.myTable;
        this.myTable = newValue;
        firePropertyChange("myTable", oldValue, newValue);
    }

    public void setPopupVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        firePropertyChange("popupVisible", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(java.awt.event.ComponentEvent event) {
        $DataSource6.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JToolBar get$JToolBar2() {
        return $JToolBar2;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($JToolBar2);
        addChildrenToPopup();
        // inline complete setup of $JToolBar2
        $JToolBar2.add(button, BorderLayout.CENTER);
        // init data bindings
        popup.setBorder(new TitledBorder(_("i18neditor.popup.title")));
        button.setIcon(jaxx.runtime.Util.createActionIcon("numbereditor-calculator"));
        applyDataBinding("button.selected");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createMyTable();
        createPopupVisible();
        createPopup();
        createPopupLabel();
        create$ScriptInitializer1();
        // inline creation of $JToolBar2
        $objectMap.put("$JToolBar2", $JToolBar2 = new javax.swing.JToolBar());
        $JToolBar2.setName("$JToolBar2");
        $JToolBar2.setBorderPainted(false);
        $JToolBar2.setFloatable(false);
        $JToolBar2.setOpaque(false);
        createButton();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(Util.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener(Util.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$JPanel0"));
        
        addPropertyChangeListener(TABLE_PROPERTY,this);addPropertyChangeListener(POPUP_VISIBLE_PROPERTY,this);$completeSetup();
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupLabel);
    }

    protected void create$ScriptInitializer1() {
        showPopupRunnable = new Runnable() {
            @Override
            public void run() {
                getPopup().pack();
                Dimension dim = getPopup().getPreferredSize();
                JToggleButton invoker = getButton();
                getPopup().show(invoker, (int) (invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
            }
        };
    }

    protected void createButton() {
        $objectMap.put("button", button = new javax.swing.JToggleButton());
        button.setName("button");
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setFocusable(true);
        button.setRolloverEnabled(false);
        button.setToolTipText(_("columnselector.action.tip"));
        button.addItemListener(Util.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__button"));
    }

    protected void createMyTable() {
        $objectMap.put("myTable", myTable = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        popup.setName("popup");
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new javax.swing.JLabel());
        popupLabel.setName("popupLabel");
        popupLabel.setEnabled(false);
        popupLabel.setText(_("i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = false);
    }

}