/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.jaxx.runtime.swing.model.JaxxDefaultListModel;

public class JaxxFilterableListModel<E>
extends JaxxDefaultListModel<E> {
    private static final long serialVersionUID = 1L;
    protected final ArrayList<E> filteredItems = Lists.newArrayList();
    protected String filterText;
    protected JXPathDecorator<E> decorator;
    protected final List<Predicate<E>> filters = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getElementAt(int index) {
        E result;
        JaxxFilterableListModel jaxxFilterableListModel = this;
        synchronized (jaxxFilterableListModel) {
            result = index >= 0 && index < this.filteredItems.size() ? (E)this.filteredItems.get(index) : null;
        }
        return result;
    }

    @Override
    public E elementAt(int index) {
        return this.getElementAt(index);
    }

    @Override
    public void addElement(E o) {
        super.addElement(o);
        this.refilter();
    }

    @Override
    public boolean removeElement(E o) {
        boolean result = super.removeElement(o);
        this.refilter();
        return result;
    }

    @Override
    public int getSize() {
        return this.filteredItems.size();
    }

    @Override
    public int size() {
        return this.filteredItems.size();
    }

    @Override
    public void trimToSize() {
        super.trimToSize();
        this.filteredItems.trimToSize();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        super.ensureCapacity(minCapacity);
        this.filteredItems.ensureCapacity(minCapacity);
    }

    @Override
    public void setSize(int newSize) {
        super.setSize(newSize);
        this.filteredItems.ensureCapacity(newSize);
    }

    @Override
    public void setElementAt(E element, int index) {
        super.setElementAt(element, index);
        this.refilter();
    }

    @Override
    public void removeElementAt(int index) {
        super.removeElementAt(index);
        this.refilter();
    }

    @Override
    public void insertElementAt(E element, int index) {
        super.insertElementAt(element, index);
        this.refilter();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.refilter();
    }

    @Override
    public E set(int index, E element) {
        E rv = super.set(index, element);
        this.refilter();
        return rv;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.refilter();
    }

    @Override
    public void setAllElements(Collection<E> objects) {
        super.setAllElements(objects);
        this.refilter();
    }

    @Override
    public void addAllElements(Collection<E> elements) {
        super.addAllElements(elements);
        this.refilter();
    }

    @Override
    public void removeAllElements(Collection<E> elements) {
        super.removeAllElements(elements);
        this.refilter();
    }

    @Override
    public E remove(int index) {
        Object rv = super.remove(index);
        this.refilter();
        return rv;
    }

    @Override
    public void clear() {
        super.clear();
        this.refilter();
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.refilter();
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        this.filterText = filterText;
        this.refilter();
    }

    public JXPathDecorator<E> getDecorator() {
        return this.decorator;
    }

    public void setDecorator(JXPathDecorator<E> decorator) {
        this.decorator = decorator;
    }

    public void addFilter(Predicate<E> filter) {
        this.filters.add(filter);
        this.refilter();
    }

    public void removeFilter(Predicate<E> filter) {
        this.filters.remove(filter);
        this.refilter();
    }

    public void clearFilters() {
        this.filters.clear();
        this.refilter();
    }

    public void refreshFilteredElements() {
        this.refilter();
    }

    protected void refilter() {
        this.filteredItems.clear();
        if (StringUtils.isEmpty((CharSequence)StringUtils.remove((String)this.filterText, (char)'*')) && this.filters.isEmpty()) {
            this.filteredItems.addAll(this.delegate);
        } else {
            Pattern pattern = null;
            if (!StringUtils.isBlank((CharSequence)this.filterText)) {
                String patternText = Pattern.quote(this.filterText).replace("*", "\\E.*\\Q") + ".*";
                pattern = Pattern.compile(patternText, 2);
            }
            for (Object element : this.delegate) {
                boolean addElement = true;
                for (Predicate<E> filter : this.filters) {
                    addElement &= filter.test(element);
                }
                String decoratedElement = this.decorator != null ? this.decorator.toString(element) : String.valueOf(element);
                boolean matches = pattern == null || pattern.matcher(decoratedElement).matches();
                if (!matches || !addElement) continue;
                this.filteredItems.add(element);
            }
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

