/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.field;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldExpressionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CollectionUniqueKeyValidator
extends FieldExpressionValidator {
    protected String collectionFieldName;
    protected String[] keys;
    protected String againstProperty;
    protected String againstIndexExpression;

    public String getCollectionFieldName() {
        return this.collectionFieldName;
    }

    public void setCollectionFieldName(String collectionFieldName) {
        this.collectionFieldName = collectionFieldName;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys != null && keys.length == 1 && keys[0].indexOf(",") != -1 ? keys[0].split(",") : keys;
    }

    public String getAgainstProperty() {
        return this.againstProperty;
    }

    public void setAgainstProperty(String againstProperty) {
        this.againstProperty = againstProperty;
    }

    public String getAgainstIndexExpression() {
        return this.againstIndexExpression;
    }

    public void setAgainstIndexExpression(String againstIndexExpression) {
        this.againstIndexExpression = againstIndexExpression;
    }

    public void validate(Object object) throws ValidationException {
        Integer againstIndex;
        if (this.keys == null || this.keys.length == 0) {
            throw new ValidationException("no unique keys defined");
        }
        String fieldName = this.getFieldName();
        Collection<?> col = this.getCollection(object);
        Object againstBean = this.againstProperty == null ? null : this.getFieldValue(this.againstProperty, object);
        Integer n = againstIndex = this.againstIndexExpression == null ? Integer.valueOf(-1) : this.getFieldValue(this.againstIndexExpression, object);
        if (againstIndex == null) {
            againstIndex = -1;
        }
        if (againstBean == null && col.size() < 2) {
            return;
        }
        boolean answer = true;
        Integer againstHashCode = againstBean == null ? null : this.getUniqueKeyHashCode(againstBean);
        ArrayList<Integer> hashCodes = new ArrayList<Integer>();
        int index = 0;
        for (Object o : col) {
            Integer hash = this.getUniqueKeyHashCode(o);
            if (againstBean == null) {
                if (hashCodes.contains(hash)) {
                    answer = false;
                    break;
                }
            } else if (againstIndex != -1) {
                if (index != againstIndex && hash.equals(againstHashCode)) {
                    answer = false;
                    break;
                }
            } else if (!againstBean.equals(o) && hash.equals(againstHashCode)) {
                answer = false;
                break;
            }
            hashCodes.add(hash);
            ++index;
        }
        if (!answer) {
            this.addFieldError(fieldName, object);
        }
    }

    protected Integer getUniqueKeyHashCode(Object o) throws ValidationException {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (String key : this.keys) {
            Object property = this.getFieldValue(key, o);
            builder.append(property);
        }
        return builder.toHashCode();
    }

    protected Collection<?> getCollection(Object object) throws ValidationException {
        String fieldName = this.getCollectionFieldName();
        if (fieldName == null || fieldName.trim().isEmpty()) {
            fieldName = this.getFieldName();
        }
        Object obj = null;
        try {
            obj = this.getFieldValue(fieldName, object);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        if (!Collection.class.isInstance(obj)) {
            throw new ValidationException("field " + fieldName + " is not a collection type! (" + obj.getClass() + ")");
        }
        return (Collection)obj;
    }

    public String getValidatorType() {
        return "collectionUniqueKey";
    }
}

