/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.File;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginWithEncoding;
import org.nuiton.util.FileUtil;

public abstract class AbstractJaxxMojo
extends AbstractPlugin
implements PluginWithEncoding {
    @Component
    private MavenProject project;
    @Parameter(property="jaxx.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="jaxx.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="jaxx.force", defaultValue="false")
    private boolean force;
    @Parameter(property="jaxx.generateHelp", defaultValue="false")
    protected boolean generateHelp;

    public abstract File getTargetDirectory();

    public abstract void setTargetDirectory(File var1);

    protected boolean checkPackaging() {
        return this.hasClassPath();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    protected Long getLastModified(File dir) {
        if (!dir.exists()) {
            return null;
        }
        GetLastModifiedFileAction fileAction = new GetLastModifiedFileAction(dir);
        FileUtil.walkAfter((File)dir, (FileUtil.FileAction)fileAction);
        return fileAction.getLastFile().lastModified();
    }

    public static class JaxxFileUpdater
    extends MirroredFileUpdater {
        protected JaxxFileUpdater(File sourceDirectory, File destinationDirectory) {
            super(".jaxx|*.css", ".java", sourceDirectory, destinationDirectory);
        }

        public File getMirrorFile(File f) {
            String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
            String extension = FileUtil.extension((File)f, (String[])new String[0]);
            String mirrorRelativePath = file.substring(0, file.length() - extension.length()) + "java";
            return new File(this.destinationDirectory + File.separator + mirrorRelativePath);
        }
    }

    class GetLastModifiedFileAction
    implements FileUtil.FileAction {
        protected File lastFile;

        public GetLastModifiedFileAction(File lastFile) {
            this.lastFile = lastFile;
        }

        public boolean doAction(File f) {
            if (f.lastModified() > this.lastFile.lastModified()) {
                this.lastFile = f;
            }
            return true;
        }

        public File getLastFile() {
            return this.lastFile;
        }
    }
}

