package jaxx.demo.fun;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class LabelStyleDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_ADD = "blue.style.blue.hasFocus().add";
    public static final String BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_REMOVE = "blue.style.blue.hasFocus().remove";
    public static final String BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_ADD = "green.style.green.hasFocus().add";
    public static final String BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_REMOVE = "green.style.green.hasFocus().remove";
    public static final String BINDING_RED_STYLE_RED_HAS_FOCUS_ADD = "red.style.red.hasFocus().add";
    public static final String BINDING_RED_STYLE_RED_HAS_FOCUS_REMOVE = "red.style.red.hasFocus().remove";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL5_FONT_SIZE = "$JLabel5.font-size";
    private static final String BINDING_$JLABEL5_FOREGROUND = "$JLabel5.foreground";
    private static final String BINDING_$JLABEL5_TEXT = "$JLabel5.text";
    private static final String BINDING_$JRADIO_BUTTON0_ENABLED = "$JRadioButton0.enabled";
    private static final String BINDING_$JRADIO_BUTTON1_ENABLED = "$JRadioButton1.enabled";
    private static final String BINDING_$JRADIO_BUTTON2_ENABLED = "$JRadioButton2.enabled";
    private static final String BINDING_$JRADIO_BUTTON3_ENABLED = "$JRadioButton3.enabled";
    private static final String BINDING_$JRADIO_BUTTON4_ENABLED = "$JRadioButton4.enabled";
    private static final String BINDING_$JRADIO_BUTTON5_ENABLED = "$JRadioButton5.enabled";
    private static final String BINDING_$JRADIO_BUTTON6_ENABLED = "$JRadioButton6.enabled";
    private static final String BINDING_$VBOX0_BACKGROUND = "$VBox0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XTW8bRRgeO3EcJyFpEyWENqCUBCmFdu18IkhUYscNEAxFdQSFXBh7J/Ym+8XsbLppVcRP4B9QDnDiguBQiVPFgTMHLogzN4Q4cEXMzK7X3ngzO3QbRavdmfd93ud5Z+bZ9bd/gpyDwZUj6HkKdk2iGUjZK9+5c6txhJqkipwm1mxiYeD/ZbIgewBG1XDcIWDhoMbSi0F6cccybMtEZk/2Zg2MOORUR04bIULA89GMpuMU6+H0pme7uIMakopDffj3X9kv1M+/ygLg2ZTdJSplPimrq2SwBrKaSsAkrXQCizo0W5QG1swW5fsMG9vRoeO8Bw30KfgM5GtgyIaYghHworxkjsHzPZuA0cUqMqz3oYn0EgFznKxKR5RD11RqsIF03ggWZNs8bYiAgtrJIWA2os+5S9kq+7Chc4qFMCW/yAdL7HGcXcbCqeHFPV6I1p9kIr0AxR9lQRNh7CBBHpU7E4nbp2O7GtLVaGwHd5k9T0XnBjCijZ6KwNR1TUWYxxGQa1o63U1noFZioHItjJDJHi4Lc1djcgcbuouSU9diUguqaxinde1eT36v9M6SRlvKR6OxQ4sfVCyPRj4bs5JsisW90tfV9ZCTcgaK97sUXePJBmwet7DlmupOGzWPG5ZHwHSEGh8Pyq2GieOLe7ehqlkVlxDLLPH91pPUMyfK45ReF0WsJEasJkasJUasJ0ZsxERM9DSPbQ963GOWirmkj/EmDbXpacXgciSO2prStbWu72QOQA67dJh296DfCW/TKd8DZ894IAPks//OTP364+8/7HaMb5PWno4N7fFtakg2tmyEicZKT/iu5xJNL74L7c0DUHCQTk2fm/pcDLF6ME3J0XoXWbrC0pW3oNOmELn8b49/mvnklwGQ3QUjugXVXcji3wYF0sa0C5auevYb25zR2N1her3AuBFKDGom2deaxw7zHOwij8qfi5EfcmgUfv5nqv7ddqcFGUrpuXPDu23IfQyGNFPXTMTdPzD2WLcftR3kqlbXwOMsHVBTzwdeFjj2LX6txwnNI5PZMvXCK/f7j6iiOT5hpC5dfeC5DOZDro3dfcRKjfVu3oR6A9QhGhamxAi4fr/C7/wVOVWaGEGCbho2OfUnlpavzQf/Vx8QcMGARxZmK1K3YZPudwKy6yU2rplnx5dLsVTDrkRs9jyy2diamY3YkpmV/oq9Fv1/liRsUSm2RTW6U4IOcTNQKrXyzju8S0LV9O7QaroOW2sJ+ewQdDcETV64+Wq5Wq7G6fRfpv2FEqWeqVBZYTXiKvjv2KdRo1xlVeJq8HfxE5UY0uGpRQ8AGN9SIYHzDc1U6ba40Vclw64jdvIeCD5zJrd8Z5iHhH4GNlyCzsGcTMRkw1+zyzfxCNOpEWYldOUN6GmGawhgLknA5E5g8N30xCBJal6QQvhegDAvhfAoNYJIxUJqFS+lViGHIFKxlFrFy1J7UzMT9mYyTFIzZIgELwA2/zAe5ZoMShtprTYRcElGYcNfpuTR478CpKIE0lTbwto9yyRQL+tayzToG0EgTwZyyIC4pZkpUS6esG/Y5tOjVTikKq87wW+7c1q2ItP8QwujxOYnI4UnNBXCHwKENZkT6vjfW4LuJsMkmc2GBJHRRvd3lgDqNQmoYSf4wE6FkyRKDuGRYH2kEDILAg5bqVXIIYhUSCEIVdxIrUIOQaRCCkGoYju1CjkEkQopBKGKSmoVcggiFVIIQhXV1CrkEEQqpBCEKnZTq5BDEKlgCP8B8A+obEEYAAA=";
    private static final Log log = LogFactory.getLog(LabelStyleDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox backgroundCheckbox;
    protected JAXXButtonGroup backgroundColor;
    protected JSlider blue;
    protected Table demoPanel;
    protected JSlider dummySize;
    protected JSlider green;
    protected JSlider red;
    protected JTextField text;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private LabelStyleDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JPanel $JPanel0;
    private JRadioButton $JRadioButton0;
    private JRadioButton $JRadioButton1;
    private JRadioButton $JRadioButton2;
    private JRadioButton $JRadioButton3;
    private JRadioButton $JRadioButton4;
    private JRadioButton $JRadioButton5;
    private JRadioButton $JRadioButton6;
    private Table $Table0;
    private VBox $VBox0;
    private VBox $VBox1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LabelStyleDemo() {
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public LabelStyleDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LabelStyleDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LabelStyleDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getBackgroundCheckbox() {
        return backgroundCheckbox;
    }

    public JAXXButtonGroup getBackgroundColor() {
        return backgroundColor;
    }

    public JSlider getBlue() {
        return blue;
    }

    public Table getDemoPanel() {
        return demoPanel;
    }

    public JSlider getDummySize() {
        return dummySize;
    }

    public JSlider getGreen() {
        return green;
    }

    public JSlider getRed() {
        return red;
    }

    public JTextField getText() {
        return text;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected JRadioButton get$JRadioButton2() {
        return $JRadioButton2;
    }

    protected JRadioButton get$JRadioButton3() {
        return $JRadioButton3;
    }

    protected JRadioButton get$JRadioButton4() {
        return $JRadioButton4;
    }

    protected JRadioButton get$JRadioButton5() {
        return $JRadioButton5;
    }

    protected JRadioButton get$JRadioButton6() {
        return $JRadioButton6;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    protected VBox get$VBox1() {
        return $VBox1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        demoPanel.add($Table0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(6, 3, 0, 0), 0, 0));
        demoPanel.add($VBox1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBackgroundCheckbox() {
        $objectMap.put("backgroundCheckbox", backgroundCheckbox = new JCheckBox());
        
        backgroundCheckbox.setName("backgroundCheckbox");
        backgroundCheckbox.setText(t("Show Background"));
    }

    protected void createBackgroundColor() {
        $objectMap.put("backgroundColor", backgroundColor = new JAXXButtonGroup());
    }

    protected void createBlue() {
        $objectMap.put("blue", blue = new JSlider());
        
        blue.setName("blue");
        blue.setValue(0);
        blue.setMaximum(255);
        blue.setValue(255);
        blue.setPaintTicks(true);
        blue.setMajorTickSpacing(50);
        blue.setMinorTickSpacing(10);
    }

    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = new Table());
        
        demoPanel.setName("demoPanel");
    }

    protected void createDummySize() {
        $objectMap.put("dummySize", dummySize = new JSlider());
        
        dummySize.setName("dummySize");
        dummySize.setValue(0);
        dummySize.setMaximum(60);
        dummySize.setMinimum(6);
        dummySize.setValue(36);
        dummySize.setPaintTicks(true);
        dummySize.setMajorTickSpacing(6);
        dummySize.setMinorTickSpacing(2);
    }

    protected void createGreen() {
        $objectMap.put("green", green = new JSlider());
        
        green.setName("green");
        green.setValue(0);
        green.setMaximum(255);
        green.setValue(0);
        green.setPaintTicks(true);
        green.setMajorTickSpacing(50);
        green.setMinorTickSpacing(10);
    }

    protected void createRed() {
        $objectMap.put("red", red = new JSlider());
        
        red.setName("red");
        red.setValue(0);
        red.setMaximum(255);
        red.setValue(128);
        red.setPaintTicks(true);
        red.setMajorTickSpacing(50);
        red.setMinorTickSpacing(10);
    }

    protected void createText() {
        $objectMap.put("text", text = new JTextField());
        
        text.setName("text");
        text.setColumns(15);
        text.setText(t("Data Binding"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add(demoPanel);
        addChildrenToDemoPanel();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(text, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(red, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(green, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(blue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(dummySize, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JLabel5);
        // inline complete setup of $VBox1
        $VBox1.add(backgroundCheckbox);
        $VBox1.add($JRadioButton0);
        $VBox1.add($JRadioButton1);
        $VBox1.add($JRadioButton2);
        $VBox1.add($JRadioButton3);
        $VBox1.add($JRadioButton4);
        $VBox1.add($JRadioButton5);
        $VBox1.add($JRadioButton6);
        // inline complete setup of $JRadioButton0
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
        
        // inline complete setup of $JRadioButton1
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
        
        // inline complete setup of $JRadioButton2
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton2); }
        
        // inline complete setup of $JRadioButton3
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton3); }
        
        // inline complete setup of $JRadioButton4
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton4); }
        
        // inline complete setup of $JRadioButton5
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton5.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton5); }
        
        // inline complete setup of $JRadioButton6
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton6.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton6); }
        
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Preview"));
        $VBox1.setBorder(BorderFactory.createTitledBorder("Background"));
        { $JRadioButton0.putClientProperty("$value", Color.RED);  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton1.putClientProperty("$value", Color.ORANGE);  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton2.putClientProperty("$value", Color.YELLOW);  Object $buttonGroup = $JRadioButton2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton3.putClientProperty("$value", Color.GREEN);  Object $buttonGroup = $JRadioButton3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton4.putClientProperty("$value", Color.CYAN);  Object $buttonGroup = $JRadioButton4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton5.putClientProperty("$value", Color.BLUE);  Object $buttonGroup = $JRadioButton5.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton6.putClientProperty("$value", new Color(160, 30, 255));  Object $buttonGroup = $JRadioButton6.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        red.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        green.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        blue.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoPanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Text:"));
        createText();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Red:"));
        createRed();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("Green:"));
        createGreen();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("Blue:"));
        createBlue();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("Size:"));
        createDummySize();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,90);
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setMargin(new Insets(0, 0, 0, 0));
        $VBox0.setVerticalAlignment(0);
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        // inline creation of $VBox1
        $objectMap.put("$VBox1", $VBox1 = new VBox());
        
        $VBox1.setName("$VBox1");
        $VBox1.setSpacing(0);
        createBackgroundCheckbox();
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(t("Red"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(t("Orange"));
        // inline creation of $JRadioButton2
        $objectMap.put("$JRadioButton2", $JRadioButton2 = new JRadioButton());
        
        $JRadioButton2.setName("$JRadioButton2");
        $JRadioButton2.setText(t("Yellow"));
        // inline creation of $JRadioButton3
        $objectMap.put("$JRadioButton3", $JRadioButton3 = new JRadioButton());
        
        $JRadioButton3.setName("$JRadioButton3");
        $JRadioButton3.setText(t("Green"));
        // inline creation of $JRadioButton4
        $objectMap.put("$JRadioButton4", $JRadioButton4 = new JRadioButton());
        
        $JRadioButton4.setName("$JRadioButton4");
        $JRadioButton4.setText(t("Cyan"));
        // inline creation of $JRadioButton5
        $objectMap.put("$JRadioButton5", $JRadioButton5 = new JRadioButton());
        
        $JRadioButton5.setName("$JRadioButton5");
        $JRadioButton5.setText(t("Blue"));
        // inline creation of $JRadioButton6
        $objectMap.put("$JRadioButton6", $JRadioButton6 = new JRadioButton());
        
        $JRadioButton6.setName("$JRadioButton6");
        $JRadioButton6.setText(t("Purple"));
        createBackgroundColor();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$VBOX0_BACKGROUND, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$VBOX0_BACKGROUND));
                }
                if (backgroundColor != null) {
                    backgroundColor.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null && backgroundColor != null) {
                    $VBox0.setBackground((Color)( backgroundCheckbox.isSelected() ? backgroundColor.getSelectedValue() : null));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$VBOX0_BACKGROUND));
                }
                if (backgroundColor != null) {
                    backgroundColor.removePropertyChangeListener("selectedValue", this);
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (dummySize != null) {
                    $bindingSources.put("dummySize.getModel()", dummySize.getModel());
                    dummySize.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    dummySize.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FONT_SIZE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (dummySize != null) {
                    if ($JLabel5.getFont() != null) {
                        $JLabel5.setFont($JLabel5.getFont().deriveFont((float) dummySize.getValue()));
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (dummySize != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("dummySize.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    dummySize.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FONT_SIZE));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_FOREGROUND, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red.getModel()", red.getModel());
                    red.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    red.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (green != null) {
                    $bindingSources.put("green.getModel()", green.getModel());
                    green.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    green.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (blue != null) {
                    $bindingSources.put("blue.getModel()", blue.getModel());
                    blue.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    blue.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red != null && blue != null && green != null) {
                    $JLabel5.setForeground(new Color(red.getValue(), green.getValue(), blue.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("red.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    red.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (green != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("green.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    green.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (blue != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("blue.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    blue.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (text != null) {
                    $bindingSources.put("text.getDocument()", text.getDocument());
                    text.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u3"));
                    text.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (text != null) {
                    $JLabel5.setText(t(text.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (text != null) {
                    Document $target = (Document) $bindingSources.remove("text.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u3"));
                    }
                    text.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_TEXT));
                }
            }
        
            public void $pr$u3(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RED_STYLE_RED_HAS_FOCUS_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red", red);
                    red.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u4"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red.hasFocus()) {
                    Object value = Pseudoclasses.applyProperty(LabelStyleDemo.this, red, "border", new DataBinding("red.border.0"), Pseudoclasses.wrap(red.getBorder()), 0);
                    if (!(value instanceof DataBinding)) {
                        red.setBorder((Border) value);
                    }
                    value = Pseudoclasses.applyProperty(LabelStyleDemo.this, red, "background", new Color(231, 173, 173), Pseudoclasses.wrap(red.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        red.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    JSlider $target = (JSlider) $bindingSources.remove("red");
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u4"));
                    }
                }
            }
        
            public void $pr$u4(FocusEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RED_STYLE_RED_HAS_FOCUS_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red", red);
                    red.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u5"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(red.hasFocus())) {
                    Object value = Pseudoclasses.removeProperty(LabelStyleDemo.this, red, "border", new DataBinding("red.border.0"), Pseudoclasses.wrap(red.getBorder()), 0);
                    if (!(value instanceof DataBinding)) {
                        red.setBorder((Border) value);
                    }
                    value = Pseudoclasses.removeProperty(LabelStyleDemo.this, red, "background", new Color(231, 173, 173), Pseudoclasses.wrap(red.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        red.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    JSlider $target = (JSlider) $bindingSources.remove("red");
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u5"));
                    }
                }
            }
        
            public void $pr$u5(FocusEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (green != null) {
                    $bindingSources.put("green", green);
                    green.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u6"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (green.hasFocus()) {
                    Object value = Pseudoclasses.applyProperty(LabelStyleDemo.this, green, "border", new DataBinding("green.border.0"), Pseudoclasses.wrap(green.getBorder()), 0);
                    if (!(value instanceof DataBinding)) {
                        green.setBorder((Border) value);
                    }
                    value = Pseudoclasses.applyProperty(LabelStyleDemo.this, green, "background", new Color(178, 231, 173), Pseudoclasses.wrap(green.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        green.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (green != null) {
                    JSlider $target = (JSlider) $bindingSources.remove("green");
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u6"));
                    }
                }
            }
        
            public void $pr$u6(FocusEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (green != null) {
                    $bindingSources.put("green", green);
                    green.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u7"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(green.hasFocus())) {
                    Object value = Pseudoclasses.removeProperty(LabelStyleDemo.this, green, "border", new DataBinding("green.border.0"), Pseudoclasses.wrap(green.getBorder()), 0);
                    if (!(value instanceof DataBinding)) {
                        green.setBorder((Border) value);
                    }
                    value = Pseudoclasses.removeProperty(LabelStyleDemo.this, green, "background", new Color(178, 231, 173), Pseudoclasses.wrap(green.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        green.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (green != null) {
                    JSlider $target = (JSlider) $bindingSources.remove("green");
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u7"));
                    }
                }
            }
        
            public void $pr$u7(FocusEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (blue != null) {
                    $bindingSources.put("blue", blue);
                    blue.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u8"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (blue.hasFocus()) {
                    Object value = Pseudoclasses.applyProperty(LabelStyleDemo.this, blue, "border", new DataBinding("blue.border.0"), Pseudoclasses.wrap(blue.getBorder()), 0);
                    if (!(value instanceof DataBinding)) {
                        blue.setBorder((Border) value);
                    }
                    value = Pseudoclasses.applyProperty(LabelStyleDemo.this, blue, "background", new Color(173, 178, 231), Pseudoclasses.wrap(blue.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        blue.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (blue != null) {
                    JSlider $target = (JSlider) $bindingSources.remove("blue");
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u8"));
                    }
                }
            }
        
            public void $pr$u8(FocusEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (blue != null) {
                    $bindingSources.put("blue", blue);
                    blue.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u9"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(blue.hasFocus())) {
                    Object value = Pseudoclasses.removeProperty(LabelStyleDemo.this, blue, "border", new DataBinding("blue.border.0"), Pseudoclasses.wrap(blue.getBorder()), 0);
                    if (!(value instanceof DataBinding)) {
                        blue.setBorder((Border) value);
                    }
                    value = Pseudoclasses.removeProperty(LabelStyleDemo.this, blue, "background", new Color(173, 178, 231), Pseudoclasses.wrap(blue.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        blue.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (blue != null) {
                    JSlider $target = (JSlider) $bindingSources.remove("blue");
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u9"));
                    }
                }
            }
        
            public void $pr$u9(FocusEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton0.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON0_ENABLED));
                }
            }
        
            public void $pr$u10(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON1_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON1_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton1.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON1_ENABLED));
                }
            }
        
            public void $pr$u11(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton2.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON2_ENABLED));
                }
            }
        
            public void $pr$u12(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON3_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON3_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton3.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON3_ENABLED));
                }
            }
        
            public void $pr$u13(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON4_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON4_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton4.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON4_ENABLED));
                }
            }
        
            public void $pr$u14(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON5_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u15"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON5_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton5.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u15"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON5_ENABLED));
                }
            }
        
            public void $pr$u15(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON6_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u16"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON6_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton6.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u16"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON6_ENABLED));
                }
            }
        
            public void $pr$u16(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}