package jaxx.demo.feature.nav.content;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ActorContentUI extends AbstractContentUI<People> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ICON = "$JLabel0.icon";
    private static final String BINDING_$JTEXT_PANE0_TEXT = "$JTextPane0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VQU8TQRidVgqUgmArhQZMEBsTDW7lXKJUhEhTlViMxF6c3R3aIbO74+wsLByMP8GfoHcvJt48GQ+ePXgx/gVjPHg1frNtd62u0Fh7oGS+77153zfvwcsvKOUKdH4P+74mPFtSi2jVys7OXX2PGPImcQ1BuXQEan8SSZRsoIwZnrsSXWjUFLzUgZfWHIs7NrF/QZdraMyVh4y4LUKkROd6EYbrluphuexzT3RZQ1FxrM+/fU0+M5++SCLkc1A3AqMsnISKJhmqoSQ1JcrCTfu4xLDdBBmC2k3QO6HO1hh23TvYIo/REzRSQ8McCyCTaLH/kQOOAO9ziXLFiu5KgQ255tgSEPc3r0q0FIg2ieVouwRLTxDNxvua0W7RKgYQhv2cB3TDEg2ZWGKJChEaGqikxNW2iMMZiVrTLmdUbmGbSJRXo/maewCTatV6t6A60yFgolitG8JhTJVA4kwvKCyp9skQlSlWt4kvO5jpHky3oFqz8fcsq8OzvZSjxWoN64QBX7aHLzhVTbMc3n2u593BUVrkqOjJEw2UEh4cSzTb+NOE96DUtt/sb/ZThEH1Rz738c3n1xtdz03B3dOxrb9EBrzAhcOJUG8j0WTbcJ6krHQb83IDnocwYrTzNB8jrN4pgzi474yCawqu3cJuCyhSI5/evss/+nAKJTfQGHOwuYFV/yZKy5aALTjM9Pn11UDR+MGoEq60wU7Bt9uOZ7TWfY5tE+sM9pVdoTajNlnAEvKge5Jc82Ep8zFLCZXp6fffc/VXq93FJEBo4a/t0XJSD9Fw+7Ygjp2kxcYvw13imU6UqLiMJdT3FO9YfzH4eTFu8owjKOQFSwrJQqdXVJgWdGqb4C4YV+EuB3Oo35b6ph2HddMj8oDQZkuqrkv/zjWsO8IkQtWX41lyfbAUWjDpEQyJWTtqN7DYchg1DgckntlXjjb+L606Lh/DkO9D2CgxqVRWPmb//fCkd2FrV9RzDkg0JOGP30BDnbSWQl8MqwMxQGYsalPLs+qdlQwkZn1AMbnI1xVGm7YFaT6Gcq6fd6LwP/cEjp+sThzGNAkAAA==";
    private static final Log log = LogFactory.getLog(ActorContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected People data;
    protected JSplitPane splitPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ActorContentUI $AbstractContentUI0 = this;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTextPane $JTextPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ActorContentUI() {
        $initialize();
    }

    public ActorContentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ActorContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ActorContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ActorContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ActorContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ActorContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ActorContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public People getData() {
        return data;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(People data) {
        People oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTextPane get$JTextPane0() {
        return $JTextPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JScrollPane0, JSplitPane.LEFT);
        splitPane.add($JScrollPane1, JSplitPane.RIGHT);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $AbstractContentUI0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JTextPane0);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JLabel0);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        $JTextPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.actor.title")));
        $JScrollPane1.setBorder(new TitledBorder("Picture"));
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        $JScrollPane1.setMinimumSize(SwingUtil.newMinDimension());
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        createSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JTextPane0
        $objectMap.put("$JTextPane0", $JTextPane0 = new JTextPane());
        
        $JTextPane0.setName("$JTextPane0");
        $JTextPane0.setEditable(false);
        if ($JTextPane0.getFont() != null) {
            $JTextPane0.setFont($JTextPane0.getFont().deriveFont((float) 11));
        }
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_PANE0_TEXT, true ,"data") {
        
            @Override
            public void processDataBinding() {
                $JTextPane0.setText(t(getHandler().getContent(getData())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ICON, true ,"data") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setIcon(getHandler().getImage(getData()));
            }
        });
    }

}