/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding;

import java.util.ArrayList;
import java.util.List;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataBindingHelper;
import jaxx.compiler.binding.DataListener;
import jaxx.compiler.binding.DataSource;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.types.TypeManager;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataBinding {
    protected static final Log log = LogFactory.getLog(DataBinding.class);
    private String id;
    private String realId;
    protected String constantId;
    private String source;
    private String assignment;
    private boolean quickNoDependencies;
    protected DataSource dataSource;
    protected String processDataBinding;
    protected String initDataBinding;
    protected final List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private boolean compiled;

    public DataBinding(String id, String source, String assignment, boolean quickNoDependencies) {
        this.id = id;
        this.source = source;
        this.assignment = assignment;
        this.quickNoDependencies = quickNoDependencies;
        if (log.isDebugEnabled()) {
            log.debug((Object)("id=" + id + " assignement=" + assignment + " source=" + source + " quickNoDependencies=" + quickNoDependencies));
        }
    }

    public String getAssignment() {
        return this.assignment;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isQuickNoDependencies() {
        return this.quickNoDependencies;
    }

    public String getProcessDataBinding() {
        return this.processDataBinding;
    }

    public String getInitDataBinding() {
        return this.initDataBinding;
    }

    public DataListener[] getTrackers() {
        return this.dataSource == null ? null : this.dataSource.getTrackers();
    }

    public String getRealId() {
        return this.realId;
    }

    public String getConstantId() {
        return this.constantId;
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        b.append("id", (Object)this.id);
        b.append("source", (Object)this.source.trim());
        b.append("assignement", (Object)this.assignment.trim());
        b.append("quickNoDependencies", this.quickNoDependencies);
        if (this.compiled) {
            b.append("realdId", (Object)this.realId);
            b.append("constantId", (Object)this.getConstantId());
            b.append("objectCode", (Object)this.dataSource.getObjectCode());
            DataListener[] trackers = this.dataSource.getTrackers();
            if (trackers.length > 0) {
                b.append("source:trackers", trackers.length);
                for (DataListener d : trackers) {
                    b.append("source:tracker", (Object)d);
                }
            }
        }
        return b.toString();
    }

    public boolean compile(JAXXCompiler compiler) throws CompilerException {
        if (this.compiled) {
            throw new IllegalStateException(this + " has already been compiled");
        }
        DataBindingHelper bindingHelper = compiler.getBindingHelper();
        this.realId = bindingHelper.getSafeId(this.id.trim());
        this.constantId = TypeManager.convertVariableNameToConstantName("binding_" + this.realId);
        this.dataSource = new DataSource(this.realId, this.constantId, this.getSource(), compiler, this.methods);
        boolean binding = this.dataSource.compile();
        if (!binding) {
            bindingHelper.revertSafeId(this.id.trim());
        }
        this.compiled = true;
        if (DataBindingHelper.SHOW_LOG || log.isDebugEnabled()) {
            if (binding) {
                log.info((Object)("detect a databinding : " + this));
            } else {
                log.info((Object)("reject a databinding : " + this.getSource()));
            }
        }
        this.initDataBinding = this.getInitDataBindingCode(compiler, this.dataSource, binding);
        this.processDataBinding = this.getProcessDataBindingCode(compiler, this.dataSource, binding);
        return binding;
    }

    protected String getInitDataBindingCode(JAXXCompiler compiler, DataSource dataSource, boolean isBinding) {
        String eol = JAXXCompiler.getLineSeparator();
        if (isBinding) {
            return null;
        }
        if (this.isQuickNoDependencies() && !this.id.endsWith(".layout")) {
            return this.getAssignment() + eol;
        }
        return null;
    }

    protected String getProcessDataBindingCode(JAXXCompiler compiler, DataSource dataSource, boolean isBinding) {
        boolean needTest;
        if (!isBinding) {
            return null;
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder buffer = new StringBuilder();
        String objectCode = dataSource.getObjectCode();
        boolean bl = needTest = objectCode != null && !objectCode.trim().isEmpty() && !compiler.getRootObject().getId().equals(objectCode + " != null");
        if (needTest) {
            buffer.append("if (").append(objectCode).append(") {").append(eol);
        }
        buffer.append(JavaFileGenerator.indent(this.getAssignment(), needTest ? 4 : 0, false, eol));
        if (needTest) {
            buffer.append(eol).append("}");
        }
        return buffer.toString();
    }
}

