/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.tab;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.util.beans.BeanUtil;

public class CustomTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CustomTab.class);
    protected final TabContentModel model;
    protected final TabContainerHandler handler;
    protected final JLabel title = new JLabel();
    private final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public TabContentModel getModel() {
        return this.model;
    }

    public CustomTab(TabContentModel model, TabContainerHandler handler) {
        super(new FlowLayout(0, 0, 0));
        this.model = model;
        this.handler = handler;
        try {
            BeanUtil.addPropertyChangeListener(evt -> this.updateTitle(), (Object)this.model);
        }
        catch (Exception ex) {
            log.error((Object)"Error while adding the listener to the model modifications", (Throwable)ex);
        }
        this.setBackground(null);
        this.updateTitle();
        String actionIcon = model.getIcon();
        if (actionIcon != null) {
            this.title.setIcon(SwingUtil.createActionIcon((String)actionIcon));
        }
        this.title.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.add(this.title);
        if (model.isCloseable()) {
            TabButton button = new TabButton();
            this.add(button);
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    @Override
    public void setBackground(Color bg) {
        if (bg == null) {
            bg = new Color(0, 0, 0, 0);
        }
        super.setBackground(bg);
        this.revalidate();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.title != null) {
            this.title.setForeground(fg);
        }
    }

    protected void updateTitle() {
        int style;
        Font f = UIManager.getDefaults().getFont("Label.font");
        String titleValue = I18n.t((String)this.model.getTitle(), (Object[])new Object[0]);
        if (this.model.isModify()) {
            style = 1;
            titleValue = titleValue + "*";
        } else {
            style = this.model.isEmpty() ? 2 : 0;
        }
        this.title.setText(titleValue);
        this.title.setFont(f.deriveFont(style));
    }

    protected class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText(I18n.t((String)"jaxx.application.tab.customtab.close.label", (Object[])new Object[0]));
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(CustomTab.this.buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CustomTab.this.handler != null) {
                JTabbedPane tabPanel = CustomTab.this.handler.getTabPanel();
                int i = tabPanel.indexOfTabComponent(CustomTab.this);
                CustomTab.this.handler.removeTab(i);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            } else {
                g2.setColor(Color.BLACK);
            }
            int delta = 5;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

