/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterEntry;
import org.nuiton.eugene.writer.ChainedWriterEngine;
import org.nuiton.plugin.AbstractPlugin;

public class SmartGenerateMojo
extends AbstractPlugin
implements ChainedFileWriterConfiguration {
    protected String[] inputs;
    protected String skipInputs;
    protected File outputDirectory;
    protected boolean overwrite;
    protected boolean verbose;
    protected String encoding;
    protected boolean testPhase;
    protected String modelType;
    protected Map<String, Object> properties;
    protected boolean dryRun;
    protected String fullPackagePath;
    protected String resolver;
    protected String templates;
    protected String[] excludeTemplates;
    protected String defaultPackage;
    protected String generatedPackages;
    protected MavenProject project;
    protected Settings settings;
    protected Map<String, Model> _models;
    protected Map<String, ChainedFileWriter> writers;
    protected Map<String, ModelReader<?>> modelReaders;
    protected Map<String, Template<?>> modelTemplates;
    protected ChainedWriterEngine engine;
    protected ClassLoader fixedClassLoader;

    protected void init() throws Exception {
        this.modelType = this.modelType.trim().toLowerCase();
        Model model = this._models.get(this.modelType);
        if (model == null) {
            throw new MojoExecutionException("No modelType named '" + this.modelType + "', use one of " + this._models.keySet());
        }
        if (this.inputs.length == 0) {
            throw new MojoExecutionException("Must specify something to include using the includes property");
        }
        this.engine.setConfiguration((ChainedFileWriterConfiguration)this);
        Set availableWriters = this.engine.getAvailableWriters();
        if (availableWriters.isEmpty()) {
            throw new MojoExecutionException("Could not find any writer in class-path.");
        }
        for (ChainedFileWriter writer : availableWriters) {
            if (!(writer instanceof BaseChainedFileWriter)) continue;
            ((BaseChainedFileWriter)writer).setLog(this.getLog());
        }
        for (String include : this.inputs) {
            this.getLog().info((CharSequence)("Register include : " + include));
            this.engine.registerInclude(include);
        }
        if (this.engine.getSelectedWriters().isEmpty()) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        if (this.engine.containsWriter("xmi")) {
            this.properties.put("fullPackagePath", this.fullPackagePath);
            this.properties.put("resolver", this.resolver);
        }
        if (this.engine.containsWriter("model")) {
            this.properties.put("defaultPackage", this.defaultPackage);
            this.properties.put("generatedPackages", this.generatedPackages);
            this.properties.put("templates", this.templates);
            this.properties.put("excludetemplates", this.getExcludeTemplatesAsString());
        }
    }

    protected boolean checkSkip() {
        if (this.engine.getSelectedWriters().isEmpty()) {
            this.getLog().warn((CharSequence)"No phase was detected, skip the goal.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().warn((CharSequence)"dryRun property is set, no file will be generated.");
        }
        if (this.isVerbose() && this.isTestPhase()) {
            this.getLog().info((CharSequence)" using testPhase");
        }
        try {
            ArrayList<String> skipInputList = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)this.skipInputs)) {
                for (String s : this.skipInputs.split(",")) {
                    skipInputList.add(s.trim());
                }
            }
            for (ChainedFileWriter writer : this.engine.getSelectedWriters()) {
                if (skipInputList.contains(writer.getInputProtocol())) {
                    this.getLog().info((CharSequence)("Skip phase [" + writer.getInputProtocol() + "] as required in skipInputs configuration."));
                    continue;
                }
                int size = writer.getEntries().size();
                if (size == 1) {
                    this.getLog().info((CharSequence)("Process phase [" + writer.getInputProtocol() + "] for one entry."));
                } else {
                    this.getLog().info((CharSequence)("Process phase [" + writer.getInputProtocol() + "] for " + size + " entries."));
                }
                if (this.dryRun || this.isVerbose()) {
                    for (ChainedFileWriterEntry entry : writer.getEntries()) {
                        this.getLog().info((CharSequence)(" entry : " + entry.getInputDirectory() + " - " + entry.getIncludePattern()));
                    }
                    if (this.dryRun) continue;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Generating files and copying resources...");
                }
                writer.generate((ChainedFileWriterConfiguration)this);
                if (!"model".equals(writer.getInputProtocol())) continue;
                File outputDir = writer.getOutputDirectory(this.getOutputDirectory(), this.isTestPhase());
                this.fixCompileSourceRoots(outputDir);
            }
        }
        finally {
            this.properties.clear();
            this.engine.clear();
        }
    }

    public void setInputs(String inputs) {
        this.inputs = new String[]{inputs};
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        try {
            return this.getFixedClassLoader();
        }
        catch (MojoExecutionException e) {
            throw new IllegalStateException("could not obtain classLoader", e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isOffline() {
        return this.settings.isOffline();
    }

    public boolean isTestPhase() {
        return this.testPhase;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Map<String, ChainedFileWriter> getWriters() {
        return this.writers;
    }

    public Map<String, ModelReader<?>> getModelReaders() {
        return this.modelReaders;
    }

    public Map<String, Template<?>> getModelTemplates() {
        return this.modelTemplates;
    }

    public File getBasedir() {
        return this.getProject().getBasedir();
    }

    protected String getExcludeTemplatesAsString() {
        String result = "";
        for (int i = 0; i < this.excludeTemplates.length; ++i) {
            result = result + this.excludeTemplates[i];
            if (i == this.excludeTemplates.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public ClassLoader getFixedClassLoader() throws MojoExecutionException {
        if (this.fixedClassLoader == null) {
            HashSet urlsAsString = new HashSet();
            ArrayList urls = new ArrayList();
            try {
                if (this.testPhase) {
                    File extraClassPathDirectory = new File(this.getProject().getBuild().getOutputDirectory());
                    this.getLog().info((CharSequence)("Add in generator's classLoader : " + extraClassPathDirectory));
                    this.addDirectoryToUrlsList(extraClassPathDirectory, urls, urlsAsString);
                }
                if (this.project.getProjectReferences() != null) {
                    Iterator i$ = this.project.getProjectReferences().entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = i$.next();
                        MavenProject relatedProject = (MavenProject)entry.getValue();
                        if (this.verbose) {
                            this.getLog().info((CharSequence)("Add project reference in generator's classLoader : '" + relatedProject.getArtifact() + "'"));
                        }
                        if (relatedProject.getArtifact().getFile() == null) continue;
                        this.addDirectoryToUrlsList(relatedProject.getArtifact().getFile(), urls, urlsAsString);
                    }
                }
                if (!this.project.getArtifacts().isEmpty()) {
                    if (this.verbose) {
                        this.getLog().info((CharSequence)"Use resolved artifacts to build class-path");
                    }
                    for (Map.Entry o : this.project.getArtifacts()) {
                        Artifact a = (Artifact)o;
                        if (a.getScope().equals("provided")) continue;
                        this.addDirectoryToUrlsList(a.getFile(), urls, urlsAsString);
                    }
                }
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().info((CharSequence)("original classloader " + loader));
                }
                if (loader instanceof URLClassLoader) {
                    for (URL u : ((URLClassLoader)loader).getURLs()) {
                        this.addUrlToUrlsList(u, urls, urlsAsString);
                        if (!this.getLog().isDebugEnabled()) continue;
                        this.getLog().debug((CharSequence)("original cp entry: " + u));
                    }
                    if (loader.getParent() != null) {
                        loader = loader.getParent();
                    }
                }
                if (!urls.isEmpty()) {
                    loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), loader);
                }
                if (this.getLog().isDebugEnabled()) {
                    for (URL u : urls) {
                        this.getLog().debug((CharSequence)("cp entry: " + u));
                    }
                }
                this.fixedClassLoader = loader;
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            finally {
                urls.clear();
                urlsAsString.clear();
            }
        }
        return this.fixedClassLoader;
    }

    protected void fixCompileSourceRoots(File destDirGen) {
        if (this.project == null) {
            return;
        }
        if (this.isTestPhase()) {
            if (!this.project.getTestCompileSourceRoots().contains(destDirGen.getPath())) {
                this.getLog().info((CharSequence)("Add test compile source root : " + destDirGen));
                this.project.addTestCompileSourceRoot(destDirGen.getPath());
                Resource resources = new Resource();
                resources.setDirectory(destDirGen.getAbsolutePath());
                resources.setExcludes(Arrays.asList("**/*.java"));
                this.getLog().info((CharSequence)("Add test resource root :" + resources));
                this.project.addTestResource(resources);
            }
        } else if (!this.project.getCompileSourceRoots().contains(destDirGen.getPath())) {
            this.getLog().info((CharSequence)("Add compile source root : " + destDirGen));
            this.project.addCompileSourceRoot(destDirGen.getPath());
            Resource resources = new Resource();
            resources.setDirectory(destDirGen.getAbsolutePath());
            resources.setExcludes(Arrays.asList("**/*.java"));
            this.getLog().info((CharSequence)("Add resource root :" + resources));
            this.project.addResource(resources);
        }
    }
}

