/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.nuiton.eugene.DefaultTemplateConfiguration;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.TemplateConfiguration;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.reader.InvalidModelPropertiesException;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterData;
import org.nuiton.eugene.writer.ChainedFileWriterEntry;
import org.nuiton.eugene.writer.ChainedFileWriterToMemoryModel;
import org.nuiton.eugene.writer.ChainedWriterEngine;
import org.nuiton.eugene.writer.WriterReport;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginWithEncoding;
import org.nuiton.util.StringUtil;

@Mojo(name="generate", requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateMojo
extends AbstractPlugin
implements ChainedFileWriterConfiguration,
PluginWithEncoding {
    @Parameter(property="eugene.inputs", required=true)
    protected String[] inputs;
    @Parameter(property="eugene.skipInputs")
    protected String skipInputs;
    @Parameter(property="eugene.outputDirectory", defaultValue="target/generated-sources", required=true)
    protected File outputDirectory;
    @Parameter(property="eugene.extractDirectory", defaultValue="target/extracted-sources", required=true)
    protected File extractDirectory;
    @Parameter(property="eugene.overwrite", defaultValue="false")
    protected boolean overwrite;
    @Parameter(property="eugene.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="eugene.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="eugene.testPhase", defaultValue="false")
    protected boolean testPhase;
    @Parameter(property="eugene.modelType", defaultValue="objectmodel", required=true)
    protected String modelType;
    @Parameter
    protected Map<String, Object> properties;
    @Parameter(property="eugene.dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="generator.fullPackagePath", defaultValue="${project.groupId}.${project.artifactId}")
    protected String fullPackagePath;
    @Parameter(property="generator.resolver", defaultValue="org.nuiton.util.ResourceResolver")
    protected String resolver;
    @Parameter(property="eugene.templates")
    protected String templates;
    @Parameter(property="eugene.excludeTemplates")
    protected String[] excludeTemplates;
    @Parameter(property="eugene.defaultPackage", defaultValue="${project.groupId}.${project.artifactId}")
    protected String defaultPackage;
    @Parameter(property="eugene.generatedPackages")
    protected String generatedPackages;
    @Parameter(property="eugene.extractedPackages", defaultValue="${project.groupId}.${project.artifactId}")
    protected String extractedPackages;
    @Parameter(property="eugene.failIfUnsafe", defaultValue="true")
    protected boolean failIfUnsafe;
    @Parameter(property="eugene.modelExtensionFile")
    protected File modelExtensionFile;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Component(role=Model.class)
    protected Map<String, Model> _models;
    @Component(role=ChainedFileWriter.class)
    protected Map<String, ChainedFileWriter> writers;
    @Component(role=ModelReader.class)
    protected Map<String, ModelReader<?>> modelReaders;
    @Component(role=Template.class)
    protected Map<String, Template<?>> modelTemplates;
    @Component(role=ChainedWriterEngine.class)
    protected ChainedWriterEngine engine;
    protected ModelHelper modelHelper;
    protected ClassLoader fixedClassLoader;
    protected List<Template<Model>> templateList;

    protected WriterReport newWriterReport() {
        return new WriterReport(){

            public void addFile(String entry, File file, boolean b) {
                super.addFile(entry, file, b);
                if (b || GenerateMojo.this.isVerbose()) {
                    GenerateMojo.this.getLog().info((CharSequence)("Will generate " + file));
                }
                if (GenerateMojo.this.getLog().isDebugEnabled()) {
                    GenerateMojo.this.getLog().debug((CharSequence)String.format("[%1$s] Will generate %2$s", entry, file));
                }
            }

            public void addResource(String entry, File file, boolean b) {
                super.addResource(entry, file, b);
                if (b || GenerateMojo.this.isVerbose()) {
                    GenerateMojo.this.getLog().info((CharSequence)("Will copy resource " + file));
                }
                if (GenerateMojo.this.getLog().isDebugEnabled()) {
                    GenerateMojo.this.getLog().debug((CharSequence)String.format("[%1$s] Will copy resource %2$s", entry, file));
                }
            }
        };
    }

    protected void init() throws Exception {
        if (this.getLog().isDebugEnabled()) {
            this.verbose = true;
        }
        this.modelHelper = new ModelHelper(this._models, this.modelReaders);
        this.modelType = this.modelType.trim().toLowerCase();
        Model model = this.modelHelper.getModel(this.modelType);
        if (model == null) {
            throw new MojoExecutionException("No modelType named '" + this.modelType + "', use one of " + this._models.keySet());
        }
        if (this.inputs.length == 0) {
            throw new MojoExecutionException("Must specify something to include using the includes property");
        }
        this.engine.init((ChainedFileWriterConfiguration)this);
        Set availableWriters = this.engine.getAvailableWriters();
        if (availableWriters.isEmpty()) {
            throw new MojoExecutionException("Could not find any writer in class-path.");
        }
        for (ChainedFileWriter writer : availableWriters) {
            if (writer instanceof BaseChainedFileWriter) {
                ((BaseChainedFileWriter)writer).setLog(this.getLog());
            }
            writer.setWriterReport(this.newWriterReport());
        }
        for (String include : this.inputs) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Register include : " + include));
            }
            this.engine.registerInclude(include);
        }
        if (this.engine.getSelectedWriters().isEmpty()) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        if (this.engine.containsWriter("xmi")) {
            this.properties.put("fullPackagePath", this.fullPackagePath);
            this.properties.put("extraPackages", this.extractedPackages);
            this.properties.put("resolver", this.resolver);
        }
        if (this.engine.containsWriter("model")) {
            this.properties.put("failIfUnsafe", this.failIfUnsafe);
        }
        this.templateList = this.initTemplates();
    }

    protected boolean checkSkip() {
        if (this.engine.getSelectedWriters().isEmpty()) {
            this.getLog().warn((CharSequence)"No phase was detected, skip the goal.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().warn((CharSequence)"dryRun property is set, no file will be generated.");
        }
        if (this.isVerbose() && this.isTestPhase()) {
            this.getLog().info((CharSequence)" using testPhase");
        }
        try {
            ArrayList<String> skipInputList = new ArrayList<String>();
            if (!StringUtils.isEmpty((CharSequence)this.skipInputs)) {
                for (String s : this.skipInputs.split(",")) {
                    skipInputList.add(s.trim());
                }
            }
            HashSet<ChainedFileWriterToMemoryModel> models = new HashSet<ChainedFileWriterToMemoryModel>();
            for (ChainedFileWriter writer : this.engine.getSelectedWriters()) {
                if (skipInputList.contains(writer.getInputProtocol())) {
                    this.getLog().info((CharSequence)("Skip phase [" + writer.getInputProtocol() + "] as required in skipInputs configuration."));
                    continue;
                }
                long t0 = System.nanoTime();
                this.getLog().info((CharSequence)("Process phase [" + writer.getInputProtocol() + "]"));
                if (this.dryRun || this.isVerbose()) {
                    for (ChainedFileWriterEntry entry : writer.getEntries()) {
                        this.getLog().info((CharSequence)(" entry : " + entry));
                    }
                    if (this.dryRun) continue;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Generating files and copying resources...");
                }
                ChainedFileWriterData data = this.engine.getData(writer);
                try {
                    writer.generate((ChainedFileWriterConfiguration)this, data);
                }
                catch (InvalidModelPropertiesException e) {
                    throw new MojoFailureException("failIfUnsafe flag is on, and some errors occurs while loading model.", (Throwable)e);
                }
                if (writer instanceof ChainedFileWriterToMemoryModel) {
                    ChainedFileWriterToMemoryModel writerToMemoryModel = (ChainedFileWriterToMemoryModel)writer;
                    models.add(writerToMemoryModel);
                    continue;
                }
                WriterReport writerReport = writer.getWriterReport();
                String messageResources = this.reportCopiedResources(writerReport);
                this.getLog().info((CharSequence)messageResources);
                String message = this.reportGeneratedFiles(writerReport, t0);
                this.getLog().info((CharSequence)message);
            }
            if (!models.isEmpty()) {
                long t0 = System.nanoTime();
                WriterReport writerReport = this.newWriterReport();
                this.getLog().info((CharSequence)"Process phase [generator]");
                for (ChainedFileWriterToMemoryModel entry : models) {
                    Model model = entry.getModel();
                    Long lastModified = entry.getLastModifiedSource();
                    File outputDir = entry.getOutputDirectory();
                    this.applyTemplates(model, lastModified, outputDir, this.templateList, writerReport);
                    this.fixCompileSourceRoots(outputDir);
                }
                String message = this.reportGeneratedFiles(writerReport, t0);
                this.getLog().info((CharSequence)message);
            }
        }
        finally {
            this.properties.clear();
            this.engine.clear();
        }
    }

    protected void applyTemplates(Model model, Long lastModifiedSource, File outputDirectory, List<Template<Model>> templateList, WriterReport writerReport) throws IOException {
        for (Template<Model> template : templateList) {
            this.getLog().info((CharSequence)("Apply generator " + template.getClass().getSimpleName()));
            template.setProperty("lastModifiedSource", (Object)lastModifiedSource);
            template.setProperty("writerReport", (Object)writerReport);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)(" overwrite          = " + template.isOverwrite()));
                this.getLog().info((CharSequence)(" encoding           = " + template.getEncoding()));
                this.getLog().info((CharSequence)(" lastModifiedSource = " + template.getLastModifiedSource()));
                this.getLog().info((CharSequence)(" exclude            = " + template.getExcludeTemplates()));
                this.getLog().info((CharSequence)(" output directory   = " + outputDirectory));
            }
            template.applyTemplate(model, outputDirectory);
        }
    }

    public void setInputs(String inputs) {
        this.inputs = new String[]{inputs};
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getExtractDirectory() {
        return this.extractDirectory;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        try {
            return this.getFixedClassLoader();
        }
        catch (MojoExecutionException e) {
            throw new IllegalStateException("could not obtain classLoader", e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isOffline() {
        return this.settings.isOffline();
    }

    public boolean isTestPhase() {
        return this.testPhase;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Map<String, ChainedFileWriter> getWriters() {
        return this.writers;
    }

    public ModelHelper getModelHelper() {
        return this.modelHelper;
    }

    public File getBasedir() {
        return this.getProject().getBasedir();
    }

    public File getModelExtensionFile() {
        return this.modelExtensionFile;
    }

    protected String getExcludeTemplatesAsString() {
        String result = "";
        for (int i = 0; i < this.excludeTemplates.length; ++i) {
            result = result + this.excludeTemplates[i];
            if (i == this.excludeTemplates.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public ClassLoader getFixedClassLoader() throws MojoExecutionException {
        if (this.fixedClassLoader == null) {
            HashSet urlsAsString = new HashSet();
            ArrayList urls = new ArrayList();
            try {
                if (this.testPhase) {
                    File extraClassPathDirectory = new File(this.getProject().getBuild().getOutputDirectory());
                    if (this.verbose) {
                        this.getLog().info((CharSequence)("Add in generator's classLoader : " + extraClassPathDirectory));
                    }
                    this.addDirectoryToUrlsList(extraClassPathDirectory, urls, urlsAsString);
                    this.addDirectoryToUrlsList(new File(this.getProject().getBuild().getTestSourceDirectory()), urls, urlsAsString);
                } else {
                    this.addDirectoryToUrlsList(new File(this.getProject().getBuild().getSourceDirectory()), urls, urlsAsString);
                }
                if (this.project.getProjectReferences() != null) {
                    Iterator iterator = this.project.getProjectReferences().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = iterator.next();
                        MavenProject mavenProject = (MavenProject)entry.getValue();
                        if (this.verbose) {
                            this.getLog().info((CharSequence)("Add project reference in generator's classLoader : '" + mavenProject.getArtifact() + "'"));
                        }
                        if (mavenProject.getArtifact().getFile() == null) continue;
                        this.addDirectoryToUrlsList(mavenProject.getArtifact().getFile(), urls, urlsAsString);
                    }
                }
                if (!this.project.getArtifacts().isEmpty()) {
                    if (this.isVerbose()) {
                        this.getLog().info((CharSequence)"Use resolved artifacts to build class-path");
                    }
                    for (Map.Entry o : this.project.getArtifacts()) {
                        Artifact a = (Artifact)o;
                        if (a.getScope().equals("provided")) continue;
                        this.addDirectoryToUrlsList(a.getFile(), urls, urlsAsString);
                    }
                }
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("original classloader " + loader));
                }
                if (loader instanceof URLClassLoader) {
                    for (Iterator iterator : ((URLClassLoader)loader).getURLs()) {
                        this.addUrlToUrlsList((URL)((Object)iterator), urls, urlsAsString);
                        if (!this.isVerbose()) continue;
                        this.getLog().debug((CharSequence)("original cp entry: " + iterator));
                    }
                    if (loader.getParent() != null) {
                        loader = loader.getParent();
                    }
                }
                if (!urls.isEmpty()) {
                    loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), loader);
                }
                if (this.isVerbose()) {
                    for (URL u : urls) {
                        this.getLog().info((CharSequence)("cp entry: " + u));
                    }
                }
                this.fixedClassLoader = loader;
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            finally {
                urls.clear();
                urlsAsString.clear();
            }
        }
        return this.fixedClassLoader;
    }

    protected void fixCompileSourceRoots(File destDirGen) {
        if (this.project == null) {
            return;
        }
        if (this.isTestPhase()) {
            if (!this.project.getTestCompileSourceRoots().contains(destDirGen.getPath())) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Add test compile source root : " + destDirGen));
                }
                this.project.addTestCompileSourceRoot(destDirGen.getPath());
                Resource resources = new Resource();
                resources.setDirectory(destDirGen.getAbsolutePath());
                resources.setExcludes(Collections.singletonList("**/*.java"));
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Add test resource root :" + resources));
                }
                this.project.addTestResource(resources);
            }
        } else if (!this.project.getCompileSourceRoots().contains(destDirGen.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Add compile source root : " + destDirGen));
            }
            this.project.addCompileSourceRoot(destDirGen.getPath());
            Resource resources = new Resource();
            resources.setDirectory(destDirGen.getAbsolutePath());
            resources.setExcludes(Collections.singletonList("**/*.java"));
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Add resource root :" + resources));
            }
            this.project.addResource(resources);
        }
    }

    protected List<Template<Model>> initTemplates() {
        ClassLoader loader = this.getClassLoader();
        Properties templateProperties = new Properties();
        templateProperties.put("defaultPackage", this.defaultPackage);
        templateProperties.put("encoding", this.getEncoding());
        templateProperties.put("verbose", (Object)this.verbose);
        templateProperties.put("overwrite", (Object)this.isOverwrite());
        templateProperties.put("classLoader", loader);
        templateProperties.put("excludeTemplates", this.getExcludeTemplatesAsString());
        if (StringUtils.isEmpty((CharSequence)this.generatedPackages)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)"generating all packages");
            }
        } else {
            templateProperties.put("generatedPackages", this.generatedPackages);
            if (this.verbose) {
                this.getLog().info((CharSequence)("generating only for packages " + this.generatedPackages));
            }
        }
        ArrayList<Template<Model>> templatesList = new ArrayList<Template<Model>>();
        if (StringUtils.isNotEmpty((CharSequence)this.templates)) {
            String[] templatesNames;
            for (String templateName : templatesNames = this.templates.split(",")) {
                Template template = this.modelTemplates.get(templateName = templateName.trim());
                if (template == null) {
                    this.getLog().warn((CharSequence)("template [" + templateName + "] is not registred via plexus, try to read it directly"));
                    try {
                        template = (Template)Class.forName(templateName, true, loader).newInstance();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Can't obtain template [" + templateName + "] for reason " + e.getMessage(), e);
                    }
                }
                if (this.verbose) {
                    this.getLog().info((CharSequence)("will use the template [" + templateName + "]"));
                }
                templatesList.add(template);
                template.setConfiguration((TemplateConfiguration)new DefaultTemplateConfiguration(templateProperties));
            }
        }
        return templatesList;
    }

    protected String reportGeneratedFiles(WriterReport writerReport, long t0) {
        String result;
        int nbFiles = writerReport.getFilesCount();
        if (nbFiles == 0) {
            result = "No file generated.";
        } else {
            long delay = System.nanoTime() - t0;
            result = nbFiles == 1 ? "Generate one file in " + StringUtil.convertTime((long)delay) + "." : "Generate " + nbFiles + " files in " + StringUtil.convertTime((long)delay) + ".";
        }
        return result;
    }

    protected String reportCopiedResources(WriterReport writerReport) {
        int nbResources = writerReport.getResourcesCount();
        String result = nbResources == 0 ? "No resources copied." : (nbResources == 1 ? "One resource copied." : nbResources + " resources copied.");
        return result;
    }
}

